/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.api.common.impl;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.AccessibilityQuery;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.java.api.common.ant.PackageModifierImplementation;
import org.netbeans.modules.java.api.common.impl.Bundle;
import org.openide.filesystems.FileObject;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;

public final class ExportPackageAction
extends AbstractAction
implements ContextAwareAction {
    @Override
    public void actionPerformed(ActionEvent ev) {
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        if (actionContext != null) {
            PackageModifierImplementation pmi;
            Collection selectedPackagesLookup = actionContext.lookupAll(FileObject.class);
            ArrayList<FileObject> selectedPackages = new ArrayList<FileObject>();
            for (FileObject packageIter : selectedPackagesLookup) {
                selectedPackages.add(packageIter);
            }
            Iterator selectedPackagesIterator = selectedPackages.iterator();
            Project project = null;
            if (selectedPackagesIterator.hasNext()) {
                project = FileOwnerQuery.getOwner((FileObject)((FileObject)selectedPackagesIterator.next()));
                if (project != null) {
                    while (selectedPackagesIterator.hasNext()) {
                        Project tmpProject = FileOwnerQuery.getOwner((FileObject)((FileObject)selectedPackagesIterator.next()));
                        if (project.equals((Object)tmpProject)) continue;
                        return new ContextAction();
                    }
                } else {
                    return new ContextAction();
                }
            }
            if (project != null && (pmi = (PackageModifierImplementation)project.getLookup().lookup(PackageModifierImplementation.class)) != null) {
                ArrayList<String> packagesToExport = new ArrayList<String>();
                boolean export = false;
                for (FileObject selectedPkgIter : selectedPackages) {
                    Boolean isPublic = AccessibilityQuery.isPubliclyAccessible((FileObject)selectedPkgIter);
                    if (isPublic != null) {
                        ClassPath cp = ClassPath.getClassPath((FileObject)selectedPkgIter, (String)"classpath/source");
                        assert (cp != null);
                        String packageName = cp.getResourceName(selectedPkgIter, '.', false);
                        if (!isPublic.booleanValue()) {
                            export = true;
                        }
                        packagesToExport.add(packageName);
                        continue;
                    }
                    return new ContextAction();
                }
                return new ContextAction(pmi, packagesToExport, export);
            }
        }
        return new ContextAction();
    }

    private static final class ContextAction
    extends AbstractAction {
        private Collection<String> packagesToExport;
        private boolean export;
        private PackageModifierImplementation pmi;

        public ContextAction() {
            this(true, false);
        }

        public ContextAction(PackageModifierImplementation pmi, Collection<String> packagesToExport, boolean export) {
            this(export, packagesToExport != null && !packagesToExport.isEmpty());
            this.pmi = pmi;
            this.packagesToExport = packagesToExport;
            this.export = export;
        }

        private ContextAction(boolean export, boolean enable) {
            super(export ? Bundle.CTL_ExportPackageAction() : Bundle.CTL_UnexportPackageAction());
            this.putValue("hideWhenDisabled", true);
            this.setEnabled(enable);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            this.pmi.exportPackageAction(this.packagesToExport, this.export);
        }
    }
}

