/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.api.common.project;

import java.awt.Dialog;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.api.extexecution.startup.StartupExtender;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.project.runner.JavaRunner;
import org.netbeans.api.java.queries.SourceLevelQuery;
import org.netbeans.api.java.queries.UnitTestForSourceQuery;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ui.ScanDialog;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.java.api.common.SourceRoots;
import org.netbeans.modules.java.api.common.ant.UpdateHelper;
import org.netbeans.modules.java.api.common.project.Bundle;
import org.netbeans.modules.java.api.common.project.JavaActionProvider;
import org.netbeans.modules.java.api.common.project.ui.customizer.MainClassChooser;
import org.netbeans.modules.java.api.common.project.ui.customizer.MainClassWarning;
import org.netbeans.modules.java.api.common.util.CommonModuleUtils;
import org.netbeans.modules.java.api.common.util.CommonProjectUtils;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.java.project.support.ProjectPlatform;
import org.netbeans.spi.project.ActionProgress;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.MouseUtils;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.Lookups;

final class ActionProviderSupport {
    private static final Logger LOG = Logger.getLogger(ActionProviderSupport.class.getName());
    private static final String PROP_JAVA_MAIN_ACTION = "java.main.action";
    private static final Pattern SRCDIRJAVA = Pattern.compile("\\.java$");
    private static final String SUBST = "Test.java";
    private static final String SUBSTNG = "NGTest.java";
    private static final Set<String> NO_SYNC_COMMANDS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("build", "clean", "rebuild", "compile.single", "javadoc")));

    private ActionProviderSupport() {
        throw new IllegalStateException("No instance allowed.");
    }

    static void invokeTarget(@NonNull JavaActionProvider.ScriptAction scriptAction, @NonNull JavaActionProvider.Context ctx) {
        String userPropertiesFile = ActionProviderSupport.verifyUserPropertiesFile(ctx);
        JavaModelWork action = new JavaModelWork(scriptAction, ctx, userPropertiesFile);
        Set<ActionFlag> flags = scriptAction.getActionFlags();
        if (flags.contains((Object)ActionFlag.JAVA_MODEL_SENSITIVE) || ctx.getCompileOnSaveOperations().contains((Object)JavaActionProvider.CompileOnSaveOperation.UPDATE) && flags.contains((Object)ActionFlag.SCAN_SENSITIVE)) {
            ScanDialog.runWhenScanFinished((Runnable)action, (String)scriptAction.getDisplayName());
        } else if (flags.contains((Object)ActionFlag.SCAN_SENSITIVE)) {
            try {
                action.needsJavaModel = false;
                ActionProviderSupport.invokeByJavaSource(action);
                if (!action.isCalled()) {
                    action.doJavaChecks = false;
                    action.run();
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        } else {
            action.run();
        }
    }

    static boolean allowAntBuild(@NonNull PropertyEvaluator evaluator, @NonNull UpdateHelper updateHelper) {
        String buildClasses = evaluator.getProperty("build.classes.dir");
        if (buildClasses == null) {
            return false;
        }
        File buildClassesFile = updateHelper.getAntProjectHelper().resolveFile(buildClasses);
        return !new File(buildClassesFile, ".netbeans_automatic_build").exists();
    }

    @CheckForNull
    static JavaPlatform getActivePlatform(@NonNull Project prj, @NonNull PropertyEvaluator eval, @NonNull String activePlatformProperty) {
        JavaPlatform plat = CommonProjectUtils.getActivePlatform(eval.getProperty(activePlatformProperty));
        if (plat == null) {
            plat = ProjectPlatform.forProject((Project)prj, (PropertyEvaluator)eval, (String)"j2se");
        }
        return plat;
    }

    @NonNull
    static final Supplier<? extends String[]> createConditionalTarget(@NonNull PropertyEvaluator eval, @NonNull Predicate<PropertyEvaluator> predicate, @NonNull String[] ifTargets, @NonNull String[] elseTargets) {
        return () -> predicate.test(eval) ? ifTargets : elseTargets;
    }

    @NonNull
    static Predicate<PropertyEvaluator> createJarEnabledPredicate() {
        return evaluator -> !"false".equalsIgnoreCase(evaluator.getProperty("do.jar"));
    }

    @NonNull
    static Map<String, String[]> loadTargetsFromConfig(@NonNull Project project, @NonNull PropertyEvaluator evaluator) {
        HashMap<String, String[]> targets = new HashMap<String, String[]>(6);
        String config = evaluator.getProperty("config");
        FileObject propFO = project.getProjectDirectory().getFileObject("nbproject/configs/" + config + ".properties");
        if (propFO == null) {
            return targets;
        }
        Properties props = new Properties();
        try (InputStream is = propFO.getInputStream();){
            props.load(is);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return targets;
        }
        for (Map.Entry<Object, Object> e : props.entrySet()) {
            String tNameVal;
            String propName = (String)e.getKey();
            if (!propName.startsWith("$target.") || (tNameVal = (String)e.getValue()) == null || tNameVal.isEmpty()) continue;
            String cmdNameKey = propName.substring("$target.".length());
            StringTokenizer stok = new StringTokenizer(tNameVal.trim(), " ");
            ArrayList<String> targetNames = new ArrayList<String>(3);
            while (stok.hasMoreTokens()) {
                targetNames.add(stok.nextToken());
            }
            targets.put(cmdNameKey, targetNames.toArray(new String[0]));
        }
        return targets;
    }

    @CheckForNull
    static JavaMainAction getJavaMainAction(@NonNull PropertyEvaluator evaluator) {
        return JavaMainAction.forName(evaluator.getProperty(PROP_JAVA_MAIN_ACTION));
    }

    @CheckForNull
    static String getProjectMainClass(@NonNull Project project, @NonNull PropertyEvaluator evaluator, @NonNull SourceRoots projectSourceRoots, @NonNull Function<String, ClassPath> classpaths, boolean verify) {
        String mainClass = evaluator.getProperty("main.class");
        if (MainClassChooser.unitTestingSupport_hasMainMethodResult != null) {
            return MainClassChooser.unitTestingSupport_hasMainMethodResult != false ? mainClass : null;
        }
        if (mainClass == null || mainClass.length() == 0) {
            LOG.fine("Main class is not set");
            return null;
        }
        if (!verify) {
            return mainClass;
        }
        FileObject[] sourcesRoots = projectSourceRoots.getRoots();
        if (sourcesRoots.length > 0) {
            LOG.log(Level.FINE, "Searching main class {0} for root: {1}", new Object[]{mainClass, FileUtil.getFileDisplayName((FileObject)sourcesRoots[0])});
            ClassPath bootPath = null;
            ClassPath compilePath = null;
            try {
                bootPath = ClassPath.getClassPath((FileObject)sourcesRoots[0], (String)"classpath/boot");
                assert (bootPath != null) : ActionProviderSupport.assertPath(sourcesRoots[0], sourcesRoots, project, projectSourceRoots, "classpath/boot");
            }
            catch (AssertionError e) {
                Exceptions.printStackTrace((Throwable)((Object)e));
            }
            try {
                compilePath = ClassPath.getClassPath((FileObject)sourcesRoots[0], (String)"classpath/execute");
                assert (compilePath != null) : ActionProviderSupport.assertPath(sourcesRoots[0], sourcesRoots, project, projectSourceRoots, "classpath/execute");
            }
            catch (AssertionError e) {
                Exceptions.printStackTrace((Throwable)((Object)e));
            }
            if (bootPath == null) {
                LOG.fine("Source root has no boot classpath, using project boot classpath.");
                bootPath = classpaths.apply("classpath/boot");
            }
            if (compilePath == null) {
                LOG.fine("Source root has no execute classpath, using project execute classpath.");
                compilePath = classpaths.apply("classpath/execute");
            }
            ClassPath sourcePath = ClassPath.getClassPath((FileObject)sourcesRoots[0], (String)"classpath/source");
            LOG.log(Level.FINE, "Classpaths used to resolve main boot: {0}, exec: {1}, src: {2}", new Object[]{bootPath, compilePath, sourcePath});
            if (CommonProjectUtils.isMainClass(mainClass, bootPath, compilePath, sourcePath)) {
                return mainClass;
            }
        } else {
            LOG.log(Level.FINE, "Searching main class {0} without source root", mainClass);
            ClassPath bootPath = classpaths.apply("classpath/boot");
            ClassPath compilePath = classpaths.apply("classpath/execute");
            ClassPath sourcePath = classpaths.apply("classpath/source");
            LOG.log(Level.FINE, "Classpaths used to resolve main boot: {0}, exec: {1}, src: {2}", new Object[]{bootPath, compilePath, sourcePath});
            if (CommonProjectUtils.isMainClass(mainClass, bootPath, compilePath, sourcePath)) {
                return mainClass;
            }
        }
        LOG.log(Level.FINE, "Main class {0} is invalid.", mainClass);
        return null;
    }

    static boolean showCustomizer(@NonNull Project project, @NonNull UpdateHelper updateHelper, @NonNull PropertyEvaluator evaluator, @NonNull SourceRoots projectSourceRoots, @NonNull Function<String, ClassPath> classpaths) {
        boolean result = false;
        final JButton okButton = new JButton(Bundle.LBL_MainClassWarning_ChooseMainClass_OK());
        okButton.getAccessibleContext().setAccessibleDescription(Bundle.AD_MainClassWarning_ChooseMainClass_OK());
        String mainClass = ActionProviderSupport.getProjectMainClass(project, evaluator, projectSourceRoots, classpaths, false);
        String message = mainClass == null ? Bundle.LBL_MainClassNotFound(ProjectUtils.getInformation((Project)project).getDisplayName()) : Bundle.LBL_MainClassWrong(mainClass, ProjectUtils.getInformation((Project)project).getDisplayName());
        final MainClassWarning panel = new MainClassWarning(message, projectSourceRoots.getRoots());
        Object[] options = new Object[]{okButton, DialogDescriptor.CANCEL_OPTION};
        panel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (e.getSource() instanceof MouseEvent && MouseUtils.isDoubleClick((MouseEvent)((MouseEvent)e.getSource()))) {
                    okButton.doClick();
                } else {
                    okButton.setEnabled(panel.getSelectedMainClass() != null);
                }
            }
        });
        okButton.setEnabled(false);
        DialogDescriptor desc = new DialogDescriptor((Object)panel, Bundle.CTL_MainClassWarning_Title(), true, options, options[0], 0, null, null);
        desc.setMessageType(1);
        Dialog dlg = DialogDisplayer.getDefault().createDialog(desc);
        dlg.setVisible(true);
        if (desc.getValue() == options[0]) {
            mainClass = panel.getSelectedMainClass();
            String config = evaluator.getProperty("config");
            String path = config == null || config.length() == 0 ? "nbproject/project.properties" : "nbproject/configs/" + config + ".properties";
            EditableProperties ep = updateHelper.getProperties(path);
            ep.put("main.class", mainClass == null ? "" : mainClass);
            try {
                if (updateHelper.requestUpdate()) {
                    updateHelper.putProperties(path, ep);
                    ProjectManager.getDefault().saveProject(project);
                    result = true;
                }
            }
            catch (IOException ioe) {
                Exceptions.printStackTrace((Throwable)ioe);
            }
        }
        dlg.dispose();
        return result;
    }

    @NonNull
    static Map<String, Object> createBaseCoSProperties(@NonNull JavaActionProvider.Context ctx) {
        String command = ctx.getCommand();
        Project project = ctx.getProject();
        UpdateHelper updateHelper = ctx.getUpdateHelper();
        PropertyEvaluator evaluator = ctx.getPropertyEvaluator();
        JavaPlatform jp = ctx.getActiveJavaPlatform();
        HashMap<String, Object> execProperties = new HashMap<String, Object>();
        execProperties.put("nb.internal.action.name", command);
        ActionProviderSupport.copyMultiValue(evaluator, execProperties, "run.jvmargs");
        ActionProviderSupport.prepareWorkDir(updateHelper, evaluator, execProperties);
        execProperties.put("platform", jp);
        execProperties.put("project.name", ProjectUtils.getInformation((Project)project).getDisplayName());
        String runtimeEnc = evaluator.getProperty("runtime.encoding");
        if (runtimeEnc != null) {
            try {
                Charset runtimeChs = Charset.forName(runtimeEnc);
                execProperties.put("runtime.encoding", runtimeChs);
            }
            catch (IllegalCharsetNameException ichsn) {
                LOG.log(Level.WARNING, "Illegal charset name: {0}", runtimeEnc);
            }
            catch (UnsupportedCharsetException uchs) {
                LOG.log(Level.WARNING, "Unsupported charset : {0}", runtimeEnc);
            }
        }
        Optional.ofNullable(evaluator.getProperty("java.failonerror")).map(val -> Boolean.valueOf(val)).ifPresent(b -> execProperties.put("java.failonerror", b));
        return execProperties;
    }

    @CheckForNull
    static Set<String> prepareSystemProperties(@NonNull JavaActionProvider.Context context, @NonNull Map<String, Object> properties, boolean test) {
        String prefix = test ? "test-sys-prop." : "run-sys-prop.";
        Map evaluated = context.getPropertyEvaluator().getProperties();
        if (evaluated == null) {
            return null;
        }
        for (Map.Entry e : evaluated.entrySet()) {
            if (!((String)e.getKey()).startsWith(prefix) || e.getValue() == null) continue;
            ActionProviderSupport.putMultiValue(properties, "run.jvmargs", "-D" + ((String)e.getKey()).substring(prefix.length()) + "=" + (String)e.getValue());
        }
        ActionProviderSupport.collectStartupExtenderArgs(context, (k, v) -> {
            properties.put((String)k, v);
            return null;
        });
        return context.copyAdditionalProperties(properties);
    }

    static void bypassAntBuildScript(@NonNull JavaActionProvider.Context ctx, @NonNull Map<String, Object> p, @NonNull FileObject[] sourceRoots, @NonNull FileObject[] testRoots, @NonNull AtomicReference<ExecutorTask> task, @NullAllowed BiFunction<JavaActionProvider.Context, Map<String, Object>, Boolean> cosExecuteInterceptor) throws IllegalArgumentException {
        boolean run;
        Project project = ctx.getProject();
        PropertyEvaluator evaluator = ctx.getPropertyEvaluator();
        String command = ctx.getCommand();
        Lookup context = ctx.getActiveLookup();
        JavaMainAction javaMainAction = ActionProviderSupport.getJavaMainAction(evaluator);
        boolean hasMainMethod = run = javaMainAction != JavaMainAction.TEST;
        if ("run".equals(command) || "debug".equals(command) || "debug.stepinto".equals(command) || "profile".equals(command)) {
            String mainClass = evaluator.getProperty("main.class");
            p.put("classname", mainClass);
            if (ActionProviderSupport.modulesSupported(project)) {
                p.put("execute.classpath", ctx.getProjectClassPath("modules/execute-classpath"));
                p.put("execute.modulepath", ctx.getProjectClassPath("modules/execute"));
            } else {
                p.put("execute.classpath", ctx.getProjectClassPath("classpath/execute"));
            }
            if ("debug.stepinto".equals(command)) {
                p.put("stopclassname", mainClass);
            }
        } else {
            FileObject[] files = ActionProviderSupport.findSources(sourceRoots, context);
            if (files == null || files.length != 1) {
                files = ActionProviderSupport.findTestSources(sourceRoots, testRoots, context, false);
                if (files != null && files.length == 1) {
                    hasMainMethod = CommonProjectUtils.hasMainMethod(files[0]);
                    run = false;
                }
            } else if (!hasMainMethod) {
                hasMainMethod = CommonProjectUtils.hasMainMethod(files[0]);
            }
            if (files == null || files.length != 1) {
                return;
            }
            p.put("execute.file", files[0]);
        }
        boolean debug = "debug".equals(command) || "debug.single".equals(command) || "debug.stepinto".equals(command);
        boolean profile = "profile".equals(command) || "profile.single".equals(command);
        try {
            boolean vote = true;
            if (cosExecuteInterceptor != null) {
                vote = cosExecuteInterceptor.apply(ctx, p);
            }
            if (vote) {
                if (run) {
                    ActionProviderSupport.copyMultiValue(evaluator, p, "application.args");
                    task.set(JavaRunner.execute((String)(debug ? "debug" : (profile ? "profile" : "run")), p));
                } else if (hasMainMethod) {
                    task.set(JavaRunner.execute((String)(debug ? "debug" : (profile ? "profile" : "run")), p));
                } else {
                    task.set(JavaRunner.execute((String)(debug ? "junit-debug" : (profile ? "junit-profile" : "junit")), p));
                }
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    static void showPlatformWarning(@NonNull Project project) {
        JButton closeOption = new JButton(Bundle.CTL_BrokenPlatform_Close());
        closeOption.getAccessibleContext().setAccessibleDescription(Bundle.AD_BrokenPlatform_Close());
        String projectDisplayName = ProjectUtils.getInformation((Project)project).getDisplayName();
        DialogDescriptor dd = new DialogDescriptor((Object)Bundle.TEXT_BrokenPlatform(projectDisplayName), Bundle.MSG_BrokenPlatform_Title(), true, new Object[]{closeOption}, (Object)closeOption, 0, null, null);
        dd.setMessageType(2);
        Dialog dlg = DialogDisplayer.getDefault().createDialog(dd);
        dlg.setVisible(true);
    }

    @CheckForNull
    static FileObject getRoot(@NonNull FileObject[] roots, @NonNull FileObject file) {
        assert (file != null) : "File can't be null";
        FileObject srcDir = null;
        for (int i = 0; i < roots.length; ++i) {
            assert (roots[i] != null) : "Source Path Root can't be null";
            if (!FileUtil.isParentOf((FileObject)roots[i], (FileObject)file) && !roots[i].equals(file)) continue;
            srcDir = roots[i];
            break;
        }
        return srcDir;
    }

    @CheckForNull
    @SuppressWarnings(value={"PZLA_PREFER_ZERO_LENGTH_ARRAYS"})
    static FileObject[] findSourcesAndPackages(Lookup context, FileObject[] srcRoots) {
        for (int i = 0; i < srcRoots.length; ++i) {
            FileObject[] result = ActionProviderSupport.findSourcesAndPackages(context, srcRoots[i]);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @CheckForNull
    @SuppressWarnings(value={"PZLA_PREFER_ZERO_LENGTH_ARRAYS"})
    static FileObject[] findSources(@NonNull FileObject[] sourceRoots, @NonNull Lookup context) {
        return ActionProviderSupport.findSources(sourceRoots, context, true, false);
    }

    @CheckForNull
    @SuppressWarnings(value={"PZLA_PREFER_ZERO_LENGTH_ARRAYS"})
    static FileObject[] findTestSources(@NonNull FileObject[] sourceRoots, @NonNull FileObject[] testRoots, @NonNull Lookup context, boolean checkInSrcDir) {
        return ActionProviderSupport.findTestSources(sourceRoots, testRoots, context, checkInSrcDir, true, false);
    }

    @SuppressWarnings(value={"PZLA_PREFER_ZERO_LENGTH_ARRAYS"})
    @CheckForNull
    static FileObject[] findTestSourcesForFiles(@NonNull FileObject[] sourceRoots, @NonNull FileObject[] testRoots, @NonNull Lookup context) {
        FileObject[] sourcesFOs = ActionProviderSupport.findSources(sourceRoots, context, false, true);
        FileObject[] testSourcesFOs = ActionProviderSupport.findTestSources(sourceRoots, testRoots, context, false, false, true);
        HashSet<FileObject> testFiles = new HashSet<FileObject>();
        if (testSourcesFOs == null) {
            return ActionProviderSupport.findTestSources(sourceRoots, testRoots, context, true, false, true);
        }
        if (sourcesFOs == null) {
            return testSourcesFOs;
        }
        testFiles.addAll(Arrays.asList(testSourcesFOs));
        FileObject srcRoot = ActionProviderSupport.getRoot(sourceRoots, sourcesFOs[0]);
        for (FileObject testRoot : testRoots) {
            FileObject[] files2NG;
            FileObject[] files2 = ActionUtils.regexpMapFiles((FileObject[])sourcesFOs, (FileObject)srcRoot, (Pattern)SRCDIRJAVA, (FileObject)testRoot, (String)SUBST, (boolean)true);
            if (files2 != null) {
                for (FileObject fo : files2) {
                    if (testFiles.contains(fo)) continue;
                    testFiles.add(fo);
                }
            }
            if ((files2NG = ActionUtils.regexpMapFiles((FileObject[])sourcesFOs, (FileObject)srcRoot, (Pattern)SRCDIRJAVA, (FileObject)testRoot, (String)SUBSTNG, (boolean)true)) == null) continue;
            for (FileObject fo : files2NG) {
                if (testFiles.contains(fo)) continue;
                testFiles.add(fo);
            }
        }
        return testFiles.isEmpty() ? null : testFiles.toArray(new FileObject[0]);
    }

    static String[] setupTestSingle(@NonNull JavaActionProvider.Context context, @NonNull FileObject[] files, @NonNull FileObject[] srcPath) {
        FileObject root = ActionProviderSupport.getRoot(srcPath, files[0]);
        String path = FileUtil.getRelativePath((FileObject)root, (FileObject)files[0]);
        context.setProperty("test.class", path.substring(0, path.length() - 5).replace('/', '.'));
        context.setProperty("test.includes", ActionUtils.antIncludesList((FileObject[])files, (FileObject)root));
        context.setProperty("javac.includes", ActionUtils.antIncludesList((FileObject[])files, (FileObject)root));
        switch (context.getCommand()) {
            case "run.single": 
            case "test.single": {
                return new String[]{"test-single"};
            }
            case "debug.single": 
            case "debug.test.single": {
                return new String[]{"debug-test"};
            }
            case "profile.single": 
            case "profile.test.single": {
                return new String[]{"profile-test"};
            }
        }
        throw new IllegalArgumentException(context.getCommand());
    }

    @CheckForNull
    static String[] pathAndFqn(@NonNull FileObject file, @NonNull FileObject[] roots) {
        String path = FileUtil.getRelativePath((FileObject)ActionProviderSupport.getRoot(roots, file), (FileObject)file);
        if (path == null) {
            return null;
        }
        String fqn = path.endsWith(".java") ? path.substring(0, path.length() - 5) : path;
        return new String[]{path, fqn.replace('/', '.')};
    }

    @CheckForNull
    @SuppressWarnings(value={"PZLA_PREFER_ZERO_LENGTH_ARRAYS"})
    private static FileObject[] findSourcesAndPackages(Lookup context, FileObject srcDir) {
        if (srcDir != null) {
            FileObject[] files = ActionUtils.findSelectedFiles((Lookup)context, (FileObject)srcDir, null, (boolean)true);
            if (files != null) {
                for (int i = 0; i < files.length; ++i) {
                    if (files[i].isFolder() || "java".equals(files[i].getExt())) continue;
                    return null;
                }
            }
            return files;
        }
        return null;
    }

    @CheckForNull
    @SuppressWarnings(value={"PZLA_PREFER_ZERO_LENGTH_ARRAYS"})
    private static FileObject[] findTestSources(@NonNull FileObject[] sourceRoots, @NonNull FileObject[] testRoots, @NonNull Lookup context, boolean checkInSrcDir, boolean strict, boolean findInPackages) {
        FileObject[] files;
        for (FileObject testSrcPath : testRoots) {
            FileObject[] files2 = ActionUtils.findSelectedFiles((Lookup)context, (FileObject)testSrcPath, (String)(findInPackages ? null : ".java"), (boolean)strict);
            ArrayList<FileObject> testFOs = new ArrayList<FileObject>();
            if (files2 == null) continue;
            for (FileObject file : files2) {
                if (!file.hasExt("java") && (!findInPackages || !file.isFolder())) continue;
                testFOs.add(file);
            }
            return testFOs.isEmpty() ? null : testFOs.toArray(new FileObject[0]);
        }
        if (checkInSrcDir && testRoots.length > 0 && (files = ActionProviderSupport.findSources(sourceRoots, context, strict, findInPackages)) != null) {
            FileObject srcRoot = ActionProviderSupport.getRoot(sourceRoots, files[0]);
            for (FileObject testSrcPath : testRoots) {
                FileObject[] files2 = ActionUtils.regexpMapFiles((FileObject[])files, (FileObject)srcRoot, (Pattern)SRCDIRJAVA, (FileObject)testSrcPath, (String)SUBST, (boolean)strict);
                if (files2 != null && files2.length != 0) {
                    return files2;
                }
                FileObject[] files2NG = ActionUtils.regexpMapFiles((FileObject[])files, (FileObject)srcRoot, (Pattern)SRCDIRJAVA, (FileObject)testSrcPath, (String)SUBSTNG, (boolean)strict);
                if (files2NG == null || files2NG.length == 0) continue;
                return files2NG;
            }
            files = ActionUtils.findSelectedFiles((Lookup)context, (FileObject)srcRoot, (String)(findInPackages ? null : ".java"), (boolean)strict);
            ArrayList<FileObject> testFOs = new ArrayList<FileObject>();
            if (files != null) {
                for (FileObject file : files) {
                    String relativePath;
                    if (!findInPackages || !file.isFolder() || (relativePath = FileUtil.getRelativePath((FileObject)srcRoot, (FileObject)file)) == null) continue;
                    for (FileObject testSrcPath : testRoots) {
                        FileObject testFO = FileUtil.toFileObject((File)new File(FileUtil.toFile((FileObject)testSrcPath).getPath().concat(File.separator).concat(relativePath)));
                        if (testFO == null) continue;
                        testFOs.add(testFO);
                    }
                }
                return testFOs.isEmpty() ? null : testFOs.toArray(new FileObject[0]);
            }
        }
        return null;
    }

    @CheckForNull
    @SuppressWarnings(value={"PZLA_PREFER_ZERO_LENGTH_ARRAYS"})
    private static FileObject[] findSources(@NonNull FileObject[] sourceRoots, @NonNull Lookup context, boolean strict, boolean findInPackages) {
        for (int i = 0; i < sourceRoots.length; ++i) {
            FileObject[] files = ActionUtils.findSelectedFiles((Lookup)context, (FileObject)sourceRoots[i], (String)(findInPackages ? null : ".java"), (boolean)strict);
            if (files == null) continue;
            return files;
        }
        return null;
    }

    @CheckForNull
    private static FileObject getBuildScript(@NonNull JavaActionProvider.Context context) {
        String path = CommonProjectUtils.getBuildXmlName(context.getPropertyEvaluator(), null);
        return context.getProject().getProjectDirectory().getFileObject(path);
    }

    private static void copyMultiValue(@NonNull PropertyEvaluator evaluator, @NonNull Map<String, Object> properties, @NonNull String propertyName) {
        String val = evaluator.getProperty(propertyName);
        if (val != null) {
            ActionProviderSupport.putMultiValue(properties, propertyName, val);
        }
    }

    private static boolean modulesSupported(@NonNull Project project) {
        return Optional.ofNullable(SourceLevelQuery.getSourceLevel2((FileObject)project.getProjectDirectory()).getSourceLevel()).map(s -> new SpecificationVersion(s)).map(sv -> CommonModuleUtils.JDK9.compareTo(sv) <= 0).orElse(Boolean.FALSE);
    }

    private static void putMultiValue(@NonNull Map<String, Object> properties, @NonNull String propertyName, @NonNull String val) {
        LinkedList<String> it = (LinkedList<String>)properties.get(propertyName);
        if (it == null) {
            it = new LinkedList<String>();
            properties.put(propertyName, it);
        }
        it.add(val);
    }

    private static void invokeByJavaSource(@NonNull Runnable runnable) throws IOException {
        Parameters.notNull((CharSequence)"runnable", (Object)runnable);
        ClasspathInfo info = ClasspathInfo.create((ClassPath)JavaPlatform.getDefault().getBootstrapLibraries(), (ClassPath)ClassPathSupport.createClassPath((URL[])new URL[0]), (ClassPath)ClassPathSupport.createClassPath((URL[])new URL[0]));
        JavaSource js = JavaSource.create((ClasspathInfo)info, (FileObject[])new FileObject[0]);
        if (js != null) {
            js.runWhenScanFinished(controller -> runnable.run(), true);
        }
    }

    @CheckForNull
    private static String verifyUserPropertiesFile(@NonNull JavaActionProvider.Context ctx) {
        String currentPath = ctx.getPropertyEvaluator().getProperty("user.properties.file");
        File current = currentPath == null ? null : FileUtil.normalizeFile((File)ctx.getUpdateHelper().getAntProjectHelper().resolveFile(currentPath));
        File expected = FileUtil.normalizeFile((File)new File(System.getProperty("netbeans.user"), "build.properties"));
        if (!expected.equals(current)) {
            if (ctx.getUserPropertiesPolicy() == null) {
                Object option = DialogDisplayer.getDefault().notify(new NotifyDescriptor((Object)NbBundle.getMessage(ActionProviderSupport.class, (String)"MSG_InvalidBuildPropertiesPath", (Object)ProjectUtils.getInformation((Project)ctx.getProject()).getDisplayName()), NbBundle.getMessage(ActionProviderSupport.class, (String)"TITLE_InvalidBuildPropertiesPath"), 0, 3, (Object[])UserPropertiesPolicy.values(), (Object)UserPropertiesPolicy.RUN_ANYWAY));
                ctx.setUserPropertiesPolicy(option instanceof UserPropertiesPolicy ? (UserPropertiesPolicy)((Object)option) : null);
            }
            if (null != ctx.getUserPropertiesPolicy()) {
                switch (ctx.getUserPropertiesPolicy().ordinal()) {
                    case 0: {
                        return null;
                    }
                    case 1: {
                        return expected.getAbsolutePath();
                    }
                    case 2: {
                        ProjectManager.mutex().writeAccess(() -> {
                            EditableProperties ep = ctx.getUpdateHelper().getProperties("nbproject/private/private.properties");
                            ep.setProperty("user.properties.file", expected.getAbsolutePath());
                            ctx.getUpdateHelper().putProperties("nbproject/private/private.properties", ep);
                            try {
                                ProjectManager.getDefault().saveProject(ctx.getProject());
                            }
                            catch (IOException ioe) {
                                Exceptions.printStackTrace((Throwable)ioe);
                            }
                        });
                        return null;
                    }
                }
            }
        }
        return null;
    }

    private static void collectStartupExtenderArgs(@NonNull JavaActionProvider.Context ctx, @NonNull BiFunction<String, String, Void> consummer) {
        StringBuilder b = new StringBuilder();
        for (String arg : ActionProviderSupport.runJvmargsIde(ctx)) {
            b.append(' ').append(arg);
        }
        if (b.length() > 0) {
            consummer.apply("run.jvmargs.ide", b.toString());
        }
    }

    private static List<String> runJvmargsIde(@NonNull JavaActionProvider.Context ctx) {
        StartupExtender.StartMode mode;
        switch (ctx.getCommand()) {
            case "run": 
            case "run.single": {
                mode = StartupExtender.StartMode.NORMAL;
                break;
            }
            case "debug": 
            case "debug.single": 
            case "debug.stepinto": {
                mode = StartupExtender.StartMode.DEBUG;
                break;
            }
            case "profile": 
            case "profile.single": {
                mode = StartupExtender.StartMode.PROFILE;
                break;
            }
            case "test": 
            case "test.single": {
                mode = StartupExtender.StartMode.TEST_NORMAL;
                break;
            }
            case "debug.test.single": {
                mode = StartupExtender.StartMode.TEST_DEBUG;
                break;
            }
            case "profile.test.single": {
                mode = StartupExtender.StartMode.TEST_PROFILE;
                break;
            }
            default: {
                return Collections.emptyList();
            }
        }
        ArrayList<String> args = new ArrayList<String>();
        JavaPlatform p = ctx.getActiveJavaPlatform();
        for (StartupExtender group : StartupExtender.getExtenders((Lookup)Lookups.fixed((Object[])new Object[]{ctx.getProject(), p != null ? p : JavaPlatformManager.getDefault().getDefaultPlatform()}), (StartupExtender.StartMode)mode)) {
            args.addAll(group.getArguments());
        }
        return args;
    }

    private static String assertPath(FileObject fileObject, FileObject[] expectedRoots, Project project, SourceRoots roots, String pathType) {
        SourceGroup[] sgs;
        StringBuilder sb = new StringBuilder();
        sb.append("File: ").append(fileObject);
        sb.append("\nPath Type: ").append(pathType);
        Project owner = FileOwnerQuery.getOwner((FileObject)fileObject);
        sb.append("\nOwner: ").append(owner == null ? "" : ProjectUtils.getInformation((Project)owner).getDisplayName());
        sb.append("\nClassPathProviders: ");
        for (ClassPathProvider impl : Lookup.getDefault().lookupResult(ClassPathProvider.class).allInstances()) {
            sb.append("\n  ").append(impl);
        }
        sb.append("\nProject SourceGroups:");
        for (SourceGroup sourceGroup : sgs = ProjectUtils.getSources((Project)project).getSourceGroups("java")) {
            sb.append("\n  ").append(FileUtil.getFileDisplayName((FileObject)sourceGroup.getRootFolder()));
        }
        sb.append("\nProject Source Roots(");
        sb.append(System.identityHashCode(roots));
        sb.append("):");
        for (SourceGroup sourceGroup : expectedRoots) {
            sb.append("\n  ").append(FileUtil.getFileDisplayName((FileObject)sourceGroup));
        }
        return sb.toString();
    }

    private static void prepareWorkDir(@NonNull UpdateHelper updateHelper, @NonNull PropertyEvaluator evaluator, @NonNull Map<String, Object> properties) {
        String val = evaluator.getProperty("work.dir");
        if (val == null) {
            val = ".";
        }
        File file = updateHelper.getAntProjectHelper().resolveFile(val);
        properties.put("work.dir", file);
    }

    private static final class JavaModelWork
    implements Runnable {
        private final JavaActionProvider.ScriptAction scriptAction;
        private final JavaActionProvider.Context context;
        private final String userPropertiesFile;
        private final AtomicReference<Thread> caller;
        private final AtomicBoolean called;
        private final ActionProgress listener;
        boolean needsJavaModel = true;
        boolean doJavaChecks = true;

        JavaModelWork(@NonNull JavaActionProvider.ScriptAction scriptAction, @NonNull JavaActionProvider.Context context, @NullAllowed String userPropertiesFile) {
            Parameters.notNull((CharSequence)"scriptAction", (Object)scriptAction);
            this.scriptAction = scriptAction;
            this.context = context;
            this.userPropertiesFile = userPropertiesFile;
            this.caller = new AtomicReference<Thread>(Thread.currentThread());
            this.called = new AtomicBoolean(false);
            this.listener = ActionProgress.start((Lookup)this.context.getActiveLookup());
        }

        boolean isCalled() {
            return this.called.get();
        }

        @Override
        public void run() {
            if (!this.needsJavaModel && this.caller.get() != Thread.currentThread()) {
                return;
            }
            this.called.set(true);
            ExecutorTask task = null;
            try {
                task = this.execute();
            }
            finally {
                if (task != null) {
                    task.addTaskListener(t -> this.listener.finished(((ExecutorTask)t).result() == 0));
                } else {
                    this.listener.finished(false);
                }
            }
        }

        private ExecutorTask execute() {
            block13: {
                this.context.setProperty("nb.internal.action.name", this.context.getCommand());
                if (this.userPropertiesFile != null) {
                    this.context.setProperty("user.properties.file", this.userPropertiesFile);
                }
                this.context.setJavaChecks(this.doJavaChecks);
                String[] targetNames = this.scriptAction.getTargetNames(this.context);
                if (targetNames == null) {
                    return null;
                }
                if (this.context.getCompileOnSaveOperations().contains((Object)JavaActionProvider.CompileOnSaveOperation.EXECUTE)) {
                    JavaActionProvider.ScriptAction.Result r = this.scriptAction.performCompileOnSave(this.context, targetNames);
                    if (r == JavaActionProvider.ScriptAction.Result.abort()) {
                        return null;
                    }
                    if (r != JavaActionProvider.ScriptAction.Result.follow()) {
                        ExecutorTask t2 = r.getTask();
                        assert (t2 != null);
                        return t2;
                    }
                }
                ActionProviderSupport.collectStartupExtenderArgs(this.context, (k, v) -> {
                    this.context.setProperty((String)k, (String)v);
                    return null;
                });
                if (targetNames.length == 0) {
                    targetNames = null;
                }
                if (this.context.getCompileOnSaveOperations().contains((Object)JavaActionProvider.CompileOnSaveOperation.UPDATE) && !NO_SYNC_COMMANDS.contains(this.context.getCommand())) {
                    this.context.setProperty("nb.wait.for.caches", "true");
                }
                try {
                    FileObject buildFo = ActionProviderSupport.getBuildScript(this.context);
                    if (buildFo == null || !buildFo.isValid()) {
                        NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)Bundle.LBL_No_Build_XML_Found(), 2);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                        break block13;
                    }
                    this.context.fireAntTargetInvocationListener(0, 0);
                    try {
                        Properties props = this.context.getProperties();
                        LOG.log(Level.FINE, "runTargets: {0} with pros: {1}", new Object[]{targetNames, props});
                        ExecutorTask task = ActionUtils.runTarget((FileObject)buildFo, (String[])targetNames, (Properties)props, this.context.getConcealedProperties());
                        task.addTaskListener(t -> this.context.fireAntTargetInvocationListener(1, task.result()));
                        return task;
                    }
                    catch (IOException | RuntimeException ex) {
                        this.context.fireAntTargetInvocationListener(2, 0);
                        throw ex;
                    }
                }
                catch (IOException e) {
                    Exceptions.printStackTrace((Throwable)e);
                }
            }
            return null;
        }
    }

    static enum ActionFlag {
        PLATFORM_SENSITIVE,
        JAVA_MODEL_SENSITIVE,
        SCAN_SENSITIVE,
        COS_ENABLED;

    }

    static final class JavaMainAction
    extends Enum<JavaMainAction> {
        public static final /* enum */ JavaMainAction RUN = new JavaMainAction("run");
        public static final /* enum */ JavaMainAction TEST = new JavaMainAction("test");
        private final String name;
        private static final /* synthetic */ JavaMainAction[] $VALUES;

        public static JavaMainAction[] values() {
            return (JavaMainAction[])$VALUES.clone();
        }

        public static JavaMainAction valueOf(String name) {
            return Enum.valueOf(JavaMainAction.class, name);
        }

        private JavaMainAction(String name) {
            assert (name != null);
            this.name = name;
        }

        @CheckForNull
        static JavaMainAction forName(@NullAllowed String name) {
            if (JavaMainAction.RUN.name.equals(name)) {
                return RUN;
            }
            if (JavaMainAction.TEST.name.equals(name)) {
                return TEST;
            }
            return null;
        }

        private static /* synthetic */ JavaMainAction[] $values() {
            return new JavaMainAction[]{RUN, TEST};
        }

        static {
            $VALUES = JavaMainAction.$values();
        }
    }

    static enum UserPropertiesPolicy {
        RUN_ANYWAY(NbBundle.getMessage(ActionProviderSupport.class, (String)"OPTION_Run_Anyway")),
        RUN_WITH(NbBundle.getMessage(ActionProviderSupport.class, (String)"OPTION_Run_With")),
        RUN_UPDATE(NbBundle.getMessage(ActionProviderSupport.class, (String)"OPTION_Run_Update"));

        private final String displayName;

        private UserPropertiesPolicy(String displayName) {
            this.displayName = displayName;
        }

        @NonNull
        public String getDisplayName() {
            return this.displayName;
        }

        public String toString() {
            return this.getDisplayName();
        }
    }

    static final class ModifiedFilesSupport {
        private final Project project;
        private final UpdateHelper updateHelper;
        private final PropertyEvaluator evaluator;
        private final FileChangeListener modificationListener;
        private final PropertyChangeListener propListner;
        private volatile Boolean allowsFileTracking;
        private Set<String> dirty;
        private Sources src;
        private List<FileObject> roots;

        private ModifiedFilesSupport(@NonNull Project project, @NonNull UpdateHelper updateHelper, @NonNull PropertyEvaluator evaluator) {
            this.project = project;
            this.updateHelper = updateHelper;
            this.evaluator = evaluator;
            this.modificationListener = new FileChangeAdapter(){

                public void fileChanged(FileEvent fe) {
                    this.modification(fe.getFile());
                }

                public void fileDataCreated(FileEvent fe) {
                    this.modification(fe.getFile());
                }
            };
            this.propListner = e -> {
                String propName = e.getPropertyName();
                if (propName == null || "track.file.changes".equals(propName)) {
                    ModifiedFilesSupport modifiedFilesSupport = this;
                    synchronized (modifiedFilesSupport) {
                        this.allowsFileTracking = null;
                        this.dirty = null;
                    }
                }
            };
            this.evaluator.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.propListner, (Object)this.evaluator));
        }

        void start() {
            try {
                FileSystem fs = this.project.getProjectDirectory().getFileSystem();
                fs.addFileChangeListener(FileUtil.weakFileChangeListener((FileChangeListener)this.modificationListener, (Object)fs));
            }
            catch (FileStateInvalidException x) {
                Exceptions.printStackTrace((Throwable)x);
            }
        }

        synchronized void resetDirtyList() {
            this.dirty = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CheckForNull
        String prepareDirtyList(boolean isExplicitBuildTarget) {
            String doDepend = this.evaluator.getProperty("do.depend");
            String buildClassesDirValue = this.evaluator.getProperty("build.classes.dir");
            if (buildClassesDirValue == null) {
                StringBuilder logRecord = new StringBuilder();
                logRecord.append("EVALUATOR: ").append(this.evaluator.getProperties()).append(";");
                logRecord.append("PROJECT_PROPS: ").append(this.updateHelper.getProperties("nbproject/project.properties").entrySet()).append(";");
                logRecord.append("PRIVATE_PROPS: ").append(this.updateHelper.getProperties("nbproject/private/private.properties").entrySet()).append(";");
                LOG.log(Level.WARNING, "No build.classes.dir property: {0}", logRecord.toString());
                return null;
            }
            File buildClassesDir = this.updateHelper.getAntProjectHelper().resolveFile(buildClassesDirValue);
            ModifiedFilesSupport modifiedFilesSupport = this;
            synchronized (modifiedFilesSupport) {
                if (this.dirty == null) {
                    if (this.allowsFileChangesTracking()) {
                        this.dirty = new TreeSet<String>();
                    }
                    return null;
                }
                for (DataObject d : DataObject.getRegistry().getModified()) {
                    this.modification(d.getPrimaryFile());
                }
                String res = null;
                boolean wasBuiltAutomatically = new File(buildClassesDir, ".netbeans_automatic_build").canRead();
                if (!("true".equalsIgnoreCase(doDepend) || isExplicitBuildTarget && this.dirty.isEmpty() || wasBuiltAutomatically)) {
                    if (this.dirty.isEmpty()) {
                        this.dirty.add("nothing whatsoever");
                    }
                    StringBuilder dirtyList = new StringBuilder();
                    for (String f : this.dirty) {
                        if (dirtyList.length() > 0) {
                            dirtyList.append(',');
                        }
                        dirtyList.append(f);
                    }
                    res = dirtyList.toString();
                }
                this.dirty.clear();
                return res;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void modification(FileObject f) {
            if (!this.allowsFileChangesTracking()) {
                return;
            }
            Iterable<? extends FileObject> _roots = this.getRoots();
            assert (_roots != null);
            for (FileObject fileObject : _roots) {
                String path = FileUtil.getRelativePath((FileObject)fileObject, (FileObject)f);
                if (path == null) continue;
                ModifiedFilesSupport modifiedFilesSupport = this;
                synchronized (modifiedFilesSupport) {
                    if (this.dirty != null) {
                        this.dirty.add(path);
                    }
                    break;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Iterable<? extends FileObject> getRoots() {
            Sources _src;
            ModifiedFilesSupport modifiedFilesSupport = this;
            synchronized (modifiedFilesSupport) {
                if (this.roots != null) {
                    return this.roots;
                }
                if (this.src == null) {
                    this.src = ProjectUtils.getSources((Project)this.project);
                    this.src.addChangeListener(e -> this.resetDirtyList());
                }
                _src = this.src;
            }
            assert (_src != null);
            SourceGroup[] sgs = _src.getSourceGroups("java");
            ArrayList<FileObject> _roots = new ArrayList<FileObject>(sgs.length);
            for (SourceGroup sg : sgs) {
                FileObject root = sg.getRootFolder();
                if (UnitTestForSourceQuery.findSources((FileObject)root).length != 0) continue;
                _roots.add(root);
            }
            ModifiedFilesSupport modifiedFilesSupport2 = this;
            synchronized (modifiedFilesSupport2) {
                if (this.roots == null) {
                    this.roots = _roots;
                }
                return this.roots;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean allowsFileChangesTracking() {
            ModifiedFilesSupport modifiedFilesSupport = this;
            synchronized (modifiedFilesSupport) {
                if (this.allowsFileTracking != null) {
                    return this.allowsFileTracking;
                }
            }
            String val = this.evaluator.getProperty("track.file.changes");
            ModifiedFilesSupport modifiedFilesSupport2 = this;
            synchronized (modifiedFilesSupport2) {
                if (this.allowsFileTracking == null) {
                    this.allowsFileTracking = "true".equals(val) ? Boolean.TRUE : Boolean.FALSE;
                }
                return this.allowsFileTracking;
            }
        }

        @NonNull
        static ModifiedFilesSupport newInstance(@NonNull Project project, @NonNull UpdateHelper helper, @NonNull PropertyEvaluator evaluator) {
            return new ModifiedFilesSupport(project, helper, evaluator);
        }
    }
}

