/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ppoints.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.modules.profiler.ppoints.CodeProfilingPoint;
import org.netbeans.modules.profiler.ppoints.ui.Bundle;
import org.netbeans.modules.profiler.ppoints.ui.LocationCustomizer;
import org.netbeans.modules.profiler.ppoints.ui.ValidityAwarePanel;
import org.netbeans.modules.profiler.ppoints.ui.ValidityListener;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;

public class ResetResultsCustomizer
extends ValidityAwarePanel
implements DocumentListener,
ValidityListener,
HelpCtx.Provider {
    private static final String HELP_CTX_KEY = "ResetResultsCustomizer.HelpCtx";
    private static final HelpCtx HELP_CTX = new HelpCtx("ResetResultsCustomizer.HelpCtx");
    private static int defaultTextComponentHeight = -1;
    private JLabel captionLabel;
    private JLabel locationHeaderLabel;
    private JLabel nameLabel;
    private JPanel captionPanel;
    private JPanel firstLineCaptionSpacer = new JPanel(new FlowLayout(3, 0, 0));
    private JSeparator locationHeaderSeparator;
    private JTextField nameTextField;
    private LocationCustomizer locationCustomizer;

    public ResetResultsCustomizer(String caption, Icon icon) {
        this.initComponents(caption, icon);
        this.normalizeCaptionAreaWidth();
    }

    public HelpCtx getHelpCtx() {
        return HELP_CTX;
    }

    @Override
    public Component getInitialFocusTarget() {
        return this.nameTextField;
    }

    public void setPPLocation(CodeProfilingPoint.Location location) {
        this.locationCustomizer.setPPLocation(location);
    }

    public CodeProfilingPoint.Location getPPLocation() {
        return this.locationCustomizer.getPPLocation();
    }

    public void setPPName(String name) {
        this.nameTextField.setText(name);
    }

    public String getPPName() {
        return this.nameTextField.getText();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.updateValidity();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.updateValidity();
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel("plaf.metal.MetalLookAndFeel");
        }
        catch (Exception exception) {
            // empty catch block
        }
        ResetResultsCustomizer main = new ResetResultsCustomizer("Reset Results", null);
        main.addValidityListener(new ValidityListener(){

            @Override
            public void validityChanged(boolean isValid) {
                System.err.println(">>> CUSTOMIZER Validity changed to " + isValid);
            }
        });
        JFrame frame = new JFrame("Customize Profiling Point");
        frame.getContentPane().add(main);
        frame.setDefaultCloseOperation(3);
        frame.pack();
        frame.setVisible(true);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.updateValidity();
    }

    @Override
    public void validityChanged(boolean isValid) {
        this.updateValidity();
    }

    private boolean isNameEmpty() {
        return this.nameTextField.getText().trim().length() == 0;
    }

    private int getPreferredCaptionAreaWidth() {
        int ownCaptionAreaWidth = this.nameLabel.getPreferredSize().width - 12;
        return Math.max(ownCaptionAreaWidth, this.locationCustomizer.getPreferredCaptionAreaWidth());
    }

    private void initComponents(String caption, Icon icon) {
        this.setLayout(new GridBagLayout());
        this.captionPanel = new JPanel(new BorderLayout(0, 0));
        this.captionPanel.setOpaque(true);
        this.captionPanel.setBackground(UIUtils.getProfilerResultsBackground());
        this.captionLabel = new JLabel(caption, icon, 10);
        this.captionLabel.setFont(this.captionLabel.getFont().deriveFont(1));
        this.captionLabel.setOpaque(false);
        this.captionLabel.setBorder(BorderFactory.createEmptyBorder(6, 8, 6, 6));
        this.captionPanel.add((Component)this.captionLabel, "West");
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 0;
        constraints.anchor = 18;
        constraints.fill = 1;
        constraints.insets = new Insets(0, 0, 16, 0);
        this.add((Component)this.captionPanel, constraints);
        this.nameLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.nameLabel, (String)Bundle.ResetResultsCustomizer_NameLabelText());
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 8, 10, 5);
        this.add((Component)this.nameLabel, constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.firstLineCaptionSpacer, constraints);
        this.nameTextField = new JTextField(""){

            @Override
            public Dimension getPreferredSize() {
                return ResetResultsCustomizer.this.getParent() instanceof JViewport ? this.getMinimumSize() : new Dimension(400, super.getPreferredSize().height);
            }

            @Override
            public Dimension getMinimumSize() {
                return new Dimension(super.getMinimumSize().width, super.getPreferredSize().height);
            }
        };
        this.nameLabel.setLabelFor(this.nameTextField);
        this.nameTextField.getDocument().addDocumentListener(this);
        constraints = new GridBagConstraints();
        constraints.gridx = 2;
        constraints.gridy = 1;
        constraints.gridwidth = 0;
        constraints.weightx = 1.0;
        constraints.anchor = 17;
        constraints.fill = 2;
        constraints.insets = new Insets(0, 0, 10, 13);
        this.add((Component)this.nameTextField, constraints);
        JPanel locationHeaderContainer = new JPanel(new GridBagLayout());
        this.locationHeaderLabel = new JLabel(Bundle.ResetResultsCustomizer_LocationLabelText());
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 0, 0, 5);
        locationHeaderContainer.add((Component)this.locationHeaderLabel, constraints);
        this.locationHeaderSeparator = new JSeparator(){

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.anchor = 17;
        constraints.fill = 2;
        constraints.insets = new Insets(0, 0, 0, 0);
        locationHeaderContainer.add((Component)this.locationHeaderSeparator, constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 0;
        constraints.anchor = 17;
        constraints.fill = 2;
        constraints.insets = new Insets(0, 8, 5, 8);
        this.add((Component)locationHeaderContainer, constraints);
        this.locationCustomizer = new LocationCustomizer();
        this.locationCustomizer.addValidityListener(this);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.gridwidth = 0;
        constraints.anchor = 17;
        constraints.fill = 2;
        constraints.insets = new Insets(0, 20, 0, 13);
        this.add((Component)this.locationCustomizer, constraints);
        JPanel fillerPanel = new JPanel(new FlowLayout(3, 0, 0));
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 4;
        constraints.weighty = 1.0;
        constraints.anchor = 18;
        constraints.fill = 1;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)fillerPanel, constraints);
    }

    private void normalizeCaptionAreaWidth() {
        int requiredCaptionAreaWidth = this.nameLabel.getPreferredSize().width - 12;
        int diffCaptionAreaWidth = this.getPreferredCaptionAreaWidth() - requiredCaptionAreaWidth;
        int normalizedCaptionAreaWidth = diffCaptionAreaWidth > 0 ? diffCaptionAreaWidth : 0;
        this.firstLineCaptionSpacer.setBorder(BorderFactory.createEmptyBorder(0, normalizedCaptionAreaWidth, 0, 0));
        this.locationCustomizer.normalizeCaptionAreaWidth(this.getPreferredCaptionAreaWidth());
    }

    private void updateValidity() {
        boolean isValid;
        boolean bl = isValid = !this.isNameEmpty() && this.locationCustomizer.areSettingsValid();
        if (isValid != this.areSettingsValid()) {
            this.fireValidityChanged(isValid);
        }
    }
}

