/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.visual;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JTree;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.css.lib.api.CssParserResult;
import org.netbeans.modules.css.model.api.Model;
import org.netbeans.modules.css.model.api.Rule;
import org.netbeans.modules.css.model.api.StyleSheet;
import org.netbeans.modules.css.visual.CssStylesListenerSupport;
import org.netbeans.modules.css.visual.CustomToolbar;
import org.netbeans.modules.css.visual.DocumentNode;
import org.netbeans.modules.css.visual.DocumentViewModel;
import org.netbeans.modules.css.visual.FakeRootNode;
import org.netbeans.modules.css.visual.Filter;
import org.netbeans.modules.css.visual.api.CssStylesTC;
import org.netbeans.modules.css.visual.api.EditCSSRulesAction;
import org.netbeans.modules.css.visual.api.RuleEditorController;
import org.netbeans.modules.css.visual.spi.Location;
import org.netbeans.modules.css.visual.spi.RuleHandle;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.web.common.api.WebUtils;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.view.BeanTreeView;
import org.openide.filesystems.FileObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class DocumentViewPanel
extends JPanel
implements ExplorerManager.Provider {
    static RequestProcessor RP = new RequestProcessor();
    private BeanTreeView treeView;
    private ExplorerManager manager = new ExplorerManager();
    private final PanelLookup lookup;
    private final Lookup cssStylesLookup;
    private final Lookup.Result<FileObject> lookupFileObjectResult;
    private Filter filter = new Filter();
    private DocumentViewModel documentModel;
    private DocumentNode documentNode;
    private final EditCSSRulesAction createRuleAction;
    private final PropertyChangeListener RULE_EDITOR_CONTROLLER_LISTENER = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent pce) {
            if (RuleEditorController.PropertyNames.RULE_SET.name().equals(pce.getPropertyName())) {
                final Rule rule = (Rule)pce.getNewValue();
                if (rule == null) {
                    DocumentViewPanel.this.setSelectedStyleSheet();
                    return;
                }
                Model model = rule.getModel();
                model.runReadTask(new Model.ModelTask(){
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run(StyleSheet styleSheet) {
                        this.this$1.DocumentViewPanel.this.setSelectedRule(RuleHandle.createRuleHandle(rule));
                    }
                });
            }
        }
    };
    private final AtomicReference<RuleHandle> ruleHandleToSelect = new AtomicReference();
    private final AtomicBoolean settingRule = new AtomicBoolean();
    private boolean active;
    private JToggleButton createRuleToggleButton;
    private JTextField filterTextField;
    private JToggleButton filterToggleButton;
    private JPanel northPanel;

    public DocumentViewPanel(Lookup cssStylesLookup) {
        this.cssStylesLookup = cssStylesLookup;
        this.createRuleAction = EditCSSRulesAction.getDefault();
        this.lookupFileObjectResult = cssStylesLookup.lookupResult(FileObject.class);
        this.lookupFileObjectResult.addLookupListener(new LookupListener(){

            public void resultChanged(LookupEvent ev) {
                try {
                    DocumentViewPanel.this.contextChanged();
                }
                catch (Throwable t) {
                    Exceptions.printStackTrace((Throwable)t);
                }
            }
        });
        RuleEditorController controller = (RuleEditorController)cssStylesLookup.lookup(RuleEditorController.class);
        controller.addRuleEditorListener(this.RULE_EDITOR_CONTROLLER_LISTENER);
        Lookup explorerLookup = ExplorerUtils.createLookup((ExplorerManager)this.getExplorerManager(), (ActionMap)this.getActionMap());
        this.lookup = new PanelLookup(explorerLookup);
        Lookup.Result lookupResult = explorerLookup.lookupResult(Node.class);
        lookupResult.addLookupListener(new LookupListener(){

            public void resultChanged(LookupEvent ev) {
                Node[] selectedNodes = DocumentViewPanel.this.manager.getSelectedNodes();
                Node selected = selectedNodes.length > 0 ? selectedNodes[0] : null;
                boolean empty = selected == null;
                DocumentViewPanel.this.lookup.emptySelection(empty);
                if (!empty) {
                    Location location;
                    RuleHandle ruleHandle = (RuleHandle)selected.getLookup().lookup(RuleHandle.class);
                    if (ruleHandle != null) {
                        if (!DocumentViewPanel.this.settingRule.get()) {
                            DocumentViewPanel.this.selectRuleInRuleEditor(ruleHandle);
                        }
                        CssStylesListenerSupport.fireRuleSelected(ruleHandle);
                    }
                    if ((location = (Location)selected.getLookup().lookup(Location.class)) != null) {
                        DocumentViewPanel.this.createRuleAction.setContext(location.getFile());
                    }
                }
            }
        });
        this.initComponents();
        this.initTreeView();
        CustomToolbar toolbar = new CustomToolbar();
        toolbar.addButton(this.filterToggleButton);
        toolbar.addLineSeparator();
        toolbar.addButton(this.createRuleToggleButton);
        this.northPanel.add((Component)toolbar, "East");
        this.filterTextField.getDocument().addDocumentListener(new DocumentListener(){

            private void contentChanged() {
                DocumentViewPanel.this.filter.setPattern(DocumentViewPanel.this.filterTextField.getText());
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.contentChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.contentChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        this.setFilterVisible(true, false);
        this.filterToggleButton.setSelected(true);
        this.initializeNodes();
        this.contextChanged();
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    private void setSelectedRule(RuleHandle handle) {
        try {
            Node[] nodeArray;
            Node foundRuleNode = DocumentViewPanel.findLocation(this.manager.getRootContext(), handle);
            if (foundRuleNode != null) {
                Node[] nodeArray2 = new Node[1];
                nodeArray = nodeArray2;
                nodeArray2[0] = foundRuleNode;
            } else {
                nodeArray = new Node[]{};
            }
            Node[] toSelect = nodeArray;
            this.manager.setSelectedNodes(toSelect);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    private void setSelectedStyleSheet() {
        try {
            Node[] nodeArray;
            Node styleSheetNode = DocumentViewPanel.findLocation(this.manager.getRootContext(), new Location(this.getContext()));
            if (styleSheetNode != null) {
                Node[] nodeArray2 = new Node[1];
                nodeArray = nodeArray2;
                nodeArray2[0] = styleSheetNode;
            } else {
                nodeArray = new Node[]{};
            }
            Node[] toSelect = nodeArray;
            this.manager.setSelectedNodes(toSelect);
        }
        catch (PropertyVetoException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void selectRuleInRuleEditor(final RuleHandle handle) {
        this.ruleHandleToSelect.set(handle);
        RP.post(new Runnable(){
            final /* synthetic */ DocumentViewPanel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                final RuleEditorController rec = (RuleEditorController)this.this$0.cssStylesLookup.lookup(RuleEditorController.class);
                final AtomicReference matched_rule_ref = new AtomicReference();
                FileObject file = handle.getFile();
                Source source = Source.create((FileObject)file);
                try {
                    ParserManager.parse(Collections.singleton(source), (UserTask)new UserTask(this){
                        final /* synthetic */ 5 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void run(ResultIterator resultIterator) throws Exception {
                            ResultIterator ri = WebUtils.getResultIterator((ResultIterator)resultIterator, (String)"text/css");
                            if (ri != null) {
                                CssParserResult result = (CssParserResult)ri.getParserResult();
                                Model model = Model.getModel((CssParserResult)result);
                                Rule rule = handle.getRule(model);
                                matched_rule_ref.set(rule);
                            }
                        }
                    });
                }
                catch (ParseException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                final Rule match = (Rule)matched_rule_ref.get();
                if (match != null) {
                    EventQueue.invokeLater(new Runnable(){
                        final /* synthetic */ 5 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        @Override
                        public void run() {
                            if (this.this$1.this$0.ruleHandleToSelect.get() == handle) {
                                this.this$1.this$0.settingRule.set(true);
                                rec.setModel(match.getModel());
                                rec.setRule(match);
                                this.this$1.this$0.settingRule.set(false);
                            }
                        }
                    });
                }
            }
        });
    }

    public final ExplorerManager getExplorerManager() {
        return this.manager;
    }

    private FileObject getContext() {
        return (FileObject)this.cssStylesLookup.lookup(FileObject.class);
    }

    private void contextChanged() {
        FileObject context = this.getContext();
        this.lookup.update(context);
        this.createRuleAction.setContext(context);
        if (this.documentModel != null) {
            this.documentModel.dispose();
        }
        this.documentModel = context == null ? null : new DocumentViewModel(context);
        this.updateTitle();
        RP.post(new Runnable(){

            @Override
            public void run() {
                DocumentViewPanel.this.documentNode.setModel(DocumentViewPanel.this.documentModel);
                DocumentViewPanel.this.setSelectedStyleSheet();
            }
        });
    }

    void activated() {
        this.active = true;
        this.updateTitle();
    }

    void deactivated() {
        this.active = false;
    }

    void updateTitle() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                FileObject fob;
                TopComponent tc;
                if (DocumentViewPanel.this.active && (tc = WindowManager.getDefault().findTopComponent("CssStylesTC")) != null && (fob = DocumentViewPanel.this.getContext()) != null) {
                    ((CssStylesTC)tc).setTitle(fob.getNameExt());
                }
            }
        });
    }

    private void initTreeView() {
        this.treeView = new BeanTreeView(){
            {
                this.tree.setCellRenderer(DocumentViewPanel.this.createTreeCellRenderer(this.tree.getCellRenderer()));
            }

            public void expandAll() {
                Node root = DocumentViewPanel.this.manager.getRootContext();
                this.expandAll(root);
                this.collapseNode(root);
                this.expandNode(root);
            }

            private void expandAll(Node node) {
                DocumentViewPanel.this.treeView.expandNode(node);
                for (Node subNode : node.getChildren().getNodes(true)) {
                    if (subNode.isLeaf()) continue;
                    this.expandAll(subNode);
                }
            }
        };
        this.treeView.setAllowedDragActions(0);
        this.treeView.setAllowedDropActions(0);
        this.treeView.setRootVisible(false);
        this.add((Component)this.treeView, "Center");
    }

    private void initializeNodes() {
        this.documentNode = new DocumentNode(this.documentModel, this.filter);
        FakeRootNode<DocumentNode> root = new FakeRootNode<DocumentNode>(this.documentNode, new Action[0]);
        this.manager.setRootContext(root);
        this.treeView.expandAll();
    }

    public static Node findLocation(Node root, Location location) {
        Location candidate = (Location)root.getLookup().lookup(Location.class);
        if (candidate != null && location.equals(candidate)) {
            return root;
        }
        for (Node node : root.getChildren().getNodes()) {
            Node result = DocumentViewPanel.findLocation(node, location);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private TreeCellRenderer createTreeCellRenderer(final TreeCellRenderer delegate) {
        return new DefaultTreeCellRenderer(this){
            final /* synthetic */ DocumentViewPanel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                return delegate.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            }
        };
    }

    private void setFilterVisible(boolean visible, boolean requestFocus) {
        this.northPanel.remove(this.filterTextField);
        if (visible) {
            this.northPanel.add((Component)this.filterTextField, "Center");
            this.filter.setPattern(this.filterTextField.getText());
            if (requestFocus) {
                this.filterTextField.requestFocus();
            }
        } else {
            this.filter.setPattern(null);
        }
        this.northPanel.revalidate();
        this.northPanel.repaint();
    }

    private void initComponents() {
        this.createRuleToggleButton = new JToggleButton();
        this.filterToggleButton = new JToggleButton();
        this.filterTextField = new JTextField();
        this.northPanel = new JPanel();
        this.createRuleToggleButton.setAction(this.createRuleAction);
        this.createRuleToggleButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/css/visual/resources/newRule.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.createRuleToggleButton, null);
        this.createRuleToggleButton.setToolTipText(NbBundle.getMessage(DocumentViewPanel.class, (String)"CreateRuleDialog.title"));
        this.createRuleToggleButton.setFocusable(false);
        this.createRuleToggleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DocumentViewPanel.this.createRuleToggleButtonActionPerformed(evt);
            }
        });
        this.filterToggleButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/css/visual/resources/find.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.filterToggleButton, null);
        this.filterToggleButton.setToolTipText(NbBundle.getMessage(DocumentViewPanel.class, (String)"DocumentViewPanel.filterToggleButton.toolTipText"));
        this.filterToggleButton.setFocusable(false);
        this.filterToggleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DocumentViewPanel.this.filterToggleButtonActionPerformed(evt);
            }
        });
        this.filterTextField.setText(NbBundle.getMessage(DocumentViewPanel.class, (String)"DocumentViewPanel.filterTextField.text"));
        this.filterTextField.setToolTipText(NbBundle.getMessage(DocumentViewPanel.class, (String)"DocumentViewPanel.filterToggleButton.toolTipText"));
        this.setLayout(new BorderLayout());
        this.northPanel.setLayout(new BorderLayout());
        this.add((Component)this.northPanel, "North");
    }

    private void filterToggleButtonActionPerformed(ActionEvent evt) {
        this.setFilterVisible(this.filterToggleButton.isSelected(), true);
    }

    private void createRuleToggleButtonActionPerformed(ActionEvent evt) {
        this.createRuleToggleButton.setSelected(false);
    }

    static class PanelLookup
    extends ProxyLookup {
        private final Lookup base;
        private Project project;
        private boolean emptySelection = true;

        PanelLookup(Lookup base) {
            this.base = base;
        }

        void update(FileObject file) {
            this.project = file == null ? null : FileOwnerQuery.getOwner((FileObject)file);
            this.update();
        }

        void emptySelection(boolean emptySelection) {
            if (this.emptySelection != emptySelection) {
                this.emptySelection = emptySelection;
                this.update();
            }
        }

        private void update() {
            if (this.emptySelection && this.project != null) {
                this.setLookups(new Lookup[]{Lookups.fixed((Object[])new Object[]{new AbstractNode(Children.LEAF, Lookups.fixed((Object[])new Object[]{this.project}))})});
            } else {
                this.setLookups(new Lookup[]{this.base});
            }
        }
    }
}

