/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.diff;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.diff.Difference;
import org.netbeans.api.diff.StreamSource;
import org.netbeans.modules.git.Git;
import org.netbeans.modules.git.VersionsCache;
import org.netbeans.modules.git.utils.GitUtils;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.MultiDataObject;
import org.openide.nodes.CookieSet;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

public class DiffStreamSource
extends StreamSource {
    private final File baseFile;
    private final String revision;
    private final String title;
    private String mimeType;
    private Boolean start;
    private File remoteFile;
    private Boolean canWriteBaseFile;
    private final File fileInRevision;

    public DiffStreamSource(File fileInRevision, File baseFile, String revision, String title) {
        this.baseFile = baseFile;
        this.fileInRevision = fileInRevision;
        this.revision = revision;
        this.title = title;
        this.start = true;
    }

    public String getName() {
        if (this.fileInRevision != null) {
            File repo = Git.getInstance().getRepositoryRoot(this.fileInRevision);
            if (repo != null) {
                return GitUtils.getRelativePath(repo, this.fileInRevision);
            }
            return this.fileInRevision.getName();
        }
        return NbBundle.getMessage(DiffStreamSource.class, (String)"LBL_Diff_Anonymous");
    }

    public String getTitle() {
        return this.title;
    }

    public synchronized String getMIMEType() {
        try {
            this.init();
        }
        catch (IOException e) {
            return null;
        }
        return this.mimeType;
    }

    public synchronized Reader createReader() throws IOException {
        this.init();
        if (this.revision == null || this.remoteFile == null) {
            return null;
        }
        if (!this.mimeType.startsWith("text/")) {
            return null;
        }
        return Utils.createReader((File)this.remoteFile);
    }

    public Writer createWriter(Difference[] conflicts) throws IOException {
        throw new IOException("Operation not supported");
    }

    public boolean isEditable() {
        return "CURRENT".equals(this.revision) && this.isPrimary() && this.isBaseFileWritable();
    }

    private boolean isBaseFileWritable() {
        if (this.canWriteBaseFile == null) {
            FileObject fo = FileUtil.toFileObject((File)this.baseFile);
            this.canWriteBaseFile = fo != null && fo.canWrite();
        }
        return this.canWriteBaseFile;
    }

    private boolean isPrimary() {
        FileObject fo = FileUtil.toFileObject((File)this.baseFile);
        if (fo != null) {
            try {
                DataObject dao = DataObject.find((FileObject)fo);
                return fo.equals(dao.getPrimaryFile());
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
        }
        return true;
    }

    public synchronized Lookup getLookup() {
        try {
            this.init();
        }
        catch (IOException e) {
            return Lookups.fixed((Object[])new Object[0]);
        }
        if (this.remoteFile == null || !this.isPrimary()) {
            return Lookups.fixed((Object[])new Object[0]);
        }
        FileObject remoteFo = FileUtil.toFileObject((File)this.remoteFile);
        if (remoteFo == null) {
            return Lookups.fixed((Object[])new Object[0]);
        }
        return Lookups.fixed((Object[])new Object[]{remoteFo});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void init() throws IOException {
        if (this.baseFile.isDirectory()) {
            return;
        }
        if (!this.start.booleanValue()) {
            return;
        }
        this.start = false;
        if (this.remoteFile != null || this.revision == null) {
            return;
        }
        this.mimeType = GitUtils.getMimeType(this.baseFile);
        try {
            if (this.isEditable()) {
                this.remoteFile = VersionsCache.getInstance().getFileRevision(this.baseFile, this.revision, GitUtils.NULL_PROGRESS_MONITOR);
            } else {
                File tempFolder = Utils.getTempFolder();
                Set allFiles = Utils.getAllDataObjectFiles((File)this.baseFile);
                HashMap<File, File> allFilePairs = new HashMap<File, File>(allFiles.size());
                boolean renamed = !this.baseFile.equals(this.fileInRevision);
                for (File file : allFiles) {
                    if (renamed) {
                        allFilePairs.put(this.renameFile(file, this.baseFile, this.fileInRevision), file);
                        continue;
                    }
                    allFilePairs.put(file, file);
                }
                for (Map.Entry entry : allFilePairs.entrySet()) {
                    File file = (File)entry.getKey();
                    File currentPair = (File)entry.getValue();
                    boolean isBase = file.equals(this.fileInRevision);
                    try {
                        File rf = VersionsCache.getInstance().getFileRevision(file, this.revision, GitUtils.NULL_PROGRESS_MONITOR);
                        if (rf == null) {
                            this.remoteFile = null;
                            return;
                        }
                        File newRemoteFile = new File(tempFolder, file.getName());
                        Utils.copyStreamsCloseAll((OutputStream)new FileOutputStream(newRemoteFile), (InputStream)new FileInputStream(rf));
                        newRemoteFile.deleteOnExit();
                        if (!isBase) continue;
                        this.remoteFile = newRemoteFile;
                        File encodingHolder = currentPair;
                        if (encodingHolder.exists()) {
                            Utils.associateEncoding((File)encodingHolder, (File)newRemoteFile);
                            continue;
                        }
                        if (this.remoteFile == null) continue;
                        boolean created = false;
                        try {
                            if (!encodingHolder.getParentFile().exists()) continue;
                            created = encodingHolder.createNewFile();
                            Utils.associateEncoding((File)encodingHolder, (File)newRemoteFile);
                        }
                        catch (IOException iOException) {}
                        continue;
                        finally {
                            if (!created) continue;
                            encodingHolder.delete();
                        }
                    }
                    catch (IOException e) {
                        if (!isBase) continue;
                        throw e;
                    }
                }
            }
            if (!this.baseFile.exists() && this.remoteFile != null && this.remoteFile.exists()) {
                this.mimeType = GitUtils.getMimeType(this.remoteFile);
            }
        }
        catch (Exception e) {
            throw new IOException("Can not load remote file for " + String.valueOf(this.baseFile), e);
        }
    }

    public void close() {
        EditorCookie.Observable ec = DiffStreamSource.getEditableCookie(this.remoteFile);
        if (ec != null && ec.getOpenedPanes() == null && !ec.isModified()) {
            ec.close();
        }
        super.close();
    }

    private static EditorCookie.Observable getEditableCookie(File file) {
        EditorCookie.Observable editorCookie = null;
        if (file == null) {
            return null;
        }
        FileObject fileObj = FileUtil.toFileObject((File)file);
        if (fileObj != null) {
            try {
                EditorCookie cookie;
                DataObject dao = DataObject.find((FileObject)fileObj);
                if (dao instanceof MultiDataObject) {
                    MultiDataObject mdao = (MultiDataObject)dao;
                    for (MultiDataObject.Entry entry : mdao.secondaryEntries()) {
                        CookieSet.Factory factory;
                        EditorCookie ec;
                        if (fileObj != entry.getFile() || !(entry instanceof CookieSet.Factory) || !((ec = (EditorCookie)(factory = (CookieSet.Factory)entry).createCookie(EditorCookie.class)) instanceof EditorCookie.Observable)) continue;
                        editorCookie = (EditorCookie.Observable)ec;
                    }
                }
                if (editorCookie == null && (cookie = (EditorCookie)dao.getCookie(EditorCookie.class)) instanceof EditorCookie.Observable) {
                    editorCookie = (EditorCookie.Observable)cookie;
                }
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
        }
        return editorCookie;
    }

    private File renameFile(File toRename, File baseFile, File renamedBaseFile) {
        File parent = renamedBaseFile.getParentFile();
        String baseFileName = baseFile.getName();
        String renamedFileName = renamedBaseFile.getName();
        String toRenameFileName = toRename.getName();
        Object retval = toRenameFileName;
        if (!renamedFileName.equals(baseFileName)) {
            String baseNameNoExt = this.getFileNameNoExt(baseFileName);
            String renamedNameNoExt = this.getFileNameNoExt(renamedFileName);
            if (toRenameFileName.startsWith(baseNameNoExt)) {
                retval = renamedNameNoExt;
                if (toRenameFileName.length() > baseNameNoExt.length()) {
                    retval = (String)retval + toRenameFileName.substring(baseNameNoExt.length());
                }
            }
        }
        return new File(parent, (String)retval);
    }

    private String getFileNameNoExt(String fileName) {
        int pos = fileName.lastIndexOf(46);
        if (pos != -1) {
            return fileName.substring(0, pos);
        }
        return fileName;
    }
}

