/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle.assets.k8s;

import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.WatcherException;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.cloud.oracle.assets.OpenProjectsFinder;
import org.netbeans.modules.cloud.oracle.assets.k8s.ClusterItem;
import org.netbeans.modules.cloud.oracle.assets.k8s.KubernetesUtils;
import org.netbeans.modules.cloud.oracle.assets.k8s.PodItem;
import org.netbeans.modules.cloud.oracle.assets.k8s.PortForwards;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

public class Pods {
    private final RequestProcessor RP = new RequestProcessor(Pods.class);
    private final ClusterItem cluster;
    private Set<String> names = null;
    private final List<PodItem> pods = new ArrayList<PodItem>();
    private transient PropertyChangeSupport changeSupport = null;
    private CountDownLatch latch = null;

    private Pods(ClusterItem cluster) {
        this.cluster = cluster;
    }

    public static Pods from(ClusterItem cluster) {
        Pods instance = new Pods(cluster);
        instance.init();
        return instance;
    }

    public List<PodItem> getItems() {
        return new ArrayList<PodItem>(this.pods);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPod(PodItem pod) {
        Pods pods = this;
        synchronized (pods) {
            this.pods.add(pod);
            this.changeSupport.firePropertyChange("pods", this.pods.size(), this.pods.size() - 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removePod(PodItem pod) {
        Pods pods = this;
        synchronized (pods) {
            this.pods.remove(pod);
            this.changeSupport.firePropertyChange("pods", this.pods.size(), this.pods.size() + 1);
        }
        PortForwards.getDefault().closePortForward(pod);
    }

    private void removeAll() {
        this.pods.clear();
        this.changeSupport.firePropertyChange("pods", this.pods.size(), this.pods.size() + 1);
    }

    private void init() {
        try {
            this.changeSupport = new PropertyChangeSupport(this);
            this.cluster.addChangeListener(evt -> {
                if ("namespace".equals(evt.getPropertyName())) {
                    this.watchNamespace((String)evt.getNewValue());
                }
            });
            CompletableFuture<Project[]> projectsFuture = OpenProjectsFinder.getDefault().findTopLevelProjects();
            ((CompletableFuture)projectsFuture.thenApply(projects -> {
                ArrayList<String> projectNames = new ArrayList<String>();
                for (int i = 0; i < ((Project[])projects).length; ++i) {
                    ProjectInformation pi = ProjectUtils.getInformation((Project)projects[i]);
                    projectNames.add(pi.getDisplayName());
                }
                this.names = new HashSet<String>(projectNames);
                return projectNames;
            })).get();
            this.watchNamespace(this.cluster.getNamespace());
        }
        catch (InterruptedException | ExecutionException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void watchNamespace(String namespace) {
        CountDownLatch l;
        this.removeAll();
        Pods pods = this;
        synchronized (pods) {
            if (this.latch != null) {
                this.latch.countDown();
            }
            l = this.latch = new CountDownLatch(1);
        }
        this.addWatcher(this.cluster, namespace, new Watcher<Pod>(){
            final /* synthetic */ Pods this$0;
            {
                this.this$0 = this$0;
            }

            public void eventReceived(Watcher.Action action, Pod t) {
                String app = (String)t.getMetadata().getLabels().get("app");
                if (!this.this$0.names.contains(app)) {
                    return;
                }
                if (action == Watcher.Action.ADDED) {
                    this.this$0.addPod(new PodItem(this.this$0.cluster, t.getMetadata().getNamespace(), t.getMetadata().getName()));
                } else if (action == Watcher.Action.DELETED) {
                    this.this$0.removePod(new PodItem(this.this$0.cluster, t.getMetadata().getNamespace(), t.getMetadata().getName()));
                }
            }

            public void onClose(WatcherException we) {
                l.countDown();
            }
        });
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }

    public void addWatcher(ClusterItem cluster, String namespace, Watcher<Pod> watcher) {
        this.RP.post(() -> KubernetesUtils.runWithClient(cluster, client -> {
            try {
                Watch watch = ((NonNamespaceOperation)client.pods().inNamespace(namespace)).watch(watcher);
                this.latch.await();
                watch.close();
            }
            catch (InterruptedException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }));
    }
}

