/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle.steps;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.cloud.oracle.assets.AbstractStep;
import org.netbeans.modules.cloud.oracle.assets.OpenProjectsFinder;
import org.netbeans.modules.cloud.oracle.assets.Steps;
import org.netbeans.modules.cloud.oracle.steps.Bundle;
import org.openide.NotifyDescriptor;
import org.openide.util.Exceptions;

public class ProjectStep
extends AbstractStep<Project> {
    private final CompletableFuture<Project[]> projectsFuture = OpenProjectsFinder.getDefault().findTopLevelProjects();
    private final Map<String, Project> projects = new HashMap<String, Project>();
    private Project selectedProject;

    @Override
    public void prepare(ProgressHandle h, Steps.Values values) {
        try {
            Project[] p = this.projectsFuture.get();
            for (int i = 0; i < p.length; ++i) {
                ProjectInformation pi = ProjectUtils.getInformation((Project)p[i]);
                this.projects.put(pi.getDisplayName(), p[i]);
            }
        }
        catch (InterruptedException | ExecutionException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    @Override
    public NotifyDescriptor createInput() {
        ArrayList<NotifyDescriptor.QuickPick.Item> items = new ArrayList<NotifyDescriptor.QuickPick.Item>(this.projects.size());
        for (Map.Entry<String, Project> entry : this.projects.entrySet()) {
            items.add(new NotifyDescriptor.QuickPick.Item(entry.getKey(), entry.getValue().getProjectDirectory().getName()));
        }
        String title = Bundle.SelectProject();
        if (this.projects.isEmpty()) {
            title = Bundle.NoProjects();
        }
        return new NotifyDescriptor.QuickPick(title, title, items, false);
    }

    @Override
    public boolean onlyOneChoice() {
        return this.projects.size() == 1;
    }

    @Override
    public void setValue(String selected) {
        this.selectedProject = this.projects.get(selected);
    }

    @Override
    public Project getValue() {
        if (this.projects.size() == 1) {
            return (Project)this.projects.values().toArray()[0];
        }
        return this.selectedProject;
    }
}

