/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.debugger.jpda;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Objects;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class ExceptionBreakpoint
extends JPDABreakpoint {
    public static final String PROP_EXCEPTION_CLASS_NAME = "exceptionClassName";
    public static final String PROP_CLASS_FILTERS = "classFilters";
    public static final String PROP_CLASS_EXCLUSION_FILTERS = "classExclusionFilters";
    public static final String PROP_CATCH_TYPE = "catchType";
    public static final String PROP_CONDITION = "condition";
    @Deprecated
    public static final int TYPE_EXCEPTION_CATCHED = 1;
    @Deprecated
    public static final int TYPE_EXCEPTION_UNCATCHED = 2;
    @Deprecated
    public static final int TYPE_EXCEPTION_CATCHED_UNCATCHED = 3;
    public static final int TYPE_EXCEPTION_CAUGHT = 1;
    public static final int TYPE_EXCEPTION_UNCAUGHT = 2;
    public static final int TYPE_EXCEPTION_CAUGHT_UNCAUGHT = 3;
    private String exceptionClassName = "";
    private String[] classFilters = new String[0];
    private String[] classExclusionFilters = new String[0];
    private int catchType = 2;
    private String condition = "";

    private ExceptionBreakpoint() {
    }

    public static ExceptionBreakpoint create(String exceptionClassName, int catchType) {
        ExceptionBreakpointImpl b = new ExceptionBreakpointImpl();
        b.setExceptionClassName(exceptionClassName);
        b.setCatchType(catchType);
        return b;
    }

    public String getExceptionClassName() {
        return this.exceptionClassName;
    }

    public void setExceptionClassName(String cn) {
        if (cn != null) {
            cn = cn.trim();
        }
        if (Objects.equals(cn, this.exceptionClassName)) {
            return;
        }
        String old = this.exceptionClassName;
        this.exceptionClassName = cn;
        this.firePropertyChange(PROP_EXCEPTION_CLASS_NAME, old, this.exceptionClassName);
    }

    public String[] getClassFilters() {
        return this.classFilters;
    }

    public void setClassFilters(String[] classFilters) {
        if (classFilters == this.classFilters) {
            return;
        }
        String[] old = this.classFilters;
        this.classFilters = classFilters;
        this.firePropertyChange(PROP_CLASS_FILTERS, old, classFilters);
    }

    public String[] getClassExclusionFilters() {
        return this.classExclusionFilters;
    }

    public void setClassExclusionFilters(String[] classExclusionFilters) {
        if (classExclusionFilters == this.classExclusionFilters) {
            return;
        }
        String[] old = this.classExclusionFilters;
        this.classExclusionFilters = classExclusionFilters;
        this.firePropertyChange(PROP_CLASS_EXCLUSION_FILTERS, old, classExclusionFilters);
    }

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String cond) {
        if (cond != null) {
            cond = cond.trim();
        }
        String old = this.condition;
        this.condition = cond;
        this.firePropertyChange(PROP_CONDITION, old, cond);
    }

    public int getCatchType() {
        return this.catchType;
    }

    public void setCatchType(int catchType) {
        if (catchType == this.catchType) {
            return;
        }
        if ((catchType & 3) == 0) {
            throw new IllegalArgumentException();
        }
        int old = this.catchType;
        this.catchType = catchType;
        this.firePropertyChange(PROP_CATCH_TYPE, old, catchType);
    }

    public String toString() {
        return "ExceptionBreakpoint" + this.exceptionClassName;
    }

    private static final class ExceptionBreakpointImpl
    extends ExceptionBreakpoint
    implements PropertyChangeListener {
        private ExceptionBreakpointImpl() {
        }

        public Breakpoint.GroupProperties getGroupProperties() {
            return new ExceptionGroupProperties();
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.enginePropertyChange(evt);
        }

        private final class ExceptionGroupProperties
        extends Breakpoint.GroupProperties {
            private ExceptionGroupProperties() {
            }

            public String getType() {
                return NbBundle.getMessage(ExceptionBreakpoint.class, (String)"ExceptionBrkp_Type");
            }

            public String getLanguage() {
                return "Java";
            }

            public FileObject[] getFiles() {
                String[] filters = ExceptionBreakpointImpl.this.getClassFilters();
                String[] exfilters = ExceptionBreakpointImpl.this.getClassExclusionFilters();
                ArrayList<FileObject> files = new ArrayList<FileObject>();
                for (int i = 0; i < filters.length; ++i) {
                    if (filters[i].startsWith("*") || filters[i].endsWith("*")) continue;
                    JPDABreakpoint.fillFilesForClass(filters[i], files);
                }
                return files.toArray(new FileObject[0]);
            }

            public Project[] getProjects() {
                FileObject[] files = this.getFiles();
                ArrayList<Project> projects = new ArrayList<Project>();
                for (FileObject f : files) {
                    while (!(f == null || (f = f.getParent()) != null && ProjectManager.getDefault().isProject(f))) {
                    }
                    if (f == null) continue;
                    try {
                        projects.add(ProjectManager.getDefault().findProject(f));
                    }
                    catch (IOException iOException) {
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
                return projects.toArray(new Project[0]);
            }

            public DebuggerEngine[] getEngines() {
                return ExceptionBreakpointImpl.this.getEngines();
            }

            public boolean isHidden() {
                return ExceptionBreakpointImpl.this.isHidden();
            }
        }
    }
}

