/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.antlr;

import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.csl.api.ColoringAttributes;
import org.netbeans.modules.csl.api.OccurrencesFinder;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.languages.antlr.AntlrParserResult;
import org.netbeans.modules.languages.antlr.AntlrTokenId;
import org.netbeans.modules.parsing.spi.Scheduler;
import org.netbeans.modules.parsing.spi.SchedulerEvent;

public class AntlrOccurrencesFinder
extends OccurrencesFinder<AntlrParserResult> {
    private int caretPosition;
    private boolean cancelled;
    private final Map<OffsetRange, ColoringAttributes> occurrences = new HashMap<OffsetRange, ColoringAttributes>();

    public void setCaretPosition(int position) {
        this.caretPosition = position;
    }

    public Map<OffsetRange, ColoringAttributes> getOccurrences() {
        return this.occurrences;
    }

    public void run(AntlrParserResult result, SchedulerEvent event) {
        this.occurrences.clear();
        if (this.checkAndResetCancel()) {
            return;
        }
        this.computeOccurrences(result);
    }

    public int getPriority() {
        return 200;
    }

    public Class<? extends Scheduler> getSchedulerClass() {
        return Scheduler.CURSOR_SENSITIVE_TASK_SCHEDULER;
    }

    public void cancel() {
        this.cancelled = true;
    }

    private boolean checkAndResetCancel() {
        if (this.cancelled) {
            this.cancelled = false;
            return true;
        }
        return false;
    }

    private void computeOccurrences(AntlrParserResult<?> result) {
        TokenHierarchy tokenHierarchy = result.getSnapshot().getTokenHierarchy();
        TokenSequence ts = tokenHierarchy.tokenSequence();
        ts.move(this.caretPosition);
        if (ts.movePrevious()) {
            ts.moveNext();
            Token token = ts.token();
            if (token.id() == AntlrTokenId.RULE || token.id() == AntlrTokenId.TOKEN) {
                String refName = String.valueOf(token.text());
                for (OffsetRange occurance : result.getOccurrences(refName)) {
                    this.occurrences.put(occurance, ColoringAttributes.MARK_OCCURRENCES);
                }
            }
        }
    }
}

