/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeimage.spi.debug.filters;

import java.net.URI;
import java.util.function.Supplier;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.modules.nativeimage.api.debug.NIFrame;

public interface FrameDisplayer {
    public DisplayedFrame displayed(NIFrame var1);

    public static final class DisplayedFrame {
        private final String displayName;
        private final String description;
        private final int line;
        private final Supplier<URI> uriSupplier;

        private DisplayedFrame(String displayName, String description, int line, Supplier<URI> uriSupplier) {
            this.displayName = displayName;
            this.description = description;
            this.line = line;
            this.uriSupplier = uriSupplier;
        }

        public static Builder newBuilder(String displayName) {
            return new Builder(displayName);
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getDescription() {
            return this.description;
        }

        public int getLine() {
            return this.line;
        }

        @CheckForNull
        public URI getSourceURI() {
            if (this.uriSupplier != null) {
                return this.uriSupplier.get();
            }
            return null;
        }

        public static final class Builder {
            private final String displayName;
            private String description;
            private int line;
            private Supplier<URI> uriSupplier;

            Builder(String displayName) {
                this.displayName = displayName;
            }

            public Builder description(String description) {
                this.description = description;
                return this;
            }

            public Builder line(int lineNumber) {
                this.line = lineNumber;
                return this;
            }

            public Builder sourceURISupplier(Supplier<URI> uriSupplier) {
                this.uriSupplier = uriSupplier;
                return this;
            }

            public DisplayedFrame build() {
                return new DisplayedFrame(this.displayName, this.description, this.line, this.uriSupplier);
            }
        }
    }
}

