/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.j2ee;

import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.InstanceRemovedException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.ServerInstance;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.java.hints.spi.AbstractHint;
import org.netbeans.modules.javaee.project.api.JavaEEProjectSettings;
import org.netbeans.modules.maven.api.ModelUtils;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.model.ModelOperation;
import org.netbeans.modules.maven.model.Utilities;
import org.netbeans.modules.maven.model.pom.Dependency;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.model.pom.Properties;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class EmbeddableEJBContainerHint
extends AbstractHint {
    private static final Set<Tree.Kind> TREE_KINDS = EnumSet.of(Tree.Kind.METHOD_INVOCATION);
    private static final String PROP_GF_EMBEDDED_JAR = "glassfish.embedded-static-shell.jar";

    public EmbeddableEJBContainerHint() {
        super(true, true, AbstractHint.HintSeverity.ERROR, new String[0]);
    }

    public String getDescription() {
        return NbBundle.getMessage(EmbeddableEJBContainerHint.class, (String)"EmbeddableEJBContainer_Description");
    }

    public Set<Tree.Kind> getTreeKinds() {
        return TREE_KINDS;
    }

    public List<ErrorDescription> run(CompilationInfo info, TreePath treePath) {
        Tree t = treePath.getLeaf();
        Element el = info.getTrees().getElement(treePath);
        if (el == null || !el.getEnclosingElement().getSimpleName().toString().equals("EJBContainer") || !el.getSimpleName().toString().equals("createEJBContainer")) {
            return null;
        }
        FileObject testFile = info.getFileObject();
        Project prj = FileOwnerQuery.getOwner((FileObject)testFile);
        if (prj == null) {
            return null;
        }
        if (prj.getLookup().lookup(NbMavenProject.class) == null) {
            return null;
        }
        ClassPath cp = ClassPath.getClassPath((FileObject)testFile, (String)"classpath/execute");
        if (cp == null) {
            return null;
        }
        for (FileObject cpRoot : cp.getRoots()) {
            FileObject fo = FileUtil.getArchiveFile((FileObject)cpRoot);
            if (fo == null || !fo.getNameExt().toLowerCase().contains("glassfish-embedded-static-shell")) continue;
            return null;
        }
        try {
            cp.getClassLoader(true).loadClass("javax.ejb.embeddable.EJBContainer");
            return null;
        }
        catch (ClassFormatError classFormatError) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        List<Object> fixes = new ArrayList();
        J2eeModuleProvider provider = (J2eeModuleProvider)prj.getLookup().lookup(J2eeModuleProvider.class);
        if (provider != null) {
            fixes = FixEjbContainerAction.createGF3SystemScope(prj);
        }
        return Collections.singletonList(ErrorDescriptionFactory.createErrorDescription((Severity)this.getSeverity().toEditorSeverity(), (String)this.getDisplayName(), fixes, (FileObject)info.getFileObject(), (int)((int)info.getTrees().getSourcePositions().getStartPosition(info.getCompilationUnit(), t)), (int)((int)info.getTrees().getSourcePositions().getEndPosition(info.getCompilationUnit(), t))));
    }

    public String getId() {
        return "EmbeddableEJBContainer";
    }

    public String getDisplayName() {
        return NbBundle.getMessage(EmbeddableEJBContainerHint.class, (String)"EmbeddableEJBContainer_DisplayName");
    }

    public void cancel() {
    }

    private static final class FixEjbContainerAction
    implements Fix {
        private static final String GF_EMBEDDED_STATIC_SHELL_POM_LATEST = "https://maven.java.net/content/repositories/releases/org/glassfish/main/extras/glassfish-embedded-static-shell/3.1.2.2/glassfish-embedded-static-shell-3.1.2.2.pom";
        private static final String GF_EMBEDDED_STATIC_SHELL_POM_OLD = "http://repo2.maven.org/maven2/org/glassfish/extras/glassfish-embedded-static-shell/3.0.1/glassfish-embedded-static-shell-3.0.1.pom";
        private final String fixDesc;
        private final URL pomUrl;
        private final Project project;
        private final File file;

        private FixEjbContainerAction(String fixDesc, URL pomUrl, File f, Project prj) {
            this.fixDesc = fixDesc;
            this.pomUrl = pomUrl;
            this.project = prj;
            this.file = FileUtil.normalizeFile((File)f);
        }

        public static List<Fix> createGF3SystemScope(Project prj) {
            ArrayList<Fix> fixes = new ArrayList<Fix>();
            String usedServer = JavaEEProjectSettings.getServerInstanceID((Project)prj);
            for (String serId : Deployment.getDefault().getServerInstanceIDs()) {
                ServerInstance server = Deployment.getDefault().getServerInstance(serId);
                try {
                    if (!"gfv3ee6".equals(server.getServerID())) {
                    }
                }
                catch (InstanceRemovedException ex) {}
                continue;
                try {
                    File[] files = server.getJ2eePlatform().getToolClasspathEntries("embeddableejb");
                    assert (files.length == 1) : "expecting one item: " + Arrays.asList(files);
                    try {
                        URL pomUrl = serId.indexOf("gfv3ee6wc") != -1 ? new URL(GF_EMBEDDED_STATIC_SHELL_POM_LATEST) : new URL(GF_EMBEDDED_STATIC_SHELL_POM_OLD);
                        if (serId.equals(usedServer)) {
                            fixes.clear();
                        }
                        fixes.add(new FixEjbContainerAction(NbBundle.getMessage(EmbeddableEJBContainerHint.class, (String)"EmbeddableEJBContainer_FixGFStatic", (Object)server.getDisplayName()), pomUrl, files[0], prj));
                        if (!serId.equals(usedServer)) continue;
                        return fixes;
                    }
                    catch (MalformedURLException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
                catch (InstanceRemovedException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            return fixes;
        }

        public ChangeInfo implement() throws Exception {
            final Boolean[] added = new Boolean[1];
            ModelOperation<POMModel> operation = new ModelOperation<POMModel>(){
                final /* synthetic */ FixEjbContainerAction this$0;
                {
                    this.this$0 = this$0;
                }

                public void performOperation(POMModel model) {
                    added[0] = this.this$0.checkAndAddPom(this.this$0.pomUrl, model, this.this$0.file);
                }
            };
            FileObject pom = this.project.getProjectDirectory().getFileObject("pom.xml");
            Utilities.performPOMModelOperations((FileObject)pom, Collections.singletonList(operation));
            if (added[0].booleanValue()) {
                ((NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class)).triggerDependencyDownload();
            }
            return null;
        }

        private boolean checkAndAddPom(URL pom, POMModel model, File systemDep) {
            ModelUtils.LibraryDescriptor result = ModelUtils.checkLibrary((URL)pom);
            if (result != null) {
                Dependency dep = ModelUtils.checkModelDependency((POMModel)model, (String)result.getGroupId(), (String)result.getArtifactId(), (boolean)true);
                dep.setVersion(result.getVersion());
                dep.setScope("system");
                if (result.getClassifier() != null) {
                    dep.setClassifier(result.getClassifier());
                }
                if (systemDep != null) {
                    Properties props = model.getProject().getProperties();
                    if (props != null && props.getProperty(EmbeddableEJBContainerHint.PROP_GF_EMBEDDED_JAR) == null) {
                        props.setProperty(EmbeddableEJBContainerHint.PROP_GF_EMBEDDED_JAR, systemDep.getAbsolutePath());
                    }
                    dep.setSystemPath("${glassfish.embedded-static-shell.jar}");
                }
                return true;
            }
            return false;
        }

        public String getText() {
            return this.fixDesc;
        }
    }
}

