/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.completion;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.xml.schema.completion.CompletionResultItem;
import org.netbeans.modules.xml.schema.completion.TagLastCharResultItem;
import org.netbeans.modules.xml.schema.completion.util.CompletionContextImpl;
import org.netbeans.modules.xml.schema.completion.util.CompletionUtil;
import org.netbeans.modules.xml.text.api.dom.XMLSyntaxSupport;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionResultSet;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.AsyncCompletionQuery;
import org.netbeans.spi.editor.completion.support.CompletionUtilities;
import org.netbeans.swing.plaf.LFCustoms;
import org.openide.filesystems.FileObject;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class CompletionQuery
extends AsyncCompletionQuery {
    private static final Logger LOG = Logger.getLogger(CompletionQuery.class.getName());
    private static final RequestProcessor RP = new RequestProcessor("Schema completion downloader", 1);
    private static final int MAX_COLLECT_TIME = 5000;
    private static final Map<Document, PreparedResults> preparedCompletions = new WeakHashMap<Document, PreparedResults>();
    private JTextComponent component;
    private FileObject primaryFile;
    private CompletionContextImpl context;
    private static final ImageIcon LOADING_ICON = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/xml/schema/completion/resources/element.png", (boolean)false);

    public CompletionQuery(FileObject primaryFile) {
        this.primaryFile = primaryFile;
    }

    protected void prepareQuery(JTextComponent component) {
        this.component = component;
    }

    protected void query(CompletionResultSet resultSet, Document doc, int caretOffset) {
        XMLSyntaxSupport support = XMLSyntaxSupport.getSyntaxSupport((Document)doc);
        if (support == null) {
            resultSet.finish();
            return;
        }
        CompletionResultItem endTagResultItem = CompletionUtil.getEndTagCompletionItem(this.component, (BaseDocument)doc);
        List completionItems = null;
        if (!CompletionUtil.noCompletion(this.component) && CompletionUtil.canProvideCompletion((BaseDocument)doc)) {
            resultSet.setWaitText(NbBundle.getMessage(CompletionQuery.class, (String)"MSG_PreparingXmlSchemas"));
            PreparedResults res = this.createResultsAndTimedWait(doc, caretOffset);
            if (res.isRunning()) {
                resultSet.addItem((CompletionItem)new FinishDownloadItem());
            } else {
                completionItems = res.items;
            }
        } else {
            CompletionQuery.clearPreparedItems(doc);
        }
        if (this.isTaskCancelled()) {
            resultSet.finish();
            return;
        }
        if (endTagResultItem != null) {
            resultSet.addItem((CompletionItem)endTagResultItem);
        }
        if (completionItems != null && completionItems.size() > 0) {
            resultSet.addAllItems((Collection)completionItems);
        } else if (endTagResultItem != null && !(endTagResultItem instanceof TagLastCharResultItem)) {
            endTagResultItem.setExtraPaintGap(-5);
        }
        resultSet.finish();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PreparedResults createResultsAndTimedWait(Document doc, int caretOffset) {
        PreparedResults res;
        RequestProcessor.Task t = null;
        ModelTask mtask = null;
        Map<Document, PreparedResults> map = preparedCompletions;
        synchronized (map) {
            res = preparedCompletions.get(doc);
            if (res != null && !res.accept(caretOffset)) {
                LOG.log(Level.FINE, "Got task for a different caretOffset; ignoring");
                res = null;
            }
            if (res != null) {
                if (res.runningTask != null) {
                    boolean stillRunning = res.runningTask.get() != null;
                    LOG.log(Level.FINE, "Prepared data for document {0} contain task ref, running: {1}", new Object[]{doc, stillRunning});
                } else {
                    LOG.log(Level.FINE, "Prepared data ready, got {0} items", res.items == null ? -1 : res.items.size());
                    CompletionQuery.clearPreparedItems(doc);
                }
            } else {
                LOG.log(Level.FINE, "Executing task for document {0}", doc);
                mtask = new ModelTask(doc, caretOffset);
                res = new PreparedResults(caretOffset, mtask);
                preparedCompletions.put(doc, res);
                t = RP.post((Runnable)mtask);
            }
        }
        if (t != null) {
            LOG.log(Level.FINE, "Scheduling completion dowloader");
            try {
                t.waitFinished(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!res.fetchCompletionItems()) {
                LOG.log(Level.FINE, "Clearing data cache for {0}", doc);
                CompletionQuery.clearPreparedItems(doc);
            }
            LOG.log(Level.FINE, "Got {0} within timeout", res.items == null ? -1 : res.items.size());
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void postPreparedItems(Document doc, int offset, List<CompletionResultItem> items) {
        PreparedResults res = new PreparedResults(offset, items);
        Map<Document, PreparedResults> map = preparedCompletions;
        synchronized (map) {
            PreparedResults r1 = preparedCompletions.get(doc);
            LOG.log(Level.FINE, "Prepared results: {0}", r1);
            if (r1 == null || !r1.accept(offset)) {
                LOG.log(Level.FINE, "Task has been obsoleted, ignoring");
                return;
            }
            LOG.log(Level.FINE, "Will re-invoke completion for {0} items", items.size());
            preparedCompletions.put(doc, res);
        }
        Completion.get().showCompletion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void clearPreparedItems(Document doc) {
        Map<Document, PreparedResults> map = preparedCompletions;
        synchronized (map) {
            preparedCompletions.remove(doc);
        }
    }

    List<CompletionResultItem> getCompletionItems(Document doc, int caretOffset) {
        List<CompletionResultItem> completionItems = null;
        XMLSyntaxSupport support = XMLSyntaxSupport.getSyntaxSupport((Document)doc);
        if (support == null) {
            return null;
        }
        this.context = new CompletionContextImpl(this.primaryFile, support, caretOffset);
        if (!this.context.initContext() || !this.context.initModels()) {
            return null;
        }
        switch (this.context.getCompletionType()) {
            case COMPLETION_TYPE_ELEMENT_VALUE: {
                completionItems = CompletionUtil.getElementValues(this.context);
                if (completionItems != null && completionItems.size() > 0) break;
            }
            case COMPLETION_TYPE_ELEMENT: {
                completionItems = CompletionUtil.getElements(this.context);
                break;
            }
            case COMPLETION_TYPE_ATTRIBUTE: {
                completionItems = CompletionUtil.getAttributes(this.context);
                break;
            }
            case COMPLETION_TYPE_ATTRIBUTE_VALUE: {
                completionItems = CompletionUtil.getAttributeValues(this.context);
                break;
            }
            case COMPLETION_TYPE_ENTITY: {
                break;
            }
            case COMPLETION_TYPE_NOTATION: {
                break;
            }
        }
        return completionItems;
    }

    private static class PreparedResults {
        private Reference<ModelTask> runningTask;
        private int caretOffset;
        private List<CompletionResultItem> items;

        public PreparedResults(int caretOffset, List<CompletionResultItem> items) {
            this.caretOffset = caretOffset;
            this.items = items;
        }

        public PreparedResults(int caretOffset, ModelTask runningTask) {
            this.caretOffset = caretOffset;
            this.runningTask = new WeakReference<ModelTask>(runningTask);
        }

        public boolean isRunning() {
            return this.runningTask != null;
        }

        public boolean hasItems() {
            return this.items != null && !this.items.isEmpty();
        }

        public boolean accept(int caretOffset) {
            return caretOffset == this.caretOffset;
        }

        public ModelTask getRunningTask() {
            return this.runningTask == null ? null : this.runningTask.get();
        }

        public boolean fetchCompletionItems() {
            ModelTask t = this.getRunningTask();
            if (t != null) {
                this.items = t.fetchCompletionItems();
                if (this.items != null) {
                    this.runningTask = null;
                }
            }
            return this.isRunning();
        }
    }

    private static final class FinishDownloadItem
    implements CompletionItem {
        private FinishDownloadItem() {
        }

        public void defaultAction(JTextComponent component) {
        }

        public void processKeyEvent(KeyEvent evt) {
        }

        public int getPreferredWidth(Graphics g, Font defaultFont) {
            return CompletionUtilities.getPreferredWidth((String)this.getText(), null, (Graphics)g, (Font)defaultFont);
        }

        private String getText() {
            return NbBundle.getMessage(CompletionQuery.class, (String)"COMPL_SchemasLoading");
        }

        public void render(Graphics g, Font defaultFont, Color defaultColor, Color backgroundColor, int width, int height, boolean selected) {
            CompletionUtilities.renderHtml((ImageIcon)LOADING_ICON, (String)this.getText(), null, (Graphics)g, (Font)defaultFont, (Color)LFCustoms.shiftColor((Color)defaultColor), (int)width, (int)height, (boolean)selected);
        }

        public CompletionTask createDocumentationTask() {
            return null;
        }

        public CompletionTask createToolTipTask() {
            return null;
        }

        public boolean instantSubstitution(JTextComponent component) {
            return false;
        }

        public int getSortPriority() {
            return Integer.MAX_VALUE;
        }

        public CharSequence getSortText() {
            return "";
        }

        public CharSequence getInsertPrefix() {
            return "";
        }
    }

    private class ModelTask
    implements Runnable {
        private final int caretOffset;
        private final Document doc;
        private List<CompletionResultItem> items;
        private boolean ccCompleted;

        public ModelTask(Document doc, int caretOffset) {
            this.doc = doc;
            this.caretOffset = caretOffset;
        }

        public synchronized List<CompletionResultItem> fetchCompletionItems() {
            this.ccCompleted = true;
            return this.items;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            List<CompletionResultItem> completionItems = CompletionQuery.this.getCompletionItems(this.doc, this.caretOffset);
            if (completionItems == null) {
                completionItems = Collections.emptyList();
            }
            ModelTask modelTask = this;
            synchronized (modelTask) {
                if (!this.ccCompleted) {
                    LOG.log(Level.FINE, "Completion task finished before timeout");
                    this.items = completionItems;
                    return;
                }
            }
            if (CompletionQuery.this.isTaskCancelled()) {
                CompletionQuery.clearPreparedItems(this.doc);
            } else {
                CompletionQuery.postPreparedItems(this.doc, this.caretOffset, completionItems);
            }
        }
    }
}

