/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.team.commons.treelist;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.netbeans.modules.team.commons.treelist.ListNode;
import org.netbeans.modules.team.commons.treelist.ProgressLabel;
import org.netbeans.modules.team.commons.treelist.RendererPanel;
import org.netbeans.modules.team.commons.treelist.TreeListListener;
import org.openide.util.Cancellable;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;

public abstract class TreeListNode
extends ListNode {
    public static final long TIMEOUT_INTERVAL_MILLIS = NbPreferences.forModule(TreeListNode.class).getInt("node.expand.timeoutmillis", 300000);
    private final boolean expandable;
    private final TreeListNode parent;
    private TreeListListener listener;
    private boolean expanded = false;
    private ArrayList<TreeListNode> children = null;
    private final Object LOCK = new Object();
    private RendererPanel renderer;
    private ChildrenLoader loader;
    private Type type;
    private boolean indentChildren = true;
    private static RequestProcessor rp = new RequestProcessor("Tree List Node - Load Children", 5);
    private int lastRowWidth = -1;
    private final boolean renderGradient;

    protected static void post(Runnable run) {
        rp.post(run);
    }

    public TreeListNode(boolean expandable, TreeListNode parent) {
        this(expandable, true, parent);
    }

    public TreeListNode(boolean expandable, boolean renderGradient, TreeListNode parent) {
        this.expandable = expandable;
        this.renderGradient = renderGradient;
        this.parent = parent;
    }

    public boolean isRenderedWithGradient() {
        return this.renderGradient;
    }

    public final boolean isExpandable() {
        return this.expandable;
    }

    public final TreeListNode getParent() {
        return this.parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<TreeListNode> getChildren() {
        Object object = this.LOCK;
        synchronized (object) {
            if (null == this.children) {
                return Collections.emptyList();
            }
            return new ArrayList<TreeListNode>(this.children);
        }
    }

    protected abstract List<TreeListNode> createChildren();

    protected final void refreshChildren() {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                boolean hasChildren;
                Object object = TreeListNode.this.LOCK;
                synchronized (object) {
                    boolean bl = hasChildren = null != TreeListNode.this.children;
                    if (hasChildren) {
                        for (TreeListNode node : TreeListNode.this.children) {
                            node.dispose();
                        }
                        TreeListNode.this.children = null;
                    }
                    if (TreeListNode.this.expanded) {
                        TreeListNode.this.startLoadingChildren();
                    }
                }
                if (hasChildren && null != TreeListNode.this.listener) {
                    TreeListNode.this.listener.childrenRemoved(TreeListNode.this);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final JComponent getRenderer(Color foreground, Color background, boolean isSelected, boolean hasFocus, int rowHeight, int rowWidth) {
        RendererPanel res = null;
        TreeListNode treeListNode = this;
        synchronized (treeListNode) {
            if (this.lastRowWidth > rowWidth) {
                this.fireContentChanged();
            }
            this.lastRowWidth = rowWidth;
            if (null == this.renderer) {
                this.renderer = new RendererPanel(this);
            }
            res = this.renderer;
        }
        res.configure(foreground, background, isSelected, hasFocus, this.getNestingDepth(), rowHeight, rowWidth);
        return res;
    }

    protected void childrenLoadingStarted() {
    }

    protected void childrenLoadingFinished() {
    }

    protected void childrenLoadingTimedout() {
    }

    public boolean getIndentChildren() {
        return this.indentChildren;
    }

    public void setIndentChildren(boolean indent) {
        this.indentChildren = indent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setListener(TreeListListener listener) {
        Object object = this.LOCK;
        synchronized (object) {
            super.setListener(listener);
            this.listener = listener;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispose() {
        Object object = this.LOCK;
        synchronized (object) {
            this.listener = null;
            if (null != this.children) {
                for (TreeListNode node : this.children) {
                    node.dispose();
                }
            }
        }
    }

    @Override
    protected void attach() {
    }

    protected Type getType() {
        return Type.NORMAL;
    }

    final boolean isDescendantOf(TreeListNode grandParent) {
        if (null == this.parent) {
            return false;
        }
        if (this.parent.equals(grandParent)) {
            return true;
        }
        return this.parent.isDescendantOf(grandParent);
    }

    public final boolean isExpanded() {
        return this.expanded && this.isExpandable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setExpanded(boolean expanded) {
        if (!this.isExpandable()) {
            throw new IllegalStateException();
        }
        this.expanded = expanded;
        if (null != this.listener) {
            if (this.expanded) {
                boolean childrenLoaded = true;
                Object object = this.LOCK;
                synchronized (object) {
                    if (null == this.children) {
                        childrenLoaded = false;
                        this.startLoadingChildren();
                    }
                }
                if (childrenLoaded) {
                    this.listener.childrenAdded(this);
                }
            } else {
                Object object = this.LOCK;
                synchronized (object) {
                    if (null != this.loader) {
                        this.loader.cancel();
                        this.childrenLoadingFinished();
                    }
                }
                this.listener.childrenRemoved(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void fireContentChanged() {
        TreeListNode treeListNode = this;
        synchronized (treeListNode) {
            this.renderer = null;
        }
        super.fireContentChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void fireContentSizeChanged() {
        TreeListNode treeListNode = this;
        synchronized (treeListNode) {
            this.renderer = null;
        }
        super.fireContentSizeChanged();
    }

    protected final ProgressLabel createProgressLabel() {
        return this.createProgressLabel(NbBundle.getMessage(TreeListNode.class, (String)"LBL_LoadingInProgress"));
    }

    protected final ProgressLabel createProgressLabel(String text) {
        return new ProgressLabel(text, this);
    }

    final int getNestingDepth() {
        if (null == this.getParent()) {
            return 0;
        }
        return this.getParent().getNestingDepth() + (this.getParent().getIndentChildren() ? 1 : 0);
    }

    boolean isLoaded() {
        return true;
    }

    private void startLoadingChildren() {
        this.childrenLoadingStarted();
        if (null != this.loader) {
            this.loader.cancel();
        }
        this.loader = new ChildrenLoader();
        TreeListNode.post(this.loader);
    }

    protected static enum Type {
        NORMAL,
        CLOSED,
        TITLE;

    }

    private class ChildrenLoader
    implements Runnable,
    Cancellable {
        private boolean cancelled = false;
        private Thread t = null;

        private ChildrenLoader() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            final List[] res = new List[1];
            Runnable r = new Runnable(){
                final /* synthetic */ ChildrenLoader this$1;
                {
                    this.this$1 = this$1;
                }

                @Override
                public void run() {
                    res[0] = this.this$1.TreeListNode.this.createChildren();
                }
            };
            this.t = new Thread(r);
            this.t.start();
            try {
                this.t.join(TIMEOUT_INTERVAL_MILLIS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.cancelled) {
                return;
            }
            if (null == res[0]) {
                TreeListNode.this.childrenLoadingTimedout();
                return;
            }
            Object object = TreeListNode.this.LOCK;
            synchronized (object) {
                TreeListNode.this.children = new ArrayList(res[0]);
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (null != TreeListNode.this.listener) {
                        TreeListNode.this.listener.childrenAdded(TreeListNode.this);
                    }
                }
            });
            TreeListNode.this.childrenLoadingFinished();
        }

        public boolean cancel() {
            this.cancelled = true;
            if (null != this.t) {
                this.t.interrupt();
            }
            return true;
        }
    }
}

