/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.commit;

import java.io.File;
import java.util.ArrayList;
import java.util.Set;
import org.netbeans.modules.mercurial.HgModuleConfig;
import org.netbeans.modules.mercurial.HgProgressSupport;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.ui.actions.ContextAction;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.openide.nodes.Node;
import org.openide.util.RequestProcessor;

public final class ExcludeFromCommitAction
extends ContextAction {
    public static final int UNDEFINED = -1;
    public static final int EXCLUDING = 1;
    public static final int INCLUDING = 2;

    @Override
    protected boolean enable(Node[] nodes) {
        Set ctxFiles;
        VCSContext context = HgUtils.getCurrentContext(nodes);
        Set set = ctxFiles = context != null ? context.getRootFiles() : null;
        if (!HgUtils.isFromHgRepository(context) || ctxFiles == null || ctxFiles.size() == 0) {
            return false;
        }
        return !HgUtils.onlyProjects(nodes) && !HgUtils.onlyFolders(ctxFiles);
    }

    @Override
    protected String getBaseName(Node[] nodes) {
        VCSContext ctx = HgUtils.getCurrentContext(nodes);
        int actionStatus = this.getActionStatus(ctx);
        switch (actionStatus) {
            case -1: 
            case 1: {
                return "CTL_MenuItem_ExcludeFromCommit";
            }
            case 2: {
                return "CTL_MenuItem_IncludeInCommit";
            }
        }
        throw new RuntimeException("Invalid action status: " + actionStatus);
    }

    public int getActionStatus(VCSContext ctx) {
        HgModuleConfig config = HgModuleConfig.getDefault();
        int status = -1;
        if (ctx == null) {
            ctx = HgUtils.getCurrentContext(null);
        }
        Set files = ctx.getRootFiles();
        for (File file : files) {
            if (config.isExcludedFromCommit(file.getAbsolutePath())) {
                if (status == 1) {
                    return -1;
                }
                status = 2;
                continue;
            }
            if (status == 2) {
                return -1;
            }
            status = 1;
        }
        return status;
    }

    @Override
    protected void performContextAction(Node[] nodes) {
        final VCSContext ctx = HgUtils.getCurrentContext(nodes);
        RequestProcessor rp = Mercurial.getInstance().getRequestProcessor();
        HgProgressSupport support = new HgProgressSupport(this){
            final /* synthetic */ ExcludeFromCommitAction this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void perform() {
                HgModuleConfig config = HgModuleConfig.getDefault();
                int status = this.this$0.getActionStatus(ctx);
                Set files = ctx.getRootFiles();
                ArrayList<String> paths = new ArrayList<String>(files.size());
                for (File file : files) {
                    paths.add(file.getAbsolutePath());
                }
                if (this.isCanceled()) {
                    return;
                }
                if (status != 2) {
                    config.addExclusionPaths(paths);
                } else {
                    config.removeExclusionPaths(paths);
                }
            }
        };
        support.start(rp, "");
    }
}

