/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.rebase;

import java.awt.EventQueue;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import org.netbeans.modules.mercurial.HgException;
import org.netbeans.modules.mercurial.HgProgressSupport;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.OutputLogger;
import org.netbeans.modules.mercurial.WorkingCopyInfo;
import org.netbeans.modules.mercurial.commands.RebaseCommand;
import org.netbeans.modules.mercurial.ui.actions.ContextAction;
import org.netbeans.modules.mercurial.ui.log.HgLogMessage;
import org.netbeans.modules.mercurial.ui.rebase.Bundle;
import org.netbeans.modules.mercurial.ui.rebase.Rebase;
import org.netbeans.modules.mercurial.util.HgCommand;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.hooks.HgHook;
import org.netbeans.modules.versioning.hooks.HgHookContext;
import org.netbeans.modules.versioning.hooks.VCSHooks;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.nodes.Node;
import org.openide.util.RequestProcessor;

public class RebaseAction
extends ContextAction {
    private static final Logger LOG = Logger.getLogger(RebaseAction.class.getName());
    private static final String NB_REBASE_INFO_FILE = "netbeans-rebase.info";

    @Override
    protected boolean enable(Node[] nodes) {
        return HgUtils.isFromHgRepository(HgUtils.getCurrentContext(nodes));
    }

    @Override
    protected String getBaseName(Node[] nodes) {
        return "CTL_MenuItem_RebaseAction";
    }

    @Override
    protected void performContextAction(Node[] nodes) {
        VCSContext ctx = HgUtils.getCurrentContext(nodes);
        File[] roots = HgUtils.getActionRoots(ctx);
        if (roots == null || roots.length == 0) {
            return;
        }
        final File root = Mercurial.getInstance().getRepositoryRoot(roots[0]);
        RequestProcessor rp = Mercurial.getInstance().getRequestProcessor(root);
        HgProgressSupport support = new HgProgressSupport(this){
            final /* synthetic */ RebaseAction this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void perform() {
                HgLogMessage[] workingCopyParents = WorkingCopyInfo.getInstance(root).getWorkingCopyParents();
                if (HgUtils.isRebasing(root)) {
                    EventQueue.invokeLater(new Runnable(){
                        final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        @Override
                        public void run() {
                            this.this$1.this$0.finishRebase(root);
                        }
                    });
                } else if (workingCopyParents.length > 1) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)Bundle.MSG_Rebase_unfinishedMerge(), 0));
                } else {
                    try {
                        final HgLogMessage workingCopyParent = workingCopyParents[0];
                        String currentBranch = HgCommand.getBranch(root);
                        HgLogMessage[] heads = HgCommand.getHeadRevisionsInfo(root, false, OutputLogger.getLogger(null));
                        final Collection<HgLogMessage> branchHeads = HgUtils.sortByBranch(heads).get(currentBranch);
                        if (this.isCanceled()) {
                            return;
                        }
                        if (branchHeads == null) {
                            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)Bundle.MSG_Rebase_noBranchHeads(currentBranch), 0));
                            return;
                        }
                        EventQueue.invokeLater(new Runnable(){
                            final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = this$1;
                            }

                            @Override
                            public void run() {
                                this.this$1.this$0.doRebase(root, workingCopyParent, branchHeads);
                            }
                        });
                    }
                    catch (HgException.HgCommandCanceledException workingCopyParent) {
                    }
                    catch (HgException ex) {
                        HgUtils.notifyException(ex);
                    }
                }
            }
        };
        support.start(rp, root, Bundle.MSG_Rebase_Preparing_Progress());
    }

    public static boolean doRebase(File root, String base, String source, String dest, HgProgressSupport supp) throws HgException {
        OutputLogger logger = supp.getLogger();
        Collection hooks = VCSHooks.getInstance().getHooks(HgHook.class);
        String destRev = dest;
        String sourceRev = source;
        if (!hooks.isEmpty()) {
            try {
                HgLogMessage[] heads;
                Collection<HgLogMessage> branchHeads;
                if (destRev == null && (branchHeads = HgUtils.sortByBranch(heads = HgCommand.getHeadRevisionsInfo(root, false, OutputLogger.getLogger(null))).get(HgCommand.getBranch(root))) != null && !branchHeads.isEmpty()) {
                    HgLogMessage tipmostHead = branchHeads.iterator().next();
                    for (HgLogMessage head : branchHeads) {
                        if (head.getRevisionAsLong() <= tipmostHead.getRevisionAsLong()) continue;
                        tipmostHead = head;
                    }
                    destRev = tipmostHead.getCSetShortID();
                }
                if (supp.isCanceled()) {
                    return false;
                }
                if (sourceRev == null) {
                    String baseRev = base;
                    if (baseRev == null) {
                        baseRev = HgCommand.getParent(root, null, null).getChangesetId();
                    }
                    supp.setDisplayName(Bundle.MSG_RebaseAction_progress_preparingChangesets());
                    String revPattern = MessageFormat.format("last(limit(ancestor({0},{1})::{1}, 2), 1)", destRev, baseRev);
                    HgLogMessage[] revs = HgCommand.getRevisionInfo(root, Collections.singletonList(revPattern), null);
                    if (revs.length == 0) {
                        LOG.log(Level.FINE, "doRebase: no revision returned for {0}", revPattern);
                    } else {
                        sourceRev = revs[0].getCSetShortID();
                    }
                }
            }
            catch (HgException.HgCommandCanceledException baseRev) {
            }
            catch (HgException ex) {
                LOG.log(Level.INFO, null, ex);
            }
        }
        if (supp.isCanceled()) {
            return false;
        }
        supp.setDisplayName(Bundle.MSG_RebaseAction_progress_rebasingChangesets());
        RebaseCommand.Result rebaseResult = new RebaseCommand(root, RebaseCommand.Operation.START, logger).setRevisionBase(base).setRevisionSource(source).setRevisionDest(dest).call();
        RebaseAction.handleRebaseResult(new RebaseHookContext(root, sourceRev, destRev, hooks), rebaseResult, supp);
        return rebaseResult.getState() == RebaseCommand.Result.State.OK;
    }

    private void doRebase(final File root, HgLogMessage workingCopyParent, Collection<HgLogMessage> branchHeads) {
        final Rebase rebase = new Rebase(root, workingCopyParent, branchHeads);
        if (rebase.showDialog()) {
            new HgProgressSupport(this){
                final /* synthetic */ RebaseAction this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                protected void perform() {
                    this.doRebase(rebase);
                }

                private void doRebase(final Rebase rebase2) {
                    final 2 supp = this;
                    OutputLogger logger = this.getLogger();
                    try {
                        logger.outputInRed(Bundle.MSG_Rebase_Title());
                        logger.outputInRed(Bundle.MSG_Rebase_Title_Sep());
                        logger.output(Bundle.MSG_Rebase_Started());
                        HgUtils.runWithoutIndexing(new Callable<Void>(){
                            final /* synthetic */ 2 this$1;
                            {
                                this.this$1 = this$1;
                            }

                            @Override
                            public Void call() throws Exception {
                                RebaseAction.doRebase(root, rebase2.getRevisionBase(), rebase2.getRevisionSource(), rebase2.getRevisionDest(), supp);
                                supp.setDisplayName(Bundle.MSG_RebaseAction_progress_refreshingFiles());
                                HgUtils.forceStatusRefresh(root);
                                return null;
                            }
                        }, root);
                    }
                    catch (HgException.HgCommandCanceledException hgCommandCanceledException) {
                    }
                    catch (HgException ex) {
                        HgUtils.notifyException(ex);
                    }
                    logger.outputInRed(Bundle.MSG_Rebase_Finished());
                    logger.output("");
                }
            }.start(Mercurial.getInstance().getRequestProcessor(root), root, Bundle.MSG_Rebase_Progress());
        }
    }

    private void finishRebase(final File root) {
        JButton btnContinue = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)btnContinue, (String)Bundle.CTL_RebaseAction_continueButton_text());
        btnContinue.setToolTipText(Bundle.CTL_RebaseAction_continueButton_TTtext());
        JButton btnAbort = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)btnAbort, (String)Bundle.CTL_RebaseAction_abortButton_text());
        btnAbort.setToolTipText(Bundle.CTL_RebaseAction_abortButton_TTtext());
        Object value = DialogDisplayer.getDefault().notify(new NotifyDescriptor((Object)Bundle.MSG_Rebase_rebasingState_text(root.getName()), Bundle.LBL_Rebase_rebasingState_title(), 1, 3, new Object[]{btnContinue, btnAbort, NotifyDescriptor.CANCEL_OPTION}, (Object)btnContinue));
        if (value == btnAbort || value == btnContinue) {
            final boolean cont = btnContinue == value;
            new HgProgressSupport(this){
                final /* synthetic */ RebaseAction this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                protected void perform() {
                    this.finishRebase(cont);
                }

                private void finishRebase(final boolean cont2) {
                    final OutputLogger logger = this.getLogger();
                    final 3 supp = this;
                    try {
                        logger.outputInRed(Bundle.MSG_Rebase_Title());
                        logger.outputInRed(Bundle.MSG_Rebase_Title_Sep());
                        logger.output(cont2 ? Bundle.MSG_Rebase_Continue() : Bundle.MSG_Rebase_Abort());
                        HgUtils.runWithoutIndexing(new Callable<Void>(){
                            final /* synthetic */ 3 this$1;
                            {
                                this.this$1 = this$1;
                            }

                            @Override
                            public Void call() throws Exception {
                                RebaseHookContext rebaseCtx = RebaseAction.buildRebaseContext(root);
                                RebaseCommand.Result rebaseResult = new RebaseCommand(root, cont2 ? RebaseCommand.Operation.CONTINUE : RebaseCommand.Operation.ABORT, logger).call();
                                HgUtils.forceStatusRefresh(root);
                                RebaseAction.handleRebaseResult(rebaseCtx, rebaseResult, supp);
                                return null;
                            }
                        }, root);
                    }
                    catch (HgException.HgCommandCanceledException hgCommandCanceledException) {
                    }
                    catch (HgException ex) {
                        HgUtils.notifyException(ex);
                    }
                    logger.outputInRed(Bundle.MSG_Rebase_Finished());
                    logger.output("");
                }
            }.start(Mercurial.getInstance().getRequestProcessor(root), root, Bundle.MSG_Rebase_Progress());
        }
    }

    private static void handleRebaseResult(RebaseHookContext rebaseCtx, RebaseCommand.Result rebaseResult, HgProgressSupport supp) {
        File bundleFile;
        OutputLogger logger = supp.getLogger();
        for (File f : rebaseResult.getTouchedFiles()) {
            Mercurial.getInstance().notifyFileChanged(f);
        }
        logger.output(rebaseResult.getOutput());
        File repository = rebaseCtx.repository;
        Mercurial.getInstance().historyChanged(repository);
        RebaseAction.getNetBeansRebaseInfoFile(repository).delete();
        if (rebaseResult.getState() == RebaseCommand.Result.State.ABORTED) {
            logger.outputInRed(Bundle.MSG_Rebase_Aborted());
        } else if (rebaseResult.getState() == RebaseCommand.Result.State.MERGING) {
            RebaseAction.storeRebaseContext(rebaseCtx);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)Bundle.MSG_Rebase_Merging_Failed(), 0));
            logger.outputInRed(Bundle.MSG_Rebase_Merging_Failed());
        } else if (rebaseResult.getState() == RebaseCommand.Result.State.OK && !rebaseCtx.hooks.isEmpty() && rebaseCtx.source != null && rebaseCtx.dest != null && (bundleFile = rebaseResult.getBundleFile()) != null && bundleFile.exists()) {
            supp.setDisplayName(Bundle.MSG_RebaseAction_progress_repairingPushHooks());
            try {
                HgHookContext.LogEntry[] originalEntries = RebaseAction.findOriginalEntries(repository, bundleFile);
                HgHookContext.LogEntry[] newEntries = RebaseAction.findNewEntries(repository, rebaseCtx.dest);
                Map<String, String> mapping = RebaseAction.findChangesetMapping(originalEntries, newEntries);
                for (HgHook hgHook : rebaseCtx.hooks) {
                    hgHook.afterCommitReplace(new HgHookContext(new File[]{repository}, null, originalEntries), new HgHookContext(new File[]{repository}, null, newEntries), mapping);
                }
            }
            catch (HgException.HgCommandCanceledException originalEntries) {
            }
            catch (HgException ex) {
                LOG.log(Level.INFO, null, ex);
            }
        }
        logger.output("");
    }

    private static HgHookContext.LogEntry[] findOriginalEntries(File repository, File bundleFile) throws HgException {
        List<HgLogMessage> originalMessages = HgCommand.getBundleChangesets(repository, bundleFile, null);
        return RebaseAction.convertToEntries(originalMessages.toArray(new HgLogMessage[0]));
    }

    private static HgHookContext.LogEntry[] findNewEntries(File repository, String destRevision) {
        HgLogMessage[] newMessages = HgCommand.getRevisionInfo(repository, Collections.singletonList(MessageFormat.format("descendants(last(children({0}), 1))", destRevision)), null);
        return RebaseAction.convertToEntries(newMessages);
    }

    private static HgHookContext.LogEntry[] convertToEntries(HgLogMessage[] messages) {
        ArrayList<HgHookContext.LogEntry> entries = new ArrayList<HgHookContext.LogEntry>(messages.length);
        for (HgLogMessage msg : messages) {
            entries.add(new HgHookContext.LogEntry(msg.getMessage(), msg.getAuthor(), msg.getCSetShortID(), msg.getDate()));
        }
        return entries.toArray(new HgHookContext.LogEntry[0]);
    }

    private static Map<String, String> findChangesetMapping(HgHookContext.LogEntry[] originalEntries, HgHookContext.LogEntry[] newEntries) {
        HashMap<String, String> mapping = new HashMap<String, String>(originalEntries.length);
        for (HgHookContext.LogEntry original : originalEntries) {
            boolean found = false;
            for (HgHookContext.LogEntry newEntry : newEntries) {
                if (!original.getDate().equals(newEntry.getDate()) || !original.getAuthor().equals(newEntry.getAuthor()) || !original.getMessage().equals(newEntry.getMessage())) continue;
                mapping.put(original.getChangeset(), newEntry.getChangeset());
                found = true;
                break;
            }
            if (found) continue;
            mapping.put(original.getChangeset(), null);
        }
        return mapping;
    }

    private static File getNetBeansRebaseInfoFile(File root) {
        return new File(HgUtils.getHgFolderForRoot(root), NB_REBASE_INFO_FILE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static RebaseHookContext buildRebaseContext(File root) {
        Collection hooks = VCSHooks.getInstance().getHooks(HgHook.class);
        File info = RebaseAction.getNetBeansRebaseInfoFile(root);
        String source = null;
        String dest = null;
        if (info.canRead()) {
            BufferedReader br = null;
            try {
                br = new BufferedReader(new FileReader(info));
                String line = br.readLine();
                if (line != null) {
                    source = line;
                }
                if ((line = br.readLine()) != null) {
                    dest = line;
                }
            }
            catch (IOException ex) {
                LOG.log(Level.INFO, null, ex);
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return new RebaseHookContext(root, source, dest, hooks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void storeRebaseContext(RebaseHookContext context) {
        if (context.source == null || context.dest == null) {
            return;
        }
        File info = RebaseAction.getNetBeansRebaseInfoFile(context.repository);
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new FileWriter(info));
            bw.write(context.source);
            bw.newLine();
            bw.write(context.dest);
            bw.newLine();
            bw.flush();
        }
        catch (IOException ex) {
            LOG.log(Level.INFO, null, ex);
        }
        finally {
            if (bw != null) {
                try {
                    bw.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static class RebaseHookContext {
        private final File repository;
        private final String source;
        private final String dest;
        private final Collection<HgHook> hooks;

        public RebaseHookContext(File repository, String sourceRev, String destRev, Collection<HgHook> hooks) {
            this.repository = repository;
            this.source = sourceRev;
            this.dest = destRev;
            this.hooks = hooks;
        }
    }
}

