/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.keymanagement;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.keymanagement.KmsVaultAsync;
import com.oracle.bmc.keymanagement.model.Vault;
import com.oracle.bmc.keymanagement.model.VaultReplicaSummary;
import com.oracle.bmc.keymanagement.model.VaultSummary;
import com.oracle.bmc.keymanagement.model.VaultUsage;
import com.oracle.bmc.keymanagement.requests.BackupVaultRequest;
import com.oracle.bmc.keymanagement.requests.CancelVaultDeletionRequest;
import com.oracle.bmc.keymanagement.requests.ChangeVaultCompartmentRequest;
import com.oracle.bmc.keymanagement.requests.CreateVaultReplicaRequest;
import com.oracle.bmc.keymanagement.requests.CreateVaultRequest;
import com.oracle.bmc.keymanagement.requests.DeleteVaultReplicaRequest;
import com.oracle.bmc.keymanagement.requests.GetVaultRequest;
import com.oracle.bmc.keymanagement.requests.GetVaultUsageRequest;
import com.oracle.bmc.keymanagement.requests.ListVaultReplicasRequest;
import com.oracle.bmc.keymanagement.requests.ListVaultsRequest;
import com.oracle.bmc.keymanagement.requests.RestoreVaultFromFileRequest;
import com.oracle.bmc.keymanagement.requests.RestoreVaultFromObjectStoreRequest;
import com.oracle.bmc.keymanagement.requests.ScheduleVaultDeletionRequest;
import com.oracle.bmc.keymanagement.requests.UpdateVaultRequest;
import com.oracle.bmc.keymanagement.responses.BackupVaultResponse;
import com.oracle.bmc.keymanagement.responses.CancelVaultDeletionResponse;
import com.oracle.bmc.keymanagement.responses.ChangeVaultCompartmentResponse;
import com.oracle.bmc.keymanagement.responses.CreateVaultReplicaResponse;
import com.oracle.bmc.keymanagement.responses.CreateVaultResponse;
import com.oracle.bmc.keymanagement.responses.DeleteVaultReplicaResponse;
import com.oracle.bmc.keymanagement.responses.GetVaultResponse;
import com.oracle.bmc.keymanagement.responses.GetVaultUsageResponse;
import com.oracle.bmc.keymanagement.responses.ListVaultReplicasResponse;
import com.oracle.bmc.keymanagement.responses.ListVaultsResponse;
import com.oracle.bmc.keymanagement.responses.RestoreVaultFromFileResponse;
import com.oracle.bmc.keymanagement.responses.RestoreVaultFromObjectStoreResponse;
import com.oracle.bmc.keymanagement.responses.ScheduleVaultDeletionResponse;
import com.oracle.bmc.keymanagement.responses.UpdateVaultResponse;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KmsVaultAsyncClient
extends BaseAsyncClient
implements KmsVaultAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("KMSVAULT").serviceEndpointPrefix("kms").serviceEndpointTemplate("https://kms.{region}.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(KmsVaultAsyncClient.class);

    KmsVaultAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<BackupVaultResponse> backupVault(BackupVaultRequest request, AsyncHandler<BackupVaultRequest, BackupVaultResponse> handler) {
        Validate.notBlank((String)request.getVaultId(), (String)"vaultId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, BackupVaultResponse::builder).logger(LOG, "backupVault").serviceDetails("KmsVault", "BackupVault", "https://docs.oracle.com/iaas/api/#/en/key/release/Vault/BackupVault").method(Method.POST).requestBuilder(BackupVaultRequest::builder).basePath("/").appendPathParam("20180608").appendPathParam("vaults").appendPathParam(request.getVaultId()).appendPathParam("actions").appendPathParam("backup").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(Vault.class, BackupVaultResponse.Builder::vault).handleResponseHeaderString("etag", BackupVaultResponse.Builder::etag).handleResponseHeaderString("opc-request-id", BackupVaultResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", BackupVaultResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<CancelVaultDeletionResponse> cancelVaultDeletion(CancelVaultDeletionRequest request, AsyncHandler<CancelVaultDeletionRequest, CancelVaultDeletionResponse> handler) {
        Validate.notBlank((String)request.getVaultId(), (String)"vaultId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, CancelVaultDeletionResponse::builder).logger(LOG, "cancelVaultDeletion").serviceDetails("KmsVault", "CancelVaultDeletion", "https://docs.oracle.com/iaas/api/#/en/key/release/Vault/CancelVaultDeletion").method(Method.POST).requestBuilder(CancelVaultDeletionRequest::builder).basePath("/").appendPathParam("20180608").appendPathParam("vaults").appendPathParam(request.getVaultId()).appendPathParam("actions").appendPathParam("cancelDeletion").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleBody(Vault.class, CancelVaultDeletionResponse.Builder::vault).handleResponseHeaderString("etag", CancelVaultDeletionResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CancelVaultDeletionResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ChangeVaultCompartmentResponse> changeVaultCompartment(ChangeVaultCompartmentRequest request, AsyncHandler<ChangeVaultCompartmentRequest, ChangeVaultCompartmentResponse> handler) {
        Validate.notBlank((String)request.getVaultId(), (String)"vaultId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeVaultCompartmentDetails(), "changeVaultCompartmentDetails is required");
        return this.clientCall(request, ChangeVaultCompartmentResponse::builder).logger(LOG, "changeVaultCompartment").serviceDetails("KmsVault", "ChangeVaultCompartment", "https://docs.oracle.com/iaas/api/#/en/key/release/Vault/ChangeVaultCompartment").method(Method.POST).requestBuilder(ChangeVaultCompartmentRequest::builder).basePath("/").appendPathParam("20180608").appendPathParam("vaults").appendPathParam(request.getVaultId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("etag", ChangeVaultCompartmentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", ChangeVaultCompartmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateVaultResponse> createVault(CreateVaultRequest request, AsyncHandler<CreateVaultRequest, CreateVaultResponse> handler) {
        Objects.requireNonNull(request.getCreateVaultDetails(), "createVaultDetails is required");
        return this.clientCall(request, CreateVaultResponse::builder).logger(LOG, "createVault").serviceDetails("KmsVault", "CreateVault", "https://docs.oracle.com/iaas/api/#/en/key/release/Vault/CreateVault").method(Method.POST).requestBuilder(CreateVaultRequest::builder).basePath("/").appendPathParam("20180608").appendPathParam("vaults").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(Vault.class, CreateVaultResponse.Builder::vault).handleResponseHeaderString("etag", CreateVaultResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateVaultResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateVaultReplicaResponse> createVaultReplica(CreateVaultReplicaRequest request, AsyncHandler<CreateVaultReplicaRequest, CreateVaultReplicaResponse> handler) {
        Validate.notBlank((String)request.getVaultId(), (String)"vaultId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreateVaultReplicaDetails(), "createVaultReplicaDetails is required");
        return this.clientCall(request, CreateVaultReplicaResponse::builder).logger(LOG, "createVaultReplica").serviceDetails("KmsVault", "CreateVaultReplica", "https://docs.oracle.com/iaas/api/#/en/key/release/Vault/CreateVaultReplica").method(Method.POST).requestBuilder(CreateVaultReplicaRequest::builder).basePath("/").appendPathParam("20180608").appendPathParam("vaults").appendPathParam(request.getVaultId()).appendPathParam("actions").appendPathParam("createReplica").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", CreateVaultReplicaResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", CreateVaultReplicaResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteVaultReplicaResponse> deleteVaultReplica(DeleteVaultReplicaRequest request, AsyncHandler<DeleteVaultReplicaRequest, DeleteVaultReplicaResponse> handler) {
        Validate.notBlank((String)request.getVaultId(), (String)"vaultId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getDeleteVaultReplicaDetails(), "deleteVaultReplicaDetails is required");
        return this.clientCall(request, DeleteVaultReplicaResponse::builder).logger(LOG, "deleteVaultReplica").serviceDetails("KmsVault", "DeleteVaultReplica", "https://docs.oracle.com/iaas/api/#/en/key/release/Vault/DeleteVaultReplica").method(Method.POST).requestBuilder(DeleteVaultReplicaRequest::builder).basePath("/").appendPathParam("20180608").appendPathParam("vaults").appendPathParam(request.getVaultId()).appendPathParam("actions").appendPathParam("deleteReplica").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", DeleteVaultReplicaResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", DeleteVaultReplicaResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<GetVaultResponse> getVault(GetVaultRequest request, AsyncHandler<GetVaultRequest, GetVaultResponse> handler) {
        Validate.notBlank((String)request.getVaultId(), (String)"vaultId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetVaultResponse::builder).logger(LOG, "getVault").serviceDetails("KmsVault", "GetVault", "https://docs.oracle.com/iaas/api/#/en/key/release/Vault/GetVault").method(Method.GET).requestBuilder(GetVaultRequest::builder).basePath("/").appendPathParam("20180608").appendPathParam("vaults").appendPathParam(request.getVaultId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Vault.class, GetVaultResponse.Builder::vault).handleResponseHeaderString("etag", GetVaultResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetVaultResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetVaultUsageResponse> getVaultUsage(GetVaultUsageRequest request, AsyncHandler<GetVaultUsageRequest, GetVaultUsageResponse> handler) {
        Validate.notBlank((String)request.getVaultId(), (String)"vaultId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetVaultUsageResponse::builder).logger(LOG, "getVaultUsage").serviceDetails("KmsVault", "GetVaultUsage", "https://docs.oracle.com/iaas/api/#/en/key/release/VaultUsage/GetVaultUsage").method(Method.GET).requestBuilder(GetVaultUsageRequest::builder).basePath("/").appendPathParam("20180608").appendPathParam("vaults").appendPathParam(request.getVaultId()).appendPathParam("usage").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(VaultUsage.class, GetVaultUsageResponse.Builder::vaultUsage).handleResponseHeaderString("opc-request-id", GetVaultUsageResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListVaultReplicasResponse> listVaultReplicas(ListVaultReplicasRequest request, AsyncHandler<ListVaultReplicasRequest, ListVaultReplicasResponse> handler) {
        Validate.notBlank((String)request.getVaultId(), (String)"vaultId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListVaultReplicasResponse::builder).logger(LOG, "listVaultReplicas").serviceDetails("KmsVault", "ListVaultReplicas", "https://docs.oracle.com/iaas/api/#/en/key/release/Vault/ListVaultReplicas").method(Method.GET).requestBuilder(ListVaultReplicasRequest::builder).basePath("/").appendPathParam("20180608").appendPathParam("vaults").appendPathParam(request.getVaultId()).appendPathParam("actions").appendPathParam("listReplicas").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleBodyList(VaultReplicaSummary.class, ListVaultReplicasResponse.Builder::items).handleResponseHeaderString("etag", ListVaultReplicasResponse.Builder::etag).handleResponseHeaderString("opc-next-page", ListVaultReplicasResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListVaultReplicasResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListVaultsResponse> listVaults(ListVaultsRequest request, AsyncHandler<ListVaultsRequest, ListVaultsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListVaultsResponse::builder).logger(LOG, "listVaults").serviceDetails("KmsVault", "ListVaults", "https://docs.oracle.com/iaas/api/#/en/key/release/VaultSummary/ListVaults").method(Method.GET).requestBuilder(ListVaultsRequest::builder).basePath("/").appendPathParam("20180608").appendPathParam("vaults").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(VaultSummary.class, ListVaultsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListVaultsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListVaultsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<RestoreVaultFromFileResponse> restoreVaultFromFile(RestoreVaultFromFileRequest request, AsyncHandler<RestoreVaultFromFileRequest, RestoreVaultFromFileResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        Objects.requireNonNull(request.getRestoreVaultFromFileDetails(), "restoreVaultFromFileDetails is required");
        return this.clientCall(request, RestoreVaultFromFileResponse::builder).logger(LOG, "restoreVaultFromFile").serviceDetails("KmsVault", "RestoreVaultFromFile", "https://docs.oracle.com/iaas/api/#/en/key/release/Vault/RestoreVaultFromFile").method(Method.POST).requestBuilder(RestoreVaultFromFileRequest::builder).basePath("/").appendPathParam("20180608").appendPathParam("vaults").appendPathParam("actions").appendPathParam("restoreFromFile").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json"}).appendHeader("content-length", (Number)request.getContentLength()).appendHeader("if-match", request.getIfMatch()).appendHeader("content-md5", request.getContentMd5()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBinaryRequestBody().hasBody().handleBody(Vault.class, RestoreVaultFromFileResponse.Builder::vault).handleResponseHeaderString("etag", RestoreVaultFromFileResponse.Builder::etag).handleResponseHeaderString("opc-content-md5", RestoreVaultFromFileResponse.Builder::opcContentMd5).handleResponseHeaderString("opc-request-id", RestoreVaultFromFileResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", RestoreVaultFromFileResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<RestoreVaultFromObjectStoreResponse> restoreVaultFromObjectStore(RestoreVaultFromObjectStoreRequest request, AsyncHandler<RestoreVaultFromObjectStoreRequest, RestoreVaultFromObjectStoreResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, RestoreVaultFromObjectStoreResponse::builder).logger(LOG, "restoreVaultFromObjectStore").serviceDetails("KmsVault", "RestoreVaultFromObjectStore", "https://docs.oracle.com/iaas/api/#/en/key/release/Vault/RestoreVaultFromObjectStore").method(Method.POST).requestBuilder(RestoreVaultFromObjectStoreRequest::builder).basePath("/").appendPathParam("20180608").appendPathParam("vaults").appendPathParam("actions").appendPathParam("restoreFromObjectStore").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(Vault.class, RestoreVaultFromObjectStoreResponse.Builder::vault).handleResponseHeaderString("etag", RestoreVaultFromObjectStoreResponse.Builder::etag).handleResponseHeaderString("opc-request-id", RestoreVaultFromObjectStoreResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", RestoreVaultFromObjectStoreResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<ScheduleVaultDeletionResponse> scheduleVaultDeletion(ScheduleVaultDeletionRequest request, AsyncHandler<ScheduleVaultDeletionRequest, ScheduleVaultDeletionResponse> handler) {
        Validate.notBlank((String)request.getVaultId(), (String)"vaultId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getScheduleVaultDeletionDetails(), "scheduleVaultDeletionDetails is required");
        return this.clientCall(request, ScheduleVaultDeletionResponse::builder).logger(LOG, "scheduleVaultDeletion").serviceDetails("KmsVault", "ScheduleVaultDeletion", "https://docs.oracle.com/iaas/api/#/en/key/release/Vault/ScheduleVaultDeletion").method(Method.POST).requestBuilder(ScheduleVaultDeletionRequest::builder).basePath("/").appendPathParam("20180608").appendPathParam("vaults").appendPathParam(request.getVaultId()).appendPathParam("actions").appendPathParam("scheduleDeletion").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(Vault.class, ScheduleVaultDeletionResponse.Builder::vault).handleResponseHeaderString("etag", ScheduleVaultDeletionResponse.Builder::etag).handleResponseHeaderString("opc-request-id", ScheduleVaultDeletionResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateVaultResponse> updateVault(UpdateVaultRequest request, AsyncHandler<UpdateVaultRequest, UpdateVaultResponse> handler) {
        Validate.notBlank((String)request.getVaultId(), (String)"vaultId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateVaultDetails(), "updateVaultDetails is required");
        return this.clientCall(request, UpdateVaultResponse::builder).logger(LOG, "updateVault").serviceDetails("KmsVault", "UpdateVault", "https://docs.oracle.com/iaas/api/#/en/key/release/Vault/UpdateVault").method(Method.PUT).requestBuilder(UpdateVaultRequest::builder).basePath("/").appendPathParam("20180608").appendPathParam("vaults").appendPathParam(request.getVaultId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Vault.class, UpdateVaultResponse.Builder::vault).handleResponseHeaderString("etag", UpdateVaultResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateVaultResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Deprecated
    public KmsVaultAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)KmsVaultAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public KmsVaultAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(KmsVaultAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public KmsVaultAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)KmsVaultAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public KmsVaultAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)KmsVaultAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public KmsVaultAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)KmsVaultAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public KmsVaultAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)KmsVaultAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public KmsVaultAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)KmsVaultAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, KmsVaultAsyncClient> {
        private Builder(Service service) {
            super(service);
            String packageName = "keymanagement";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"keymanagement");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public KmsVaultAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new KmsVaultAsyncClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider);
        }
    }
}

