/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.karma.coverage;

import java.io.File;
import java.util.Enumeration;
import org.netbeans.modules.javascript.karma.coverage.CoverageProcessor;
import org.netbeans.modules.web.clientproject.api.jstesting.Coverage;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.RequestProcessor;

public final class CoverageWatcher {
    static final String COVERAGE_FILENAME = "clover.xml";
    private static final RequestProcessor RP = new RequestProcessor(CoverageWatcher.class);
    private final Coverage coverage;
    private final File sourceDir;
    private final File coverageDir;
    private final FileChangeListener fileChangeListener = new FileChangeListenerImpl();
    private volatile boolean coverageProcessing = false;

    public CoverageWatcher(Coverage coverage, File sourceDir, File coverageDir) {
        assert (coverage != null);
        assert (sourceDir.isDirectory()) : sourceDir;
        assert (coverageDir != null);
        this.coverage = coverage;
        this.sourceDir = sourceDir;
        this.coverageDir = coverageDir;
    }

    public void start() {
        FileUtil.addRecursiveListener((FileChangeListener)this.fileChangeListener, (File)this.coverageDir);
    }

    public void stop() {
        FileUtil.removeRecursiveListener((FileChangeListener)this.fileChangeListener, (File)this.coverageDir);
    }

    void process(final File logFile) {
        assert (logFile.isFile());
        if (this.coverageProcessing) {
            return;
        }
        this.coverageProcessing = true;
        RP.post(new Runnable(){
            final /* synthetic */ CoverageWatcher this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                this.this$0.processInternal(logFile);
            }
        });
    }

    void processInternal(File logFile) {
        try {
            if (this.coverage.isEnabled()) {
                new CoverageProcessor(this.coverage, this.sourceDir, logFile).process();
            }
        }
        finally {
            this.coverageProcessing = false;
        }
    }

    private final class FileChangeListenerImpl
    extends FileChangeAdapter {
        private FileChangeListenerImpl() {
        }

        public void fileFolderCreated(FileEvent fe) {
            this.processFolder(fe.getFile());
        }

        public void fileChanged(FileEvent fe) {
            this.processFile(fe.getFile());
        }

        public void fileDataCreated(FileEvent fe) {
            this.processFile(fe.getFile());
        }

        private void processFolder(FileObject folder) {
            assert (folder.isFolder()) : folder;
            Enumeration children = folder.getChildren(true);
            while (children.hasMoreElements()) {
                FileObject child = (FileObject)children.nextElement();
                if (!child.isData()) continue;
                this.processFile(child);
            }
        }

        private void processFile(FileObject file) {
            assert (file.isData()) : file;
            if (CoverageWatcher.COVERAGE_FILENAME.equals(file.getNameExt())) {
                CoverageWatcher.this.process(FileUtil.toFile((FileObject)file));
            }
        }
    }
}

