/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.micronaut.expression;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.micronaut.expression.ExpressionTree;

public class MicronautExpressionLanguageParser {
    public static final Pattern MEXP_PATTERN = Pattern.compile("#\\{(.*?)}");
    private final TokenSequence<?> ts;
    private String tokenType;
    private int lastPos;

    public MicronautExpressionLanguageParser(String text) {
        TokenHierarchy th = TokenHierarchy.create((CharSequence)text, (Language)Language.find((String)"text/x-micronaut-el"));
        this.ts = th.tokenSequence();
        this.next();
    }

    public ExpressionTree parse() {
        ArrayList<ExpressionTree> expressions = new ArrayList<ExpressionTree>();
        while (!this.tokenType.isEmpty()) {
            int pos = this.ts.offset();
            expressions.add(this.expression());
            if (this.ts.offset() != pos) continue;
            this.next();
        }
        return expressions.isEmpty() ? null : (expressions.size() == 1 ? (ExpressionTree)expressions.get(0) : new ExpressionTree.Erroneous(expressions, this.ts.offset(), this.ts.offset() + this.ts.token().length()));
    }

    private ExpressionTree expression() {
        return this.ternaryExpression();
    }

    private ExpressionTree ternaryExpression() {
        ExpressionTree orExpression = this.orExpression();
        if ("keyword.control.ternary.qmark.mexp".equals(this.tokenType)) {
            ExpressionTree falseExpr;
            this.next();
            ExpressionTree trueExpr = this.expression();
            if ("keyword.control.ternary.colon.mexp".equals(this.tokenType)) {
                this.next();
                falseExpr = this.expression();
            } else {
                falseExpr = this.erroneous(new ExpressionTree[0]);
            }
            return new ExpressionTree.TernaryExpression(orExpression, trueExpr, falseExpr);
        }
        if ("keyword.operator.elvis.mexp".equals(this.tokenType)) {
            this.next();
            ExpressionTree falseExpr = this.expression();
            return new ExpressionTree.BinaryExpression(ExpressionTree.Kind.ELVIS, orExpression, falseExpr);
        }
        return orExpression;
    }

    private ExpressionTree orExpression() {
        ExpressionTree leftNode = this.andExpression();
        while ("keyword.operator.logical.or.mexp".equals(this.tokenType)) {
            this.next();
            leftNode = new ExpressionTree.BinaryExpression(ExpressionTree.Kind.OR, leftNode, this.andExpression());
        }
        return leftNode;
    }

    private ExpressionTree andExpression() {
        ExpressionTree leftNode = this.equalityExpression();
        while ("keyword.operator.logical.and.mexp".equals(this.tokenType)) {
            this.next();
            leftNode = new ExpressionTree.BinaryExpression(ExpressionTree.Kind.AND, leftNode, this.equalityExpression());
        }
        return leftNode;
    }

    private ExpressionTree equalityExpression() {
        ExpressionTree leftNode = this.relationalExpression();
        while ("keyword.operator.comparison.eq.mexp".equals(this.tokenType)) {
            String tokenText = this.ts.token().text().toString();
            this.next();
            leftNode = new ExpressionTree.BinaryExpression("==".equals(tokenText) ? ExpressionTree.Kind.EQUAL_TO : ExpressionTree.Kind.NOT_EQUAL_TO, leftNode, this.relationalExpression());
        }
        return leftNode;
    }

    private ExpressionTree relationalExpression() {
        ExpressionTree leftNode = this.additiveExpression();
        while ("keyword.operator.comparison.rel.mexp".equals(this.tokenType) || "keyword.operator.instanceof.mexp".equals(this.tokenType)) {
            String tokenText = this.ts.token().text().toString();
            this.next();
            switch (tokenText) {
                case ">": {
                    leftNode = new ExpressionTree.BinaryExpression(ExpressionTree.Kind.GREATER_THAN, leftNode, this.additiveExpression());
                    break;
                }
                case "<": {
                    leftNode = new ExpressionTree.BinaryExpression(ExpressionTree.Kind.LESS_THAN, leftNode, this.additiveExpression());
                    break;
                }
                case ">=": {
                    leftNode = new ExpressionTree.BinaryExpression(ExpressionTree.Kind.GREATER_THAN_EQUAL, leftNode, this.additiveExpression());
                    break;
                }
                case "<=": {
                    leftNode = new ExpressionTree.BinaryExpression(ExpressionTree.Kind.LESS_THAN_EQUAL, leftNode, this.additiveExpression());
                    break;
                }
                case "matches": {
                    leftNode = new ExpressionTree.BinaryExpression(ExpressionTree.Kind.MATCHES, leftNode, this.stringLiteral());
                    break;
                }
                case "instanceof": {
                    leftNode = new ExpressionTree.InstanceOf(leftNode, this.typeReference(true));
                }
            }
        }
        return leftNode;
    }

    private ExpressionTree additiveExpression() {
        ExpressionTree leftNode = this.multiplicativeExpression();
        while ("keyword.operator.arithmetic.add.mexp".equals(this.tokenType)) {
            String tokenText = this.ts.token().text().toString();
            this.next();
            leftNode = new ExpressionTree.BinaryExpression("+".equals(tokenText) ? ExpressionTree.Kind.PLUS : ExpressionTree.Kind.MINUS, leftNode, this.multiplicativeExpression());
        }
        return leftNode;
    }

    private ExpressionTree multiplicativeExpression() {
        ExpressionTree leftNode = this.powExpression();
        while ("keyword.operator.arithmetic.mul.mexp".equals(this.tokenType)) {
            String tokenText = this.ts.token().text().toString();
            this.next();
            switch (tokenText) {
                case "*": {
                    leftNode = new ExpressionTree.BinaryExpression(ExpressionTree.Kind.MULTIPLY, leftNode, this.powExpression());
                    break;
                }
                case "/": 
                case "div": {
                    leftNode = new ExpressionTree.BinaryExpression(ExpressionTree.Kind.DIVIDE, leftNode, this.powExpression());
                    break;
                }
                case "%": 
                case "mod": {
                    leftNode = new ExpressionTree.BinaryExpression(ExpressionTree.Kind.REMAINDER, leftNode, this.powExpression());
                }
            }
        }
        return leftNode;
    }

    private ExpressionTree powExpression() {
        ExpressionTree leftNode = this.unaryExpression();
        while ("keyword.operator.arithmetic.pow.mexp".equals(this.tokenType)) {
            this.next();
            leftNode = new ExpressionTree.BinaryExpression(ExpressionTree.Kind.POWER, leftNode, this.unaryExpression());
        }
        return leftNode;
    }

    private ExpressionTree unaryExpression() {
        String tokenText = this.ts.token().text().toString();
        int pos = this.tokenType.isEmpty() ? this.lastPos : this.ts.offset();
        switch (tokenText) {
            case "+": {
                this.next();
                return new ExpressionTree.UnaryExpression(ExpressionTree.Kind.UNARY_PLUS, this.unaryExpression(), pos);
            }
            case "-": {
                this.next();
                return new ExpressionTree.UnaryExpression(ExpressionTree.Kind.UNARY_MINUS, this.unaryExpression(), pos);
            }
            case "!": 
            case "not": {
                this.next();
                return new ExpressionTree.UnaryExpression(ExpressionTree.Kind.NOT, this.unaryExpression(), pos);
            }
            case "empty": {
                this.next();
                return new ExpressionTree.UnaryExpression(ExpressionTree.Kind.EMPTY, this.unaryExpression(), pos);
            }
        }
        return this.postfixExpression();
    }

    private ExpressionTree postfixExpression() {
        ExpressionTree leftNode = this.primaryExpression();
        block7: while ("punctuation.accessor.mexp".equals(this.tokenType) || "punctuation.accessor.optional.mexp".equals(this.tokenType) || "punctuation.bracket.square.beging.mexp".equals(this.tokenType)) {
            String tokenText;
            switch (tokenText = this.ts.token().text().toString()) {
                case ".": 
                case "?.": {
                    this.next();
                    leftNode = this.methodOrPropertyAccess(leftNode);
                    continue block7;
                }
            }
            leftNode = this.arrayAccess(leftNode);
        }
        return leftNode;
    }

    private ExpressionTree primaryExpression() {
        switch (this.tokenType) {
            case "punctuation.accessor.bean.mexp": {
                return this.evaluationContextAccess(true);
            }
            case "entity.name.function.mexp": 
            case "variable.other.object.property.mexp": {
                return this.evaluationContextAccess(false);
            }
            case "support.function.environment.mexp": {
                return this.environmentAccess();
            }
            case "support.function.bean-context.mexp": {
                return this.beanContextAccess();
            }
            case "variable.language.this.mexp": {
                return this.thisAccess();
            }
            case "support.function.type-reference.mexp": {
                return this.typeReference(true);
            }
            case "punctuation.bracket.round.begin.mexp": {
                return this.parenthesizedExpression();
            }
        }
        return this.literal();
    }

    private ExpressionTree thisAccess() {
        ExpressionTree.ThisAccess access = new ExpressionTree.ThisAccess(this.tokenType.isEmpty() ? this.lastPos : this.ts.offset(), this.ts.offset() + this.ts.token().length());
        this.next();
        return access;
    }

    private ExpressionTree evaluationContextAccess(boolean prefixed) {
        int start;
        int n = start = this.tokenType.isEmpty() ? this.lastPos : this.ts.offset();
        if (prefixed) {
            this.next();
        }
        if ("entity.name.function.mexp".equals(this.tokenType)) {
            String identifier = this.ts.token().text().toString();
            this.next();
            List<? extends ExpressionTree> arguments = this.methodArguments();
            return new ExpressionTree.MethodCall(identifier, arguments, start, this.lastPos);
        }
        if ("variable.other.object.property.mexp".equals(this.tokenType)) {
            String identifier = this.ts.token().text().toString();
            this.next();
            return new ExpressionTree.PropertyAccess(identifier, start, this.lastPos);
        }
        return this.erroneous(start, new ExpressionTree[0]);
    }

    private ExpressionTree beanContextAccess() {
        int start = this.tokenType.isEmpty() ? this.lastPos : this.ts.offset();
        this.next();
        if (!"punctuation.bracket.square.beging.mexp".equals(this.tokenType)) {
            return this.erroneous(start, new ExpressionTree[0]);
        }
        this.next();
        ExpressionTree.TypeReference typeReference = this.typeReference("support.function.type-reference.mexp".equals(this.tokenType));
        if ("punctuation.bracket.square.end.mexp".equals(this.tokenType)) {
            ExpressionTree.BeanContextAccess access = new ExpressionTree.BeanContextAccess(typeReference, start, this.ts.offset() + this.ts.token().length());
            this.next();
            return access;
        }
        return this.erroneous(start, typeReference);
    }

    private ExpressionTree environmentAccess() {
        int start = this.tokenType.isEmpty() ? this.lastPos : this.ts.offset();
        this.next();
        if (!"punctuation.bracket.square.beging.mexp".equals(this.tokenType)) {
            return this.erroneous(start, new ExpressionTree[0]);
        }
        this.next();
        ExpressionTree propertyName = this.expression();
        if ("punctuation.bracket.square.end.mexp".equals(this.tokenType)) {
            ExpressionTree.EnvironmentAccess access = new ExpressionTree.EnvironmentAccess(propertyName, start, this.ts.offset() + this.ts.token().length());
            this.next();
            return access;
        }
        return this.erroneous(start, propertyName);
    }

    private ExpressionTree methodOrPropertyAccess(ExpressionTree callee) {
        if ("entity.name.function.mexp".equals(this.tokenType)) {
            String identifier = this.ts.token().text().toString();
            this.next();
            List<? extends ExpressionTree> arguments = this.methodArguments();
            return new ExpressionTree.MethodCall(callee, identifier, arguments, this.lastPos);
        }
        if ("variable.other.object.property.mexp".equals(this.tokenType)) {
            String identifier = this.ts.token().text().toString();
            this.next();
            return new ExpressionTree.PropertyAccess(callee, identifier, this.lastPos);
        }
        return this.erroneous(new ExpressionTree.PropertyAccess(callee, "", this.tokenType.isEmpty() ? this.ts.offset() + this.ts.token().length() : this.ts.offset()));
    }

    private ExpressionTree arrayAccess(ExpressionTree callee) {
        this.next();
        ExpressionTree index = this.expression();
        if ("punctuation.bracket.square.end.mexp".equals(this.tokenType)) {
            ExpressionTree.ArrayAccess access = new ExpressionTree.ArrayAccess(callee, index, this.ts.offset() + this.ts.token().length());
            this.next();
            return access;
        }
        return this.erroneous(callee, index);
    }

    private List<? extends ExpressionTree> methodArguments() {
        this.next();
        List<Object> arguments = new ArrayList();
        if (!"punctuation.bracket.round.end.mexp".equals(this.tokenType)) {
            arguments = this.methodArgumentsList();
        }
        this.next();
        return arguments;
    }

    private List<? extends ExpressionTree> methodArgumentsList() {
        ArrayList<ExpressionTree> arguments = new ArrayList<ExpressionTree>();
        arguments.add(this.expression());
        while (!"punctuation.bracket.round.end.mexp".equals(this.tokenType)) {
            if ("punctuation.separator.arguments.mexp".equals(this.tokenType)) {
                this.next();
            }
            int pos = this.ts.offset();
            arguments.add(this.expression());
            if (pos != this.ts.offset() || "punctuation.bracket.round.end.mexp".equals(this.tokenType) || !"punctuation.separator.arguments.mexp".equals(this.tokenType)) continue;
            this.next();
        }
        return arguments;
    }

    private ExpressionTree.TypeReference typeReference(boolean wrapped) {
        int start;
        int n = start = this.tokenType.isEmpty() ? this.ts.offset() + this.ts.token().length() : this.ts.offset();
        if (wrapped) {
            this.next();
            if ("punctuation.bracket.round.begin.mexp".equals(this.tokenType)) {
                this.next();
            }
        }
        int typeStart = this.tokenType.isEmpty() ? this.ts.offset() + this.ts.token().length() : this.ts.offset();
        StringBuilder sb = new StringBuilder();
        while ("storage.type.java".equals(this.tokenType)) {
            sb.append(this.ts.token().text());
            this.next();
            if (!"punctuation.accessor.mexp".equals(this.tokenType)) break;
            sb.append('.');
            this.next();
        }
        if (wrapped && "punctuation.bracket.round.end.mexp".equals(this.tokenType)) {
            this.next();
        }
        return new ExpressionTree.TypeReference(sb.toString(), typeStart, start, Math.max(start, this.lastPos));
    }

    private ExpressionTree parenthesizedExpression() {
        int start = this.tokenType.isEmpty() ? this.lastPos : this.ts.offset();
        this.next();
        ExpressionTree parenthesizedExpression = this.expression();
        if ("punctuation.bracket.round.end.mexp".equals(this.tokenType)) {
            int end = this.ts.offset() + this.ts.token().length();
            this.next();
            return new ExpressionTree.ParenthesizedExpression(ExpressionTree.Kind.PARENTHESIZED, parenthesizedExpression, start, end);
        }
        return this.erroneous(start, parenthesizedExpression);
    }

    private ExpressionTree literal() {
        switch (this.tokenType) {
            case "constant.language.null.mexp": {
                return this.nullLiteral();
            }
            case "constant.boolean.mexp": {
                return this.boolLiteral();
            }
            case "punctuation.definition.string.begin.mexp": {
                return this.stringLiteral();
            }
            case "constant.numeric.int.mexp": {
                return this.intLiteral();
            }
            case "constant.numeric.long.mexp": {
                return this.longLiteral();
            }
            case "constant.numeric.float.mexp": {
                return this.floatLiteral();
            }
            case "constant.numeric.double.mexp": {
                return this.doubleLiteral();
            }
        }
        return this.erroneous(new ExpressionTree[0]);
    }

    private ExpressionTree nullLiteral() {
        ExpressionTree.Literal literal = new ExpressionTree.Literal(ExpressionTree.Kind.NULL_LITERAL, null, this.ts.offset(), this.ts.offset() + this.ts.token().length());
        this.next();
        return literal;
    }

    private ExpressionTree boolLiteral() {
        ExpressionTree.Literal literal = new ExpressionTree.Literal(ExpressionTree.Kind.BOOLEAN_LITERAL, Boolean.parseBoolean(this.ts.token().text().toString()), this.ts.offset(), this.ts.offset() + this.ts.token().length());
        this.next();
        return literal;
    }

    private ExpressionTree stringLiteral() {
        int start = this.tokenType.isEmpty() ? this.lastPos : this.ts.offset();
        this.next();
        String value = "";
        if ("string.quoted.single.mexp".equals(this.tokenType)) {
            value = this.ts.token().text().toString();
            this.next();
        }
        if ("punctuation.definition.string.end.mexp".equals(this.tokenType)) {
            ExpressionTree.Literal literal = new ExpressionTree.Literal(ExpressionTree.Kind.STRING_LITERAL, value, start, this.ts.offset() + this.ts.token().length());
            this.next();
            return literal;
        }
        return this.erroneous(start, new ExpressionTree[0]);
    }

    private ExpressionTree intLiteral() {
        ExpressionTree.Literal literal = new ExpressionTree.Literal(ExpressionTree.Kind.INT_LITERAL, Integer.decode(this.ts.token().text().toString()), this.ts.offset(), this.ts.offset() + this.ts.token().length());
        this.next();
        return literal;
    }

    private ExpressionTree longLiteral() {
        ExpressionTree.Literal literal = new ExpressionTree.Literal(ExpressionTree.Kind.LONG_LITERAL, Long.decode(this.ts.token().text().toString().replaceAll("([lL])", "")), this.ts.offset(), this.ts.offset() + this.ts.token().length());
        this.next();
        return literal;
    }

    private ExpressionTree floatLiteral() {
        ExpressionTree.Literal literal = new ExpressionTree.Literal(ExpressionTree.Kind.FLOAT_LITERAL, Float.valueOf(Float.parseFloat(this.ts.token().text().toString())), this.ts.offset(), this.ts.offset() + this.ts.token().length());
        this.next();
        return literal;
    }

    private ExpressionTree doubleLiteral() {
        ExpressionTree.Literal literal = new ExpressionTree.Literal(ExpressionTree.Kind.DOUBLE_LITERAL, Double.parseDouble(this.ts.token().text().toString()), this.ts.offset(), this.ts.offset() + this.ts.token().length());
        this.next();
        return literal;
    }

    private ExpressionTree erroneous(ExpressionTree ... errors) {
        return this.erroneous(this.lastPos, errors);
    }

    private ExpressionTree erroneous(int pos, ExpressionTree ... errors) {
        return new ExpressionTree.Erroneous(Arrays.asList(errors), pos, this.tokenType.isEmpty() ? this.ts.offset() + this.ts.token().length() : this.ts.offset());
    }

    private boolean next() {
        int n = this.lastPos = this.ts.token() != null ? this.ts.offset() + this.ts.token().length() : 0;
        while (this.ts.moveNext()) {
            String category;
            List categories = (List)this.ts.token().getProperty((Object)"categories");
            if (categories == null || categories.size() <= 1 || (category = (String)categories.get(categories.size() - 1)).startsWith("meta.")) continue;
            this.tokenType = category;
            return true;
        }
        this.tokenType = "";
        return false;
    }
}

