/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.docker.ui;

import java.awt.Font;
import java.awt.FontMetrics;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableModel;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.docker.api.DockerAction;
import org.netbeans.modules.docker.api.DockerImage;
import org.netbeans.modules.docker.api.DockerInstance;
import org.netbeans.modules.docker.api.DockerTag;
import org.openide.util.RequestProcessor;

public final class UiUtils {
    private static final Logger LOGGER = Logger.getLogger(UiUtils.class.getName());
    private static final Comparator<DockerInstance> INSTANCE_COMPARATOR = new Comparator<DockerInstance>(){

        @Override
        public int compare(DockerInstance o1, DockerInstance o2) {
            boolean firstNull = false;
            boolean secondNull = false;
            if (o1.getDisplayName() == null) {
                LOGGER.log(Level.INFO, "Instance display name is null for {0}", o1);
                firstNull = true;
            }
            if (o2.getDisplayName() == null) {
                LOGGER.log(Level.INFO, "Instance display name is null for {0}", o2);
                secondNull = true;
            }
            if (firstNull && secondNull) {
                return 0;
            }
            if (firstNull && !secondNull) {
                return -1;
            }
            if (!firstNull && secondNull) {
                return 1;
            }
            return o1.getDisplayName().compareTo(o2.getDisplayName());
        }
    };

    private UiUtils() {
    }

    public static String getValue(JComboBox<String> combo) {
        if (combo.isEditable()) {
            return UiUtils.getValue((String)combo.getEditor().getItem());
        }
        return UiUtils.getValue((String)combo.getSelectedItem());
    }

    public static String getValue(JTextComponent c) {
        return UiUtils.getValue(c.getText());
    }

    public static String getValue(String str) {
        String value = str;
        if (value != null && (value = value.trim()).isEmpty()) {
            return null;
        }
        return value;
    }

    public static boolean isEmpty(JTable table) {
        DefaultTableModel model = (DefaultTableModel)table.getModel();
        if (model == null) {
            return true;
        }
        return model.getRowCount() == 0;
    }

    public static void configureRowHeight(JTable table) {
        FontMetrics metrics;
        int height = table.getRowHeight();
        Font cellFont = UIManager.getFont("TextField.font");
        if (cellFont != null && (metrics = table.getFontMetrics(cellFont)) != null) {
            height = metrics.getHeight() + 2;
        }
        table.setRowHeight(Math.max(table.getRowHeight(), height));
    }

    public static Collection<String> getAddresses(boolean includeIpv6, boolean includeDocker) {
        HashSet<InetAddress> addresses = new HashSet<InetAddress>();
        try {
            Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
            while (e.hasMoreElements()) {
                NetworkInterface iface = e.nextElement();
                if (!includeDocker && iface.getName().contains("docker")) continue;
                Enumeration<InetAddress> ei = iface.getInetAddresses();
                while (ei.hasMoreElements()) {
                    InetAddress addr = ei.nextElement();
                    if (addr.isLinkLocalAddress() || !includeIpv6 && addr instanceof Inet6Address) continue;
                    addresses.add(addr);
                }
            }
        }
        catch (SocketException ex) {
            LOGGER.log(Level.FINE, null, ex);
        }
        try {
            addresses.add(InetAddress.getLocalHost());
        }
        catch (UnknownHostException ex) {
            LOGGER.log(Level.FINE, null, ex);
        }
        TreeSet<String> ret = new TreeSet<String>();
        for (InetAddress addr : addresses) {
            String host = addr.getHostAddress();
            if (addr instanceof Inet6Address) {
                int index = host.indexOf(37);
                if (index > 0) {
                    host = host.substring(0, index);
                }
                host = host.replaceFirst("(^|:)(0+(:|$)){2,8}", "::").replaceAll("(:|^)0+([0-9A-Fa-f])", "$1$2");
            }
            ret.add(host);
        }
        return ret;
    }

    public static Comparator<DockerInstance> getInstanceComparator() {
        return INSTANCE_COMPARATOR;
    }

    public static void loadRepositories(final DockerInstance instance, final JComboBox<String> combo) {
        assert (SwingUtilities.isEventDispatchThread());
        if (!(combo.getEditor().getEditorComponent() instanceof JTextComponent)) {
            return;
        }
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                DockerAction facade = new DockerAction(instance);
                List images = facade.getImages();
                final TreeSet<String> repositories = new TreeSet<String>();
                for (DockerImage image : images) {
                    for (DockerTag tag : image.getTags()) {
                        int index = tag.getTag().lastIndexOf(58);
                        if (index <= 0) continue;
                        repositories.add(tag.getTag().substring(0, index));
                    }
                }
                SwingUtilities.invokeLater(new Runnable(){
                    final /* synthetic */ 2 this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void run() {
                        if (UiUtils.getValue(combo) == null) {
                            int i = 0;
                            for (String repo : repositories) {
                                combo.insertItemAt(repo, i++);
                            }
                        }
                    }
                });
            }
        });
    }

    public static String normalizePath(String path) {
        if (path == null) {
            return null;
        }
        return path.replace('\\', '/');
    }
}

