/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.TruffleStackTraceElement;
import com.oracle.truffle.api.nodes.LanguageInfo;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.polyglot.EngineAccessor;
import com.oracle.truffle.polyglot.PolyglotEngineImpl;
import com.oracle.truffle.polyglot.PolyglotExceptionImpl;
import com.oracle.truffle.polyglot.PolyglotLanguage;
import org.graalvm.polyglot.impl.AbstractPolyglotImpl;

final class PolyglotExceptionFrame
extends AbstractPolyglotImpl.AbstractStackFrameImpl {
    final PolyglotLanguage language;
    private final Object sourceLocation;
    private final String rootName;
    private final boolean host;
    private StackTraceElement stackTrace;
    private final String formattedSource;

    private PolyglotExceptionFrame(PolyglotExceptionImpl source, PolyglotLanguage language, Object sourceLocation, String rootName, boolean isHost, StackTraceElement stackTrace) {
        super((AbstractPolyglotImpl)source.polyglot);
        this.language = language;
        this.sourceLocation = sourceLocation;
        this.rootName = rootName;
        this.host = isHost;
        this.stackTrace = stackTrace;
        if (!isHost) {
            SourceSection sourceSection = sourceLocation != null ? (SourceSection)source.polyglot.getAPIAccess().getSourceSectionReceiver(sourceLocation) : null;
            this.formattedSource = PolyglotExceptionFrame.formatSource(sourceSection, language != null ? source.getFileSystemContext(language) : null);
        } else {
            this.formattedSource = null;
        }
    }

    public Object getSourceLocation() {
        return this.sourceLocation;
    }

    public Object getLanguage() {
        return this.language.api;
    }

    public String getRootName() {
        return this.rootName;
    }

    public boolean isHostFrame() {
        return this.host;
    }

    public StackTraceElement toHostFrame() {
        if (this.stackTrace == null) {
            Object declaringClass = this.language != null ? "<" + this.language.getId() + ">" : "";
            String methodName = this.rootName == null ? "" : this.rootName;
            SourceSection sourceSection = this.sourceLocation != null ? (SourceSection)this.language.getAPIAccess().getSourceSectionReceiver(this.sourceLocation) : null;
            String fileName = sourceSection != null ? sourceSection.getSource().getName() : "Unknown";
            int startLine = sourceSection != null ? sourceSection.getStartLine() : -1;
            this.stackTrace = new StackTraceElement((String)declaringClass, methodName, fileName, startLine);
        }
        return this.stackTrace;
    }

    public String toStringImpl(int langColumn) {
        StringBuilder b = new StringBuilder();
        if (this.isHostFrame()) {
            String languageId = "";
        } else {
            String languageId = this.language.getId();
            b.append(PolyglotExceptionFrame.spaces(Math.max(langColumn, languageId.length()) - languageId.length())).append("<").append(languageId).append("> ");
        }
        if (this.isHostFrame()) {
            b.append(this.stackTrace.toString());
        } else {
            b.append(this.rootName);
            b.append("(");
            assert (this.formattedSource != null);
            b.append(this.formattedSource);
            b.append(")");
        }
        return b.toString();
    }

    static PolyglotExceptionFrame createGuest(PolyglotExceptionImpl exception, TruffleStackTraceElement frame, boolean first) {
        if (frame == null) {
            return null;
        }
        RootNode targetRoot = frame.getTarget().getRootNode();
        if (targetRoot.isInternal() && !exception.showInternalStackFrames) {
            return null;
        }
        LanguageInfo info = targetRoot.getLanguageInfo();
        if (info == null) {
            return null;
        }
        PolyglotEngineImpl engine = exception.engine;
        PolyglotLanguage language = null;
        Object location = null;
        String rootName = targetRoot.getName();
        if (engine != null) {
            language = engine.idToLanguage.get(info.getId());
            Node callNode = frame.getLocation();
            if (callNode != null) {
                SourceSection section = callNode.getEncapsulatingSourceSection();
                if (section != null) {
                    Object source = engine.getAPIAccess().newSource(exception.polyglot.getSourceDispatch(), (Object)section.getSource());
                    location = engine.getAPIAccess().newSourceSection(source, exception.polyglot.getSourceSectionDispatch(), (Object)section);
                } else {
                    location = null;
                }
            } else {
                location = first ? exception.getSourceLocation() : null;
            }
        }
        return new PolyglotExceptionFrame(exception, language, location, rootName, false, null);
    }

    static PolyglotExceptionFrame createHost(PolyglotExceptionImpl exception, StackTraceElement hostStack) {
        PolyglotLanguage language = exception.engine != null ? exception.engine.hostLanguage : null;
        Object location = null;
        String rootname = hostStack.getClassName() + "." + hostStack.getMethodName();
        return new PolyglotExceptionFrame(exception, language, location, rootname, true, hostStack);
    }

    private static String spaces(int length) {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            b.append(' ');
        }
        return b.toString();
    }

    private static String formatSource(SourceSection sourceSection, Object fileSystemContext) {
        if (sourceSection == null) {
            return "Unknown";
        }
        Source source = sourceSection.getSource();
        if (source == null) {
            return "Unknown";
        }
        StringBuilder b = new StringBuilder();
        String path = source.getPath();
        if (path == null) {
            b.append(source.getName());
        } else if (fileSystemContext != null) {
            try {
                TruffleFile pathAbsolute = EngineAccessor.LANGUAGE.getTruffleFile(path, fileSystemContext);
                TruffleFile pathBase = EngineAccessor.LANGUAGE.getTruffleFile("", fileSystemContext).getAbsoluteFile();
                TruffleFile pathRelative = pathBase.relativize(pathAbsolute);
                b.append(pathRelative.getPath());
            }
            catch (IllegalArgumentException | SecurityException | UnsupportedOperationException e) {
                b.append(path);
            }
        } else {
            b.append(path);
        }
        b.append(":").append(PolyglotExceptionFrame.formatIndices(sourceSection, true));
        return b.toString();
    }

    private static String formatIndices(SourceSection sourceSection, boolean needsColumnSpecifier) {
        boolean singleLine;
        StringBuilder b = new StringBuilder();
        boolean bl = singleLine = sourceSection.getStartLine() == sourceSection.getEndLine();
        if (singleLine) {
            b.append(sourceSection.getStartLine());
        } else {
            b.append(sourceSection.getStartLine()).append("-").append(sourceSection.getEndLine());
        }
        if (needsColumnSpecifier) {
            b.append(":");
            if (sourceSection.getCharLength() <= 1) {
                b.append(sourceSection.getCharIndex());
            } else {
                b.append(sourceSection.getCharIndex()).append("-").append(sourceSection.getCharIndex() + sourceSection.getCharLength() - 1);
            }
        }
        return b.toString();
    }
}

