/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.html.ko4j;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.List;
import net.java.html.json.Models;
import org.netbeans.html.context.spi.Contexts;
import org.netbeans.html.json.spi.JSONCall;
import org.netbeans.html.json.spi.Transfer;
import org.netbeans.html.ko4j.LoadJSON;

@Contexts.Id(value={"xhr"})
final class KOTransfer
implements Transfer {
    KOTransfer() {
    }

    public void extract(Object obj, String[] props, Object[] values) {
        if (obj instanceof JSObjToStr) {
            JSObjToStr str = (JSObjToStr)obj;
            obj = str.obj;
        }
        LoadJSON.extractJSON(obj, props, values);
    }

    public void loadJSON(JSONCall call) {
        if (call.isJSONP()) {
            String me = LoadJSON.createJSONP(call);
            LoadJSON.loadJSONP(call.composeURL(me), me);
        } else {
            String data = null;
            if (call.isDoOutput()) {
                try {
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    call.writeData((OutputStream)bos);
                    data = new String(bos.toByteArray(), "UTF-8");
                }
                catch (IOException ex) {
                    call.notifyError((Throwable)ex);
                }
            }
            List headerPairs = Models.asList((Object[])new String[0]);
            String h = call.getHeaders();
            if (h != null) {
                int tagEnd;
                int pos = 0;
                while (pos < h.length() && (tagEnd = h.indexOf(58, pos)) != -1) {
                    int r = h.indexOf(13, tagEnd);
                    int n = h.indexOf(10, tagEnd);
                    if (r == -1) {
                        r = h.length();
                    }
                    if (n == -1) {
                        n = h.length();
                    }
                    headerPairs.add(h.substring(pos, tagEnd).trim());
                    headerPairs.add(h.substring(tagEnd + 1, Math.min(r, n)).trim());
                    pos = Math.max(r, n);
                }
            }
            LoadJSON.loadJSON(call.composeURL(null), call, call.getMethod(), data, headerPairs.toArray());
        }
    }

    public Object toJSON(InputStream is) throws IOException {
        int ch;
        StringBuilder sb = new StringBuilder();
        InputStreamReader r = new InputStreamReader(is, "UTF-8");
        while ((ch = r.read()) != -1) {
            sb.append((char)ch);
        }
        return LoadJSON.parse(sb.toString());
    }

    static void notifySuccess(Object done, Object str, Object data) {
        Object[] notifyObj;
        if (data instanceof Object[]) {
            Object[] arr = (Object[])data;
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = new JSObjToStr(str, arr[i]);
            }
            notifyObj = arr;
        } else {
            notifyObj = new JSObjToStr(str, data);
        }
        ((JSONCall)done).notifySuccess((Object)notifyObj);
    }

    static void notifyError(Object done, Object msg) {
        ((JSONCall)done).notifyError((Throwable)new Exception(msg.toString()));
    }

    private static final class JSObjToStr {
        final String str;
        final Object obj;

        public JSObjToStr(Object str, Object obj) {
            this.str = str == null ? "" : str.toString();
            this.obj = obj;
        }

        public String toString() {
            return this.str;
        }
    }
}

