/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.js.parser.ir;

import com.oracle.js.parser.Source;
import com.oracle.js.parser.ir.Block;
import com.oracle.js.parser.ir.BreakableNode;
import com.oracle.js.parser.ir.Flags;
import com.oracle.js.parser.ir.FunctionNode;
import com.oracle.js.parser.ir.LabelNode;
import com.oracle.js.parser.ir.LexicalContextNode;
import com.oracle.js.parser.ir.LoopNode;
import com.oracle.js.parser.ir.SwitchNode;
import java.io.File;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class LexicalContext {
    private LexicalContextNode[] stack = new LexicalContextNode[16];
    private int[] flags = new int[16];
    private int sp;

    public int getFlags(LexicalContextNode node) {
        for (int i = this.sp - 1; i >= 0; --i) {
            if (this.stack[i] != node) continue;
            return this.flags[i];
        }
        throw new AssertionError((Object)"flag node not on context stack");
    }

    public Block getFunctionBody(FunctionNode functionNode) {
        for (int i = this.sp - 1; i >= 0; --i) {
            if (this.stack[i] != functionNode) continue;
            return (Block)this.stack[i + 1];
        }
        throw new AssertionError((Object)(functionNode.getName() + " not on context stack"));
    }

    public Iterator<LexicalContextNode> getAllNodes() {
        return new NodeIterator<LexicalContextNode>(LexicalContextNode.class);
    }

    public FunctionNode getOutermostFunction() {
        return (FunctionNode)this.stack[0];
    }

    public <T extends LexicalContextNode> T push(T node) {
        assert (!this.contains(node));
        if (this.sp == this.stack.length) {
            LexicalContextNode[] newStack = new LexicalContextNode[this.sp * 2];
            System.arraycopy(this.stack, 0, newStack, 0, this.sp);
            this.stack = newStack;
            int[] newFlags = new int[this.sp * 2];
            System.arraycopy(this.flags, 0, newFlags, 0, this.sp);
            this.flags = newFlags;
        }
        this.stack[this.sp] = node;
        this.flags[this.sp] = 0;
        ++this.sp;
        return node;
    }

    public boolean isEmpty() {
        return this.sp == 0;
    }

    public int size() {
        return this.sp;
    }

    public <T extends LexicalContextNode> T pop(T node) {
        --this.sp;
        LexicalContextNode popped = this.stack[this.sp];
        this.stack[this.sp] = null;
        if (popped instanceof Flags) {
            return ((Flags)((Object)popped)).setFlag(this, this.flags[this.sp]);
        }
        return (T)popped;
    }

    public LexicalContextNode peek() {
        return this.stack[this.sp - 1];
    }

    public boolean contains(LexicalContextNode node) {
        for (int i = 0; i < this.sp; ++i) {
            if (this.stack[i] != node) continue;
            return true;
        }
        return false;
    }

    public LexicalContextNode replace(LexicalContextNode oldNode, LexicalContextNode newNode) {
        for (int i = this.sp - 1; i >= 0; --i) {
            if (this.stack[i] != oldNode) continue;
            assert (i == this.sp - 1) : "violation of contract - we always expect to find the replacement node on top of the lexical context stack: " + newNode + " has " + this.stack[i + 1].getClass() + " above it";
            this.stack[i] = newNode;
            break;
        }
        return newNode;
    }

    public Iterator<Block> getBlocks() {
        return new NodeIterator<Block>(Block.class);
    }

    public Iterator<FunctionNode> getFunctions() {
        return new NodeIterator<FunctionNode>(FunctionNode.class);
    }

    public Block getParentBlock() {
        NodeIterator<Block> iter = new NodeIterator<Block>(Block.class, this.getCurrentFunction());
        iter.next();
        return iter.hasNext() ? (Block)iter.next() : null;
    }

    public LabelNode getCurrentBlockLabelNode() {
        assert (this.stack[this.sp - 1] instanceof Block);
        if (this.sp < 2) {
            return null;
        }
        LexicalContextNode parent = this.stack[this.sp - 2];
        return parent instanceof LabelNode ? (LabelNode)parent : null;
    }

    public Iterator<Block> getAncestorBlocks(Block block) {
        Iterator<Block> iter = this.getBlocks();
        while (iter.hasNext()) {
            Block b = iter.next();
            if (block != b) continue;
            return iter;
        }
        throw new AssertionError((Object)"Block is not on the current lexical context stack");
    }

    public Iterator<Block> getBlocks(final Block block) {
        final Iterator<Block> iter = this.getAncestorBlocks(block);
        return new Iterator<Block>(){
            boolean blockReturned = false;
            final /* synthetic */ LexicalContext this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public boolean hasNext() {
                return iter.hasNext() || !this.blockReturned;
            }

            @Override
            public Block next() {
                if (this.blockReturned) {
                    return (Block)iter.next();
                }
                this.blockReturned = true;
                return block;
            }
        };
    }

    public FunctionNode getFunction(Block block) {
        NodeIterator<LexicalContextNode> iter = new NodeIterator<LexicalContextNode>(LexicalContextNode.class);
        while (iter.hasNext()) {
            LexicalContextNode next = (LexicalContextNode)iter.next();
            if (next != block) continue;
            while (iter.hasNext()) {
                LexicalContextNode next2 = (LexicalContextNode)iter.next();
                if (!(next2 instanceof FunctionNode)) continue;
                return (FunctionNode)next2;
            }
        }
        assert (false);
        return null;
    }

    public Block getCurrentBlock() {
        return this.getBlocks().next();
    }

    public FunctionNode getCurrentFunction() {
        for (int i = this.sp - 1; i >= 0; --i) {
            if (!(this.stack[i] instanceof FunctionNode)) continue;
            return (FunctionNode)this.stack[i];
        }
        return null;
    }

    public boolean isFunctionBody() {
        return this.getParentBlock() == null;
    }

    public FunctionNode getParentFunction(FunctionNode functionNode) {
        NodeIterator<FunctionNode> iter = new NodeIterator<FunctionNode>(FunctionNode.class);
        while (iter.hasNext()) {
            FunctionNode next = (FunctionNode)iter.next();
            if (next != functionNode) continue;
            return iter.hasNext() ? (FunctionNode)iter.next() : null;
        }
        assert (false);
        return null;
    }

    private BreakableNode getBreakable() {
        NodeIterator<BreakableNode> iter = new NodeIterator<BreakableNode>(BreakableNode.class, this.getCurrentFunction());
        while (iter.hasNext()) {
            BreakableNode next = (BreakableNode)iter.next();
            if (!next.isBreakableWithoutLabel()) continue;
            return next;
        }
        return null;
    }

    public boolean inLoop() {
        return this.getCurrentLoop() != null;
    }

    public LoopNode getCurrentLoop() {
        NodeIterator<LoopNode> iter = new NodeIterator<LoopNode>(LoopNode.class, this.getCurrentFunction());
        return iter.hasNext() ? (LoopNode)iter.next() : null;
    }

    public BreakableNode getBreakable(String labelName) {
        if (labelName != null) {
            LabelNode foundLabel = this.findLabel(labelName);
            if (foundLabel != null) {
                BreakableNode breakable = null;
                NodeIterator<BreakableNode> iter = new NodeIterator<BreakableNode>(BreakableNode.class, foundLabel);
                while (iter.hasNext()) {
                    breakable = (BreakableNode)iter.next();
                }
                return breakable;
            }
            return null;
        }
        return this.getBreakable();
    }

    private LoopNode getContinueTo() {
        return this.getCurrentLoop();
    }

    public LoopNode getContinueTo(String labelName) {
        if (labelName != null) {
            LabelNode foundLabel = this.findLabel(labelName);
            if (foundLabel != null) {
                LoopNode loop = null;
                NodeIterator<LoopNode> iter = new NodeIterator<LoopNode>(LoopNode.class, foundLabel);
                while (iter.hasNext()) {
                    loop = (LoopNode)iter.next();
                }
                return loop;
            }
            return null;
        }
        return this.getContinueTo();
    }

    public LabelNode findLabel(String name) {
        NodeIterator<LabelNode> iter = new NodeIterator<LabelNode>(LabelNode.class, this.getCurrentFunction());
        while (iter.hasNext()) {
            LabelNode next = (LabelNode)iter.next();
            if (!next.getLabelName().equals(name)) continue;
            return next;
        }
        return null;
    }

    public boolean inUnprotectedSwitchContext() {
        LexicalContextNode next;
        for (int i = this.sp - 1; i > 0 && !((next = this.stack[i]) instanceof Block); --i) {
            if (!(next instanceof SwitchNode)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[ ");
        for (int i = 0; i < this.sp; ++i) {
            LexicalContextNode node = this.stack[i];
            sb.append(node.getClass().getSimpleName());
            sb.append('@');
            sb.append(LexicalContext.id(node));
            sb.append(':');
            if (node instanceof FunctionNode) {
                FunctionNode fn = (FunctionNode)node;
                Source source = fn.getSource();
                String src = source.toString();
                if (src.contains(File.pathSeparator)) {
                    src = src.substring(src.lastIndexOf(File.pathSeparator));
                }
                sb.append(src);
                sb.append(' ');
                sb.append(fn.getLineNumber());
            }
            sb.append(' ');
        }
        sb.append(" ==> ]");
        return sb.toString();
    }

    private static String id(Object x) {
        return String.format("0x%08x", System.identityHashCode(x));
    }

    private class NodeIterator<T extends LexicalContextNode>
    implements Iterator<T> {
        private int index;
        private T next;
        private final Class<T> clazz;
        private LexicalContextNode until;

        NodeIterator(Class<T> clazz) {
            this(clazz, null);
        }

        NodeIterator(Class<T> clazz, LexicalContextNode until) {
            this.index = LexicalContext.this.sp - 1;
            this.clazz = clazz;
            this.until = until;
            this.next = this.findNext();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public T next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            T lnext = this.next;
            this.next = this.findNext();
            return lnext;
        }

        private T findNext() {
            for (int i = this.index; i >= 0; --i) {
                LexicalContextNode node = LexicalContext.this.stack[i];
                if (node == this.until) {
                    return null;
                }
                if (!this.clazz.isAssignableFrom(node.getClass())) continue;
                this.index = i - 1;
                return (T)node;
            }
            return null;
        }
    }
}

