/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.common.actions;

import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.glassfish.common.SimpleIO;
import org.netbeans.modules.glassfish.spi.GlassfishModule;
import org.netbeans.modules.glassfish.spi.Utils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.execution.NbProcessDescriptor;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.actions.NodeAction;

public class ViewUpdateCenterAction
extends NodeAction {
    private static final String SHOW_UPDATE_CENTER_ICONBASE = "org/netbeans/modules/glassfish/common/resources/UpdateCenter.gif";
    private static final WeakHashMap<String, Process> taskMap = new WeakHashMap();
    private boolean needToBeAdmin = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performAction(Node[] nodes) {
        GlassfishModule commonSupport;
        if (this.needToBeAdmin) {
            this.displayAdminWarning();
        }
        if ((commonSupport = (GlassfishModule)nodes[0].getLookup().lookup(GlassfishModule.class)) != null) {
            Map<String, String> ip = commonSupport.getInstanceProperties();
            final String serverUrl = ip.get("url");
            final String serverName = ip.get("displayName");
            Process p = null;
            WeakHashMap<String, Process> weakHashMap = taskMap;
            synchronized (weakHashMap) {
                p = taskMap.get(serverUrl);
            }
            if (p != null) {
                String message = NbBundle.getMessage(ViewUpdateCenterAction.class, (String)"MSG_UpdateCenterDownloading", (Object)serverName);
                NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)message, -1, 1);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                return;
            }
            String installRoot = ip.get("installfolder");
            final File installDir = new File(installRoot);
            final File launcher = this.getUpdateCenterLauncher(installDir);
            if (launcher != null) {
                RequestProcessor.getDefault().post(new Runnable(){
                    final /* synthetic */ ViewUpdateCenterAction this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void run() {
                        try {
                            File realLauncher = launcher;
                            if (!this.this$0.isUCInstalled(installDir)) {
                                realLauncher = this.this$0.installUpdateCenter(serverName, serverUrl, installDir, launcher) ? this.this$0.getUpdateCenterLauncher(installDir) : null;
                            }
                            if (realLauncher != null) {
                                new NbProcessDescriptor(realLauncher.getPath(), "").exec(null, null, realLauncher.getParentFile());
                            }
                            String path = commonSupport.getInstanceProperties().get("homefolder");
                            File f = new File(path, "modules");
                            FileUtil.toFileObject((File)FileUtil.normalizeFile((File)f)).refresh();
                        }
                        catch (IOException ioe) {
                            if (!this.this$0.needToBeAdmin) {
                                this.this$0.needToBeAdmin = true;
                                this.this$0.displayAdminWarning();
                            }
                            Logger.getLogger("glassfish").log(Level.INFO, "Cannot start Domain Update Center", ioe);
                        }
                        catch (Exception ex) {
                            Logger.getLogger("glassfish").log(Level.WARNING, ex.getLocalizedMessage(), ex);
                        }
                    }
                });
            } else {
                String message = NbBundle.getMessage(ViewUpdateCenterAction.class, (String)"MSG_UpdateCenterNotFound", (Object)serverName);
                NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)message, -1, 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
            }
        }
    }

    private File getUpdateCenterLauncher(File installRoot) {
        File updateCenterBin;
        File result = null;
        if (installRoot != null && installRoot.exists() && (updateCenterBin = new File(installRoot, "bin")).exists()) {
            File launcherPath;
            result = Utilities.isWindows() ? ((launcherPath = new File(updateCenterBin, "updatetool.exe")).exists() ? launcherPath : ((launcherPath = new File(updateCenterBin, "updatetool.bat")).exists() ? launcherPath : null)) : ((launcherPath = new File(updateCenterBin, "updatetool")).exists() ? launcherPath : null);
        }
        return result;
    }

    private boolean isUCInstalled(File installRoot) {
        return new File(installRoot, "updatetool/bin").exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean installUpdateCenter(String serverName, String serverUrl, File installRoot, File launcher) {
        if (!Utils.canWrite(installRoot)) {
            String message = NbBundle.getMessage(ViewUpdateCenterAction.class, (String)"MSG_UpdateCenterNoPermission", (Object)serverName, (Object)installRoot);
            NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)message, -1, 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
            return false;
        }
        String message = NbBundle.getMessage(ViewUpdateCenterAction.class, (String)"MSG_QueryInstallUpdateCenter", (Object)serverName);
        NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)message, 0, 3);
        boolean result = false;
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)nd) == NotifyDescriptor.YES_OPTION) {
            PrintWriter writer = null;
            try {
                Process process = new NbProcessDescriptor(launcher.getPath(), "").exec(null, null, launcher.getParentFile());
                WeakHashMap<String, Process> weakHashMap = taskMap;
                synchronized (weakHashMap) {
                    taskMap.put(serverUrl, process);
                }
                SimpleIO ucIO = new SimpleIO("Update Center Installer", process);
                ucIO.readInputStreams(process.getInputStream(), process.getErrorStream());
                writer = new PrintWriter((Writer)new OutputStreamWriter(process.getOutputStream()), true);
                writer.println("y");
                this.writeProxyInfo(writer);
                int exitCode = process.waitFor();
                Logger.getLogger("glassfish").log(Level.FINEST, "UC exit code = " + exitCode);
                if (exitCode == 0) {
                    writer.close();
                    writer = null;
                    ucIO.closeIO();
                    result = true;
                }
            }
            catch (InterruptedException ex) {
                Logger.getLogger("glassfish").log(Level.WARNING, ex.getLocalizedMessage(), ex);
            }
            catch (IOException ex) {
                Logger.getLogger("glassfish").log(Level.WARNING, ex.getLocalizedMessage(), ex);
            }
            finally {
                WeakHashMap<String, Process> ex = taskMap;
                synchronized (ex) {
                    taskMap.remove(serverUrl);
                }
                if (writer != null) {
                    writer.close();
                }
            }
        }
        return result;
    }

    protected boolean enable(Node[] nodes) {
        GlassfishModule commonSupport;
        if (nodes != null && nodes.length == 1 && nodes[0] != null && (commonSupport = (GlassfishModule)nodes[0].getLookup().lookup(GlassfishModule.class)) != null) {
            String installRoot = commonSupport.getInstanceProperties().get("installfolder");
            return installRoot != null && null != commonSupport.getInstanceProperties().get("domainsfolder");
        }
        return false;
    }

    protected boolean asynchronous() {
        return false;
    }

    public String getName() {
        return NbBundle.getMessage(ViewUpdateCenterAction.class, (String)"CTL_ViewUpdateCenterAction");
    }

    protected String iconResource() {
        return SHOW_UPDATE_CENTER_ICONBASE;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    private void writeProxyInfo(PrintWriter writer) throws IOException {
        writer.println("n");
    }

    private void displayAdminWarning() {
        String mess = NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"WARN_ELEVATE");
        Logger.getLogger("glassfish").warning(mess);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)mess, 2));
    }
}

