/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.common.nodes;

import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.glassfish.spi.Decorator;
import org.netbeans.modules.glassfish.spi.DecoratorFactory;
import org.openide.util.lookup.Lookups;

public final class DecoratorManager {
    private static volatile Map<String, Decorator> decoratorMap;

    private DecoratorManager() {
    }

    private static synchronized void initDecorators() {
        if (decoratorMap != null) {
            return;
        }
        decoratorMap = new HashMap<String, Decorator>();
        for (DecoratorFactory decoratorFactory : Lookups.forPath((String)"Servers/GlassFish").lookupAll(DecoratorFactory.class)) {
            Map<String, Decorator> map = decoratorFactory.getAllDecorators();
            decoratorMap.putAll(map);
        }
    }

    public static Decorator findDecorator(String type, Decorator defaultDecorator, boolean enabled) {
        Decorator d;
        if (decoratorMap == null) {
            DecoratorManager.initDecorators();
        }
        if (!enabled) {
            type = "disabled " + (String)type;
        }
        return (d = decoratorMap.get(type)) != null ? d : defaultDecorator;
    }
}

