/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.beans.impl.model;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.AnnotationModelHelper;
import org.netbeans.modules.web.beans.api.model.BeansModel;
import org.netbeans.modules.web.beans.api.model.CdiException;
import org.netbeans.modules.web.beans.api.model.DependencyInjectionResult;
import org.netbeans.modules.web.beans.impl.model.AnnotationObjectProvider;
import org.netbeans.modules.web.beans.impl.model.PackagingFilter;
import org.netbeans.modules.web.beans.impl.model.ParameterInjectionPointLogic;
import org.netbeans.modules.web.beans.impl.model.WebBeansModelImplementation;
import org.netbeans.modules.web.beans.impl.model.results.ErrorImpl;
import org.netbeans.modules.web.beans.impl.model.results.InjectableResultImpl;
import org.netbeans.modules.web.beans.impl.model.results.InjectablesResultImpl;
import org.netbeans.modules.web.beans.impl.model.results.ResolutionErrorImpl;
import org.netbeans.modules.web.beans.impl.model.results.ResultImpl;
import org.openide.util.NbBundle;

class EnableBeansFilter {
    private static final String EXTENSION = "javax.enterprise.inject.spi.Extension";
    private static final String EXTENSION_JAKARTA = "jakarta.enterprise.inject.spi.Extension";
    private final HashSet<String> predefinedBeans = new HashSet();
    private final HashMap<String, String> predefinedBeanAnnotationPairs;
    private Set<Element> myAlternatives;
    private Set<Element> myEnabledAlternatives;
    private ResultImpl myResult;
    private final AnnotationModelHelper myHelper;
    private final BeansModel myBeansModel;
    private WebBeansModelImplementation myModel;
    private boolean isProgrammatic;

    EnableBeansFilter(ResultImpl result, WebBeansModelImplementation model, boolean programmatic) {
        this.predefinedBeans.add("javax.enterprise.event.Event");
        this.predefinedBeans.add("javax.servlet.http.HttpServletRequest");
        this.predefinedBeans.add("javax.servlet.http.HttpSession");
        this.predefinedBeans.add("javax.servlet.ServletContext");
        this.predefinedBeans.add("javax.jms.JMSContext");
        this.predefinedBeans.add("javax.enterprise.inject.spi.InjectionPoint");
        this.predefinedBeans.add("javax.enterprise.inject.spi.BeanManager");
        this.predefinedBeans.add("javax.transaction.UserTransaction");
        this.predefinedBeans.add("java.security.Principal");
        this.predefinedBeans.add("javax.validation.ValidatorFactory");
        this.predefinedBeans.add("javax.faces.application.Application");
        this.predefinedBeans.add("javax.faces.annotation.ApplicationMap");
        this.predefinedBeans.add("javax.faces.annotation.FlowMap");
        this.predefinedBeans.add("javax.faces.annotation.HeaderMap");
        this.predefinedBeans.add("javax.faces.annotation.HeaderValuesMap");
        this.predefinedBeans.add("javax.faces.annotation.InitParameterMap");
        this.predefinedBeans.add("javax.faces.annotation.ManagedProperty");
        this.predefinedBeans.add("javax.faces.annotation.RequestCookieMap");
        this.predefinedBeans.add("javax.faces.annotation.RequestMap");
        this.predefinedBeans.add("javax.faces.annotation.RequestParameterMap");
        this.predefinedBeans.add("javax.faces.annotation.RequestParameterValuesMap");
        this.predefinedBeans.add("javax.faces.annotation.SessionMap");
        this.predefinedBeans.add("javax.faces.annotation.ViewMap");
        this.predefinedBeans.add("javax.faces.context.ExternalContext");
        this.predefinedBeans.add("javax.faces.context.FacesContext");
        this.predefinedBeans.add("jakarta.enterprise.event.Event");
        this.predefinedBeans.add("jakarta.servlet.http.HttpServletRequest");
        this.predefinedBeans.add("jakarta.servlet.http.HttpSession");
        this.predefinedBeans.add("jakarta.servlet.ServletContext");
        this.predefinedBeans.add("jakarta.jms.JMSContext");
        this.predefinedBeans.add("jakarta.enterprise.inject.spi.InjectionPoint");
        this.predefinedBeans.add("jakarta.enterprise.inject.spi.BeanManager");
        this.predefinedBeans.add("jakarta.transaction.UserTransaction");
        this.predefinedBeans.add("java.security.Principal");
        this.predefinedBeans.add("jakarta.validation.ValidatorFactory");
        this.predefinedBeans.add("jakarta.faces.application.Application");
        this.predefinedBeans.add("jakarta.faces.annotation.ApplicationMap");
        this.predefinedBeans.add("jakarta.faces.annotation.FlowMap");
        this.predefinedBeans.add("jakarta.faces.annotation.HeaderMap");
        this.predefinedBeans.add("jakarta.faces.annotation.HeaderValuesMap");
        this.predefinedBeans.add("jakarta.faces.annotation.InitParameterMap");
        this.predefinedBeans.add("jakarta.faces.annotation.ManagedProperty");
        this.predefinedBeans.add("jakarta.faces.annotation.RequestCookieMap");
        this.predefinedBeans.add("jakarta.faces.annotation.RequestMap");
        this.predefinedBeans.add("jakarta.faces.annotation.RequestParameterMap");
        this.predefinedBeans.add("jakarta.faces.annotation.RequestParameterValuesMap");
        this.predefinedBeans.add("jakarta.faces.annotation.SessionMap");
        this.predefinedBeans.add("jakarta.faces.annotation.ViewMap");
        this.predefinedBeans.add("jakarta.faces.context.ExternalContext");
        this.predefinedBeans.add("jakarta.faces.context.FacesContext");
        this.predefinedBeanAnnotationPairs = new HashMap();
        this.predefinedBeanAnnotationPairs.put("javax.faces.flow.builder.FlowBuilder", "javax.faces.flow.builder.FlowBuilderParameter");
        this.predefinedBeanAnnotationPairs.put("jakarta.faces.flow.builder.FlowBuilder", "jakarta.faces.flow.builder.FlowBuilderParameter");
        this.myResult = result;
        this.myHelper = model.getHelper();
        this.myBeansModel = model.getBeansModel();
        this.myModel = model;
        this.isProgrammatic = programmatic;
    }

    DependencyInjectionResult filter(AtomicBoolean cancel) {
        boolean hasSingleAlternative;
        this.myAlternatives = new HashSet<Element>();
        this.myEnabledAlternatives = new HashSet<Element>();
        PackagingFilter filter = new PackagingFilter(this.getWebBeansModel());
        Set<TypeElement> typeElements = this.getResult().getTypeElements();
        TypeElement firstElement = typeElements.size() > 0 ? typeElements.iterator().next() : null;
        filter.filter(typeElements, cancel);
        for (TypeElement typeElement : typeElements) {
            if (!this.getResult().isAlternative(typeElement)) continue;
            this.myAlternatives.add(typeElement);
            this.addEnabledAlternative(typeElement, typeElement);
        }
        Set<Element> productions = this.packagedFilterProductions();
        for (Element element : productions) {
            TypeElement enclosingTypeElement = this.myHelper.getCompilationController().getElementUtilities().enclosingTypeElement(element);
            if (!this.getResult().isAlternative(element)) continue;
            this.myAlternatives.add(element);
            this.addEnabledAlternative(enclosingTypeElement, element);
        }
        HashSet<Element> hashSet = new HashSet<Element>(typeElements);
        HashSet<Element> enabledProductions = new HashSet<Element>(productions);
        this.myAlternatives.removeAll(this.myEnabledAlternatives);
        enabledProductions.removeAll(this.myAlternatives);
        hashSet.removeAll(this.myAlternatives);
        int typesSize = hashSet.size();
        int productionsSize = enabledProductions.size();
        Set<Element> enabledTypes = this.findEnabledTypes(hashSet);
        this.findEnabledProductions(enabledProductions);
        int commonSize = enabledTypes.size() + enabledProductions.size();
        if (commonSize == 1) {
            Element injectable = enabledTypes.size() == 0 ? (Element)enabledProductions.iterator().next() : enabledTypes.iterator().next();
            enabledTypes.addAll(enabledProductions);
            return new InjectableResultImpl(this.getResult(), injectable, enabledTypes);
        }
        if (commonSize == 0) {
            InjectableResultImpl res;
            String nm = this.myResult.getVariableType().toString();
            if ((nm.startsWith("javax.") || nm.startsWith("java.")) && (res = this.handleEESpecificImplementations(this.getResult(), firstElement, enabledTypes)) != null) {
                return res;
            }
            if (typeElements.size() == 0 && productions.size() == 0) {
                return new ErrorImpl(this.getResult().getVariable(), this.getResult().getVariableType(), NbBundle.getMessage(EnableBeansFilter.class, (String)"ERR_NoFound"));
            }
            if (typesSize == 0 && productionsSize == 0) {
                return new ResolutionErrorImpl(this.getResult(), NbBundle.getMessage(EnableBeansFilter.class, (String)"ERR_AlternativesOnly"));
            }
            return new ResolutionErrorImpl(this.getResult(), NbBundle.getMessage(EnableBeansFilter.class, (String)"ERR_NoEnabledBeans"));
        }
        HashSet<Element> allElements = new HashSet<Element>(enabledTypes);
        allElements.addAll(enabledProductions);
        allElements.retainAll(this.myEnabledAlternatives);
        boolean bl = hasSingleAlternative = allElements.size() == 1;
        if (hasSingleAlternative) {
            enabledTypes.addAll(enabledProductions);
            return new InjectableResultImpl(this.getResult(), (Element)allElements.iterator().next(), enabledTypes);
        }
        enabledTypes.addAll(enabledProductions);
        if (this.isProgrammatic) {
            return new InjectablesResultImpl(this.getResult(), enabledTypes);
        }
        String message = NbBundle.getMessage(EnableBeansFilter.class, (String)"ERR_UnresolvedAmbiguousDependency");
        return new ResolutionErrorImpl(this.getResult(), message, enabledTypes);
    }

    private Set<Element> packagedFilterProductions() {
        return this.getResult().getProductions();
    }

    private void findEnabledProductions(Set<Element> productions) {
        Iterator<Element> iterator = productions.iterator();
        while (iterator.hasNext()) {
            Element element = iterator.next();
            TypeElement enclosingTypeElement = this.getHelper().getCompilationController().getElementUtilities().enclosingTypeElement(element);
            if (!this.getResult().isAlternative(enclosingTypeElement)) continue;
            String name = enclosingTypeElement.getQualifiedName().toString();
            if (this.getResult().hasAlternative(enclosingTypeElement) && !this.getModel().getAlternativeClasses().contains(name)) {
                iterator.remove();
            }
            if (this.alternativeStereotypesEnabled(enclosingTypeElement)) continue;
            iterator.remove();
        }
    }

    private Set<Element> findEnabledTypes(Set<Element> elements) {
        LinkedList<Element> types = new LinkedList<Element>(elements);
        HashSet<Element> result = new HashSet<Element>(elements);
        while (types.size() != 0) {
            TypeElement typeElement = (TypeElement)types.remove();
            if (!this.checkClass(typeElement)) {
                result.remove(typeElement);
                continue;
            }
            this.checkProxyability(typeElement, types, result);
            this.checkSpecializes(typeElement, types, result, elements);
        }
        return result;
    }

    private boolean checkClass(TypeElement element) {
        List<ExecutableElement> constructors;
        if (element.getKind() != ElementKind.CLASS) {
            return false;
        }
        Set<Modifier> modifiers = element.getModifiers();
        Element enclosing = element.getEnclosingElement();
        if (!(enclosing instanceof PackageElement) && !modifiers.contains((Object)Modifier.STATIC)) {
            return false;
        }
        Elements elements = this.getHelper().getCompilationController().getElements();
        Types types = this.getHelper().getCompilationController().getTypes();
        List<? extends AnnotationMirror> allAnnotations = elements.getAllAnnotationMirrors(element);
        if (modifiers.contains((Object)Modifier.ABSTRACT) && !this.getHelper().hasAnnotation(allAnnotations, "javax.decorator.Decorator") && !this.getHelper().hasAnnotation(allAnnotations, "jakarta.decorator.Decorator")) {
            return false;
        }
        TypeElement extensionElement = elements.getTypeElement(EXTENSION_JAKARTA);
        if (extensionElement == null) {
            extensionElement = elements.getTypeElement(EXTENSION);
        }
        if (extensionElement != null) {
            TypeMirror extensionType = extensionElement.asType();
            if (types.isAssignable(element.asType(), extensionType)) {
                return false;
            }
        }
        boolean foundCtor = (constructors = ElementFilter.constructorsIn(element.getEnclosedElements())).size() == 0;
        for (ExecutableElement ctor : constructors) {
            if (ctor.getParameters().size() == 0) {
                foundCtor = true;
                break;
            }
            if (!this.getHelper().hasAnnotation(allAnnotations, "javax.inject.Inject") && !this.getHelper().hasAnnotation(allAnnotations, "jakarta.inject.Inject")) continue;
            foundCtor = true;
            break;
        }
        return foundCtor;
    }

    private void checkProxyability(TypeElement typeElement, LinkedList<Element> types, Set<Element> elements) {
        try {
            String scope = ParameterInjectionPointLogic.getScope(typeElement, this.getWebBeansModel().getHelper());
            Elements elementsUtil = this.getHelper().getCompilationController().getElements();
            TypeElement scopeElement = elementsUtil.getTypeElement(scope);
            if (scopeElement == null || this.getHelper().hasAnnotation(elementsUtil.getAllAnnotationMirrors(scopeElement), "javax.inject.Scope") || this.getHelper().hasAnnotation(elementsUtil.getAllAnnotationMirrors(scopeElement), "jakarta.inject.Scope")) {
                return;
            }
        }
        catch (CdiException e) {
            types.remove(typeElement);
            elements.remove(typeElement);
            return;
        }
        if (this.hasModifier(typeElement, Modifier.FINAL)) {
            types.remove(typeElement);
            elements.remove(typeElement);
            return;
        }
        this.checkFinalMethods(typeElement, types, elements);
        List<ExecutableElement> constructors = ElementFilter.constructorsIn(typeElement.getEnclosedElements());
        boolean appropriateCtor = false;
        for (ExecutableElement constructor : constructors) {
            if (this.hasModifier(constructor, Modifier.PRIVATE) || constructor.getParameters().size() != 0) continue;
            appropriateCtor = true;
            break;
        }
        if (!appropriateCtor) {
            types.remove(typeElement);
            elements.remove(typeElement);
        }
    }

    private void checkFinalMethods(TypeElement typeElement, LinkedList<Element> types, Set<Element> elements) {
        TypeMirror variableType = this.getResult().getVariableType();
        DeclaredType beanType = this.getDeclaredType(variableType);
        if (beanType == null) {
            return;
        }
        Element beanElement = beanType.asElement();
        if (!(beanElement instanceof TypeElement)) {
            return;
        }
        List<ExecutableElement> methods = ElementFilter.methodsIn(this.getHelper().getCompilationController().getElements().getAllMembers((TypeElement)beanElement));
        TypeElement objectElement = this.getHelper().getCompilationController().getElements().getTypeElement(Object.class.getCanonicalName());
        for (ExecutableElement executableElement : methods) {
            if (executableElement.getEnclosingElement().equals(objectElement)) continue;
            if (this.hasModifier(executableElement, Modifier.FINAL)) {
                types.remove(typeElement);
                elements.remove(typeElement);
                return;
            }
            Element overloaded = this.getHelper().getCompilationController().getElementUtilities().getImplementationOf(executableElement, typeElement);
            if (overloaded == null || !this.hasModifier(overloaded, Modifier.FINAL)) continue;
            types.remove(typeElement);
            elements.remove(typeElement);
            return;
        }
    }

    private DeclaredType getDeclaredType(TypeMirror type) {
        if (type instanceof DeclaredType && type.getKind() != TypeKind.ERROR) {
            return (DeclaredType)type;
        }
        if (type instanceof TypeVariable) {
            TypeMirror upperBound = ((TypeVariable)type).getUpperBound();
            return this.getDeclaredType(upperBound);
        }
        if (type instanceof WildcardType) {
            TypeMirror extendsBound = ((WildcardType)type).getExtendsBound();
            return this.getDeclaredType(extendsBound);
        }
        return null;
    }

    private boolean hasModifier(Element element, Modifier mod) {
        Set<Modifier> modifiers = element.getModifiers();
        for (Modifier modifier : modifiers) {
            if (modifier != mod) continue;
            return true;
        }
        return false;
    }

    private void checkSpecializes(TypeElement typeElement, LinkedList<Element> beans, Set<Element> resultElementSet, Set<Element> originalElements) {
        TypeMirror superClass;
        TypeElement current = typeElement;
        while (current != null && (superClass = current.getSuperclass()) instanceof DeclaredType && AnnotationObjectProvider.hasSpecializes(current, this.getHelper())) {
            TypeElement superElement = (TypeElement)((DeclaredType)superClass).asElement();
            if (originalElements.contains(superElement)) {
                resultElementSet.remove(superElement);
            }
            beans.remove(superElement);
            if (!this.getResult().getTypeElements().contains(superElement)) break;
            current = superElement;
        }
    }

    private void addEnabledAlternative(TypeElement typeElement, Element element) {
        String name = typeElement.getQualifiedName().toString();
        if (this.getResult().hasAlternative(element) && !this.getModel().getAlternativeClasses().contains(name)) {
            return;
        }
        if (this.alternativeStereotypesEnabled(element)) {
            this.myEnabledAlternatives.add(element);
        }
    }

    private boolean alternativeStereotypesEnabled(Element element) {
        List<AnnotationMirror> stereotypes = this.getResult().getStereotypes(element);
        for (AnnotationMirror annotationMirror : stereotypes) {
            DeclaredType annotationType = annotationMirror.getAnnotationType();
            TypeElement annotationTypeElement = (TypeElement)annotationType.asElement();
            if (!this.getResult().isAlternative(annotationTypeElement)) continue;
            if (this.getResult().hasAlternative(annotationTypeElement)) {
                String name = annotationTypeElement.getQualifiedName().toString();
                if (this.getModel().getAlternativeStereotypes().contains(name)) continue;
                return false;
            }
            if (this.alternativeStereotypesEnabled(annotationTypeElement)) continue;
            return false;
        }
        return true;
    }

    private ResultImpl getResult() {
        return this.myResult;
    }

    private BeansModel getModel() {
        return this.myBeansModel;
    }

    private AnnotationModelHelper getHelper() {
        return this.myHelper;
    }

    private WebBeansModelImplementation getWebBeansModel() {
        return this.myModel;
    }

    private InjectableResultImpl handleEESpecificImplementations(ResultImpl result, TypeElement firstElement, Set<Element> enabledTypes) {
        if (result.getVariable() != null) {
            String nm = result.getVariable().asType().toString();
            int c = nm.indexOf(60);
            if (c > 0) {
                nm = nm.substring(0, c);
            }
            if (this.predefinedBeans.contains(nm)) {
                return new InjectableResultImpl(this.getResult(), firstElement, enabledTypes);
            }
            String ann = this.predefinedBeanAnnotationPairs.get(nm);
            if (ann != null) {
                for (AnnotationMirror annotationMirror : result.getVariable().getAnnotationMirrors()) {
                    if (!ann.equals(annotationMirror.getAnnotationType().toString())) continue;
                    return new InjectableResultImpl(this.getResult(), firstElement, enabledTypes);
                }
            }
        }
        return null;
    }
}

