/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import java.lang.ref.WeakReference;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.netbeans.modules.form.BeanSupport;
import org.netbeans.modules.form.FormCustomEditor;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.FormPropertyContext;
import org.netbeans.modules.form.FormPropertyEditorManager;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.JavaCodeGenerator;
import org.netbeans.modules.form.RADConnectionPropertyEditor;
import org.netbeans.modules.form.ResourceWrapperEditor;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;

public class FormPropertyEditor
implements PropertyEditor,
PropertyChangeListener,
ExPropertyEditor {
    private static String NO_VALUE_TEXT;
    private Object value = BeanSupport.NO_VALUE;
    private boolean valueEdited;
    private static final boolean SUPPRESS_FORM_EDITORS;
    private FormProperty property;
    private WeakReference<PropertyEnv> propertyEnv;
    private PropertyEditor[] allEditors;
    private PropertyEditor lastCurrentEditor;
    private PropertyChangeSupport changeSupport;

    FormPropertyEditor(FormProperty property) {
        this.property = property;
        PropertyEditor prEd = property.getCurrentEditor();
        if (prEd != null) {
            prEd.addPropertyChangeListener(this);
            this.value = prEd.getValue();
        }
    }

    Class getPropertyType() {
        return this.property.getValueType();
    }

    FormProperty getProperty() {
        return this.property;
    }

    FormPropertyContext getPropertyContext() {
        return this.property.getPropertyContext();
    }

    PropertyEnv getPropertyEnv() {
        return this.propertyEnv != null ? (PropertyEnv)this.propertyEnv.get() : null;
    }

    PropertyEditor getCurrentEditor() {
        return this.property.getCurrentEditor();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        PropertyEditor prEd = this.property.getCurrentEditor();
        if (prEd != null) {
            this.value = prEd.getValue();
            this.valueEdited = false;
        }
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                FormPropertyEditor.this.firePropertyChange();
                return null;
            }
        });
    }

    @Override
    public void setValue(Object newValue) {
        this.value = newValue;
        this.valueEdited = false;
        PropertyEditor prEd = this.property.getCurrentEditor();
        if (this.value != BeanSupport.NO_VALUE && prEd != null) {
            prEd.setValue(this.value);
        }
    }

    void setEditedValue(Object newValue) {
        this.value = newValue;
        this.valueEdited = true;
        this.firePropertyChange();
    }

    @Override
    public Object getValue() {
        PropertyEditor prEd;
        if (!this.valueEdited && (prEd = this.property.getCurrentEditor()) != null) {
            return prEd.getValue();
        }
        return this.value;
    }

    @Override
    public boolean isPaintable() {
        PropertyEditor prEd = this.property.getCurrentEditor();
        return prEd != null ? prEd.isPaintable() : false;
    }

    @Override
    public void paintValue(Graphics gfx, Rectangle box) {
        PropertyEditor prEd = this.property.getCurrentEditor();
        if (prEd != null) {
            prEd.paintValue(gfx, box);
        }
    }

    @Override
    public String getJavaInitializationString() {
        PropertyEditor prEd = this.property.getCurrentEditor();
        return prEd != null ? prEd.getJavaInitializationString() : null;
    }

    @Override
    public String getAsText() {
        if (this.value == BeanSupport.NO_VALUE) {
            if (NO_VALUE_TEXT == null) {
                NO_VALUE_TEXT = FormUtils.getBundleString("CTL_ValueNotSet");
            }
            return NO_VALUE_TEXT;
        }
        PropertyEditor prEd = this.property.getCurrentEditor();
        return prEd != null ? prEd.getAsText() : null;
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        PropertyEditor prEd = this.property.getCurrentEditor();
        if (prEd != null) {
            prEd.setAsText(text);
        }
    }

    @Override
    public String[] getTags() {
        PropertyEditor prEd = this.property.getCurrentEditor();
        return prEd != null ? prEd.getTags() : null;
    }

    @Override
    public Component getCustomEditor() {
        Component customEditor;
        PropertyEditor prEd;
        JavaCodeGenerator codeGen;
        FormModel formModel = this.property.getPropertyContext().getFormModel();
        if (formModel != null && (codeGen = (JavaCodeGenerator)FormEditor.getCodeGenerator(formModel)) != null) {
            codeGen.regenerateCode();
        }
        if ((prEd = this.property.getCurrentEditor()) != null && prEd.supportsCustomEditor()) {
            customEditor = prEd.getCustomEditor();
            if (customEditor instanceof Window) {
                return customEditor;
            }
        } else {
            customEditor = null;
        }
        return new FormCustomEditor(this, customEditor);
    }

    @Override
    public boolean supportsCustomEditor() {
        PropertyEditor[] editors = this.getAllEditors();
        if (!this.property.canWrite()) {
            for (int i = 0; i < editors.length; ++i) {
                if (editors[i].getClass().equals(RADConnectionPropertyEditor.class) || !editors[i].supportsCustomEditor()) continue;
                return true;
            }
            return false;
        }
        if (editors.length > 1) {
            return true;
        }
        if (editors.length == 1) {
            return editors[0].supportsCustomEditor();
        }
        return false;
    }

    synchronized PropertyEditor[] getAllEditors() {
        PropertyEditor currentEditor;
        if (SUPPRESS_FORM_EDITORS) {
            return new PropertyEditor[]{this.property.getCurrentEditor()};
        }
        if (this.allEditors != null && (currentEditor = this.property.getCurrentEditor()) != this.lastCurrentEditor) {
            this.allEditors = null;
        }
        if (this.allEditors == null) {
            PropertyEditor currentEditor2;
            PropertyEditor expliciteEditor = this.property.getExpliciteEditor();
            this.lastCurrentEditor = currentEditor2 = this.property.getCurrentEditor();
            if (expliciteEditor != null && currentEditor2 != null && expliciteEditor.getClass().equals(currentEditor2.getClass())) {
                expliciteEditor = null;
            }
            PropertyEditor[] typeEditors = FormPropertyEditorManager.getAllEditors(this.property);
            for (int i = 0; i < typeEditors.length && (expliciteEditor != null || currentEditor2 != null); ++i) {
                PropertyEditor prEd = typeEditors[i];
                ResourceWrapperEditor wrapper = null;
                if (prEd instanceof ResourceWrapperEditor && !(currentEditor2 instanceof ResourceWrapperEditor)) {
                    wrapper = (ResourceWrapperEditor)((Object)prEd);
                    prEd = wrapper.getDelegatedPropertyEditor();
                }
                if (currentEditor2 != null && currentEditor2.getClass().equals(prEd.getClass())) {
                    if (wrapper != null) {
                        wrapper.setDelegatedPropertyEditor(currentEditor2);
                        boolean fire = this.property.isChangeFiring();
                        this.property.setChangeFiring(false);
                        this.property.setCurrentEditor((PropertyEditor)((Object)wrapper));
                        this.property.setChangeFiring(fire);
                        PropertyEnv env = this.getPropertyEnv();
                        if (env != null) {
                            wrapper.attachEnv(env);
                        }
                    } else {
                        if (prEd instanceof RADConnectionPropertyEditor && ((RADConnectionPropertyEditor)prEd).getEditorType() != ((RADConnectionPropertyEditor)currentEditor2).getEditorType()) continue;
                        typeEditors[i] = currentEditor2;
                    }
                    currentEditor2 = null;
                    continue;
                }
                if (expliciteEditor == null || !expliciteEditor.getClass().equals(prEd.getClass())) continue;
                if (wrapper != null) {
                    wrapper.setDelegatedPropertyEditor(expliciteEditor);
                } else {
                    typeEditors[i] = expliciteEditor;
                }
                expliciteEditor = null;
            }
            int count = typeEditors.length;
            if (expliciteEditor != null) {
                ++count;
            }
            if (currentEditor2 != null) {
                ++count;
            }
            if (count > typeEditors.length) {
                this.allEditors = new PropertyEditor[count];
                int index = 0;
                if (currentEditor2 != null) {
                    this.allEditors[index++] = currentEditor2;
                }
                if (expliciteEditor != null) {
                    this.allEditors[index++] = expliciteEditor;
                }
                System.arraycopy(typeEditors, 0, this.allEditors, index, typeEditors.length);
            } else {
                this.allEditors = typeEditors;
            }
        }
        return this.allEditors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        FormPropertyEditor formPropertyEditor = this;
        synchronized (formPropertyEditor) {
            if (this.changeSupport == null) {
                this.changeSupport = new PropertyChangeSupport(this);
            }
        }
        this.changeSupport.addPropertyChangeListener(l);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        if (this.changeSupport != null) {
            this.changeSupport.removePropertyChangeListener(l);
        }
    }

    void firePropertyChange() {
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange(null, null, null);
        }
    }

    public void attachEnv(PropertyEnv env) {
        this.propertyEnv = new WeakReference<PropertyEnv>(env);
        PropertyEditor prEd = this.property.getCurrentEditor();
        if (prEd instanceof ExPropertyEditor) {
            ((ExPropertyEditor)prEd).attachEnv(env);
        }
    }

    public int hashCode() {
        PropertyEditor prEd = this.property.getCurrentEditor();
        return prEd != null ? prEd.hashCode() : super.hashCode();
    }

    public boolean equals(Object obj) {
        return obj != null ? this.hashCode() == obj.hashCode() : false;
    }

    static {
        SUPPRESS_FORM_EDITORS = Boolean.getBoolean("nb.form.suppress.editors");
    }
}

