/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.editors;

import java.beans.PropertyEditorSupport;
import org.netbeans.modules.form.NamedPropertyEditor;
import org.openide.util.NbBundle;

public class MnemonicEditor
extends PropertyEditorSupport
implements NamedPropertyEditor {
    @Override
    public String getAsText() {
        Object ovalue = this.getValue();
        char value = '\u0000';
        if (Character.class.isInstance(ovalue)) {
            value = ((Character)ovalue).charValue();
        } else if (Integer.class.isInstance(ovalue)) {
            value = (char)((Integer)ovalue).intValue();
        }
        if (value == '\u0000') {
            return "";
        }
        StringBuffer buf = new StringBuffer(6);
        switch (value) {
            case '\b': {
                buf.append("\\b");
                break;
            }
            case '\t': {
                buf.append("\\t");
                break;
            }
            case '\n': {
                buf.append("\\n");
                break;
            }
            case '\f': {
                buf.append("\\f");
                break;
            }
            case '\r': {
                buf.append("\\r");
                break;
            }
            case '\\': {
                buf.append("\\\\");
                break;
            }
            default: {
                if (value >= ' ' && value <= '\u007f') {
                    buf.append(value);
                    break;
                }
                buf.append("\\u");
                String hex = Integer.toHexString(value);
                for (int j = 0; j < 4 - hex.length(); ++j) {
                    buf.append('0');
                }
                buf.append(hex);
            }
        }
        return buf.toString();
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        if (text.length() < 1) {
            this.setValue(0);
            return;
        }
        if (text.length() == 1 && text.charAt(0) != '\\') {
            this.setValue(Character.valueOf(text.charAt(0)));
            return;
        }
        if (text.charAt(0) == '\\') {
            char value = '\u0000';
            int ch = text.length() >= 2 ? (int)text.charAt(1) : 92;
            switch (ch) {
                case 98: {
                    value = '\b';
                    break;
                }
                case 116: {
                    value = '\t';
                    break;
                }
                case 110: {
                    value = '\n';
                    break;
                }
                case 102: {
                    value = '\f';
                    break;
                }
                case 114: {
                    value = '\r';
                    break;
                }
                case 92: {
                    value = '\\';
                    break;
                }
                case 117: {
                    String num = text.substring(2);
                    if (num.length() > 4) {
                        return;
                    }
                    try {
                        int intValue = Integer.parseInt(num, 16);
                        value = (char)intValue;
                        break;
                    }
                    catch (NumberFormatException nfe) {
                        return;
                    }
                }
                default: {
                    return;
                }
            }
            this.setValue(Character.valueOf(value));
            return;
        }
        try {
            this.setValue(Integer.valueOf(text));
        }
        catch (NumberFormatException e) {
            this.setValue(text);
        }
    }

    @Override
    public void setValue(Object newValue) throws IllegalArgumentException {
        String text;
        if (newValue instanceof Integer) {
            super.setValue(newValue);
        } else if (newValue instanceof Character) {
            char c = ((Character)newValue).charValue();
            super.setValue(c);
        } else if (newValue instanceof String && (text = (String)newValue).length() >= 1) {
            super.setValue(text.charAt(0));
            return;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public String getJavaInitializationString() {
        return "'" + this.getAsText() + "'";
    }

    @Override
    public String getDisplayName() {
        return NbBundle.getBundle(this.getClass()).getString("CTL_MnemonicsEditor_DisplayName");
    }
}

