/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spellchecker.options;

import java.awt.Color;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.LayoutStyle;
import javax.swing.ListModel;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.modules.spellchecker.ComponentPeer;
import org.netbeans.modules.spellchecker.DefaultLocaleQueryImplementation;
import org.netbeans.modules.spellchecker.DictionaryProviderImpl;
import org.netbeans.modules.spellchecker.options.CheckBoxRenderrer;
import org.netbeans.modules.spellchecker.options.DictionaryInstallerPanel;
import org.netbeans.modules.spellchecker.options.SpellcheckerOptionsPanelController;
import org.netbeans.modules.spellchecker.spi.dictionary.DictionaryProvider;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class SpellcheckerOptionsPanel
extends JPanel {
    private List<Locale> removedDictionaries = new ArrayList<Locale>();
    private List<DictionaryInstallerPanel.DictionaryDescription> addedDictionaries = new ArrayList<DictionaryInstallerPanel.DictionaryDescription>();
    private SpellcheckerOptionsPanelController c;
    private static final Icon errorIcon = ImageUtilities.loadIcon((String)"org/netbeans/modules/spellchecker/resources/error.gif");
    private JButton addButton;
    private JComboBox defaultLocale;
    private JLabel errorText;
    private JList installedLocalesList;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JList lUseIn;
    private JButton removeButton;
    private static final Comparator<String> CategoryComparator = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            return o1.substring(1).compareTo(o2.substring(1));
        }
    };

    public SpellcheckerOptionsPanel(SpellcheckerOptionsPanelController c) {
        this.initComponents();
        this.c = c;
        Color errorColor = UIManager.getColor("nb.errorForeground");
        if (errorColor == null) {
            errorColor = new Color(255, 0, 0);
        }
        this.errorText.setForeground(errorColor);
        JTextComponent editorComponent = (JTextComponent)this.defaultLocale.getEditor().getEditorComponent();
        final Document document = editorComponent.getDocument();
        document.addDocumentListener(new DocumentListener(){
            final /* synthetic */ SpellcheckerOptionsPanel this$0;
            {
                this.this$0 = this$0;
            }

            private void validate() {
                try {
                    String locale = document.getText(0, document.getLength());
                    this.this$0.setError(SpellcheckerOptionsPanel.getErrorsForLocale(locale));
                }
                catch (BadLocationException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.validate();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.validate();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        List<String> cathegories = SpellcheckerOptionsPanel.loadCategories();
        DefaultListModel<String> model = new DefaultListModel<String>();
        for (String category : cathegories) {
            model.addElement(category);
        }
        this.lUseIn.setModel(model);
        this.lUseIn.setCellRenderer(new CheckBoxRenderrer());
        this.lUseIn.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (e.getKeyChar() == ' ') {
                    int i = SpellcheckerOptionsPanel.this.lUseIn.getSelectedIndex();
                    if (i < 0) {
                        return;
                    }
                    String name = (String)SpellcheckerOptionsPanel.this.lUseIn.getModel().getElementAt(i);
                    if (name.charAt(0) == '+') {
                        ((DefaultListModel)SpellcheckerOptionsPanel.this.lUseIn.getModel()).set(i, "-" + name.substring(1));
                    } else {
                        ((DefaultListModel)SpellcheckerOptionsPanel.this.lUseIn.getModel()).set(i, "+" + name.substring(1));
                    }
                    SpellcheckerOptionsPanel.this.fireChanged();
                }
            }
        });
        this.lUseIn.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int i = SpellcheckerOptionsPanel.this.lUseIn.getSelectedIndex();
                if (i < 0) {
                    return;
                }
                String name = (String)SpellcheckerOptionsPanel.this.lUseIn.getModel().getElementAt(i);
                if (name.charAt(0) == '+') {
                    ((DefaultListModel)SpellcheckerOptionsPanel.this.lUseIn.getModel()).set(i, "-" + name.substring(1));
                } else {
                    ((DefaultListModel)SpellcheckerOptionsPanel.this.lUseIn.getModel()).set(i, "+" + name.substring(1));
                }
                SpellcheckerOptionsPanel.this.fireChanged();
            }
        });
        this.installedLocalesList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                SpellcheckerOptionsPanel.this.enableDisableButtons();
            }
        });
        this.enableDisableButtons();
    }

    private void fireChanged() {
        List<String> savedCategories = SpellcheckerOptionsPanel.loadCategories();
        ListModel model = this.lUseIn.getModel();
        ArrayList<String> currentCategories = new ArrayList<String>(model.getSize());
        for (int i = 0; i < model.getSize(); ++i) {
            currentCategories.add((String)model.getElementAt(i));
        }
        boolean isChanged = !savedCategories.equals(currentCategories);
        ArrayList<Locale> savedLocales = new ArrayList<Locale>(Arrays.asList(DictionaryProviderImpl.getInstalledDictionariesLocales()));
        model = this.installedLocalesList.getModel();
        ArrayList<Locale> currentLocales = new ArrayList<Locale>(model.getSize());
        for (int i = 0; i < model.getSize(); ++i) {
            currentLocales.add((Locale)model.getElementAt(i));
        }
        isChanged |= !savedLocales.equals(currentLocales);
        Object selectedItem = this.defaultLocale.getSelectedItem();
        Locale selectedLocale = null;
        if (selectedItem instanceof Locale) {
            selectedLocale = (Locale)selectedItem;
        }
        if (selectedItem instanceof String) {
            String[] parsedComponents = ((String)selectedItem).split("_");
            String[] components = new String[]{"", "", ""};
            System.arraycopy(parsedComponents, 0, components, 0, parsedComponents.length);
            selectedLocale = new Locale(components[0], components[1], components[2]);
        }
        if (selectedLocale != null) {
            isChanged |= !DefaultLocaleQueryImplementation.getDefaultLocale().equals(selectedLocale);
        }
        this.c.notifyChanged(isChanged);
    }

    private void setError(String error) {
        this.c.setValid(error == null);
        this.errorText.setText(error != null ? NbBundle.getMessage(SpellcheckerOptionsPanel.class, (String)error) : "");
        this.errorText.setIcon(error != null ? errorIcon : null);
    }

    public void update() {
        this.updateUsedIn();
        this.removedDictionaries.clear();
        this.addedDictionaries.clear();
        this.updateLocales();
        this.defaultLocale.setSelectedItem(DefaultLocaleQueryImplementation.getDefaultLocale());
    }

    private void updateUsedIn() {
        List<String> categories = SpellcheckerOptionsPanel.loadCategories();
        DefaultListModel<String> model = new DefaultListModel<String>();
        for (String category : categories) {
            model.addElement(category);
        }
        this.lUseIn.setModel(model);
    }

    private void updateLocales() {
        DefaultListModel<Locale> model = new DefaultListModel<Locale>();
        ArrayList<Locale> locales = new ArrayList<Locale>(Arrays.asList(DictionaryProviderImpl.getInstalledDictionariesLocales()));
        for (DictionaryInstallerPanel.DictionaryDescription desc : this.addedDictionaries) {
            locales.add(desc.getLocale());
        }
        locales.removeAll(this.removedDictionaries);
        for (Locale l : locales) {
            model.addElement(l);
        }
        this.installedLocalesList.setModel(model);
    }

    public void commit() {
        for (DictionaryInstallerPanel.DictionaryDescription desc : this.addedDictionaries) {
            DictionaryInstallerPanel.doInstall(desc);
        }
        for (Locale remove : this.removedDictionaries) {
            DictionaryInstallerPanel.removeDictionary(remove);
        }
        Object selectedItem = this.defaultLocale.getSelectedItem();
        Locale selectedLocale = null;
        if (selectedItem instanceof Locale) {
            selectedLocale = (Locale)selectedItem;
        }
        if (selectedItem instanceof String) {
            String[] parsedComponents = ((String)selectedItem).split("_");
            String[] components = new String[]{"", "", ""};
            System.arraycopy(parsedComponents, 0, components, 0, parsedComponents.length);
            selectedLocale = new Locale(components[0], components[1], components[2]);
        }
        if (selectedLocale != null) {
            DefaultLocaleQueryImplementation.setDefaultLocale(selectedLocale);
        }
        for (DictionaryProvider p : Lookup.getDefault().lookupAll(DictionaryProvider.class)) {
            if (!(p instanceof DictionaryProviderImpl)) continue;
            ((DictionaryProviderImpl)p).clearDictionaries();
        }
        FileObject root = FileUtil.getConfigFile((String)"Spellcheckers");
        if (root != null) {
            FileObject[] children;
            HashSet<String> hidden = new HashSet<String>();
            ListModel model = this.lUseIn.getModel();
            for (int i = 0; i < model.getSize(); ++i) {
                String n = (String)model.getElementAt(i);
                if (n.charAt(0) != '-') continue;
                hidden.add(n.substring(1));
            }
            for (FileObject fileObject : children = root.getChildren()) {
                String name = null;
                try {
                    name = fileObject.getFileSystem().getDecorator().annotateName(fileObject.getName(), Collections.singleton(fileObject));
                }
                catch (FileStateInvalidException ex) {
                    name = fileObject.getName();
                }
                try {
                    fileObject.setAttribute("Hidden", (Object)hidden.contains(name));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        for (JTextComponent component : EditorRegistry.componentList()) {
            ComponentPeer componentPeer = (ComponentPeer)component.getClientProperty(ComponentPeer.class);
            if (componentPeer == null) continue;
            componentPeer.reschedule();
        }
    }

    private void initComponents() {
        this.jLabel2 = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jLabel3 = new JLabel();
        this.jSeparator2 = new JSeparator();
        this.jLabel4 = new JLabel();
        this.jSeparator3 = new JSeparator();
        this.jScrollPane2 = new JScrollPane();
        this.lUseIn = new JList();
        this.jScrollPane1 = new JScrollPane();
        this.installedLocalesList = new JList();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.errorText = new JLabel();
        this.defaultLocale = new JComboBox();
        this.jLabel1 = new JLabel();
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(SpellcheckerOptionsPanel.class, (String)"LBL_Use_in"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(SpellcheckerOptionsPanel.class, (String)"SpellcheckerOptionsPanel.dictionariesListPanel.border.title"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(SpellcheckerOptionsPanel.class, (String)"LBL_Default_Locale_Panel"));
        this.lUseIn.setVisibleRowCount(5);
        this.jScrollPane2.setViewportView(this.lUseIn);
        this.lUseIn.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SpellcheckerOptionsPanel.class, (String)"lUseIn_ACSN"));
        this.lUseIn.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SpellcheckerOptionsPanel.class, (String)"lUseIn_ACSD"));
        this.installedLocalesList.setModel(this.getInstalledDictionariesModel());
        this.installedLocalesList.setVisibleRowCount(4);
        this.jScrollPane1.setViewportView(this.installedLocalesList);
        this.installedLocalesList.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SpellcheckerOptionsPanel.class, (String)"installedLocalesList_ACSN"));
        this.installedLocalesList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SpellcheckerOptionsPanel.class, (String)"installedLocalesList_ACSD"));
        Mnemonics.setLocalizedText((AbstractButton)this.addButton, (String)NbBundle.getMessage(SpellcheckerOptionsPanel.class, (String)"SpellcheckerOptionsPanel.addButton.text"));
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SpellcheckerOptionsPanel.this.addButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.removeButton, (String)NbBundle.getMessage(SpellcheckerOptionsPanel.class, (String)"SpellcheckerOptionsPanel.removeButton.text"));
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SpellcheckerOptionsPanel.this.removeButtonActionPerformed(evt);
            }
        });
        this.defaultLocale.setEditable(true);
        this.defaultLocale.setModel(this.getLocaleModel());
        this.defaultLocale.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                SpellcheckerOptionsPanel.this.defaultLocaleItemStateChanged(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(SpellcheckerOptionsPanel.class, (String)"LBL_Default_Locale", (Object[])new Object[0]));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(142, 142, 142).addComponent(this.errorText).addContainerGap(285, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.defaultLocale, 0, 297, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator3)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator2)).addComponent(this.jScrollPane2).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.addButton, -1, -1, Short.MAX_VALUE).addComponent(this.removeButton))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel2).addComponent(this.jSeparator1, -2, 10, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -2, -1, -2).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel3).addComponent(this.jSeparator2, -2, 10, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.addButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.removeButton)).addComponent(this.jScrollPane1, -1, 72, Short.MAX_VALUE)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel4).addComponent(this.jSeparator3, -2, 10, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.defaultLocale, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.errorText).addContainerGap()));
        this.addButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SpellcheckerOptionsPanel.class, (String)"SpellcheckerOptionsPanel.addButton.ACSN"));
        this.addButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SpellcheckerOptionsPanel.class, (String)"SpellcheckerOptionsPanel.addButton.ACSD"));
        this.removeButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SpellcheckerOptionsPanel.class, (String)"SpellcheckerOptionsPanel.removeButton.ACSN"));
        this.removeButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SpellcheckerOptionsPanel.class, (String)"SpellcheckerOptionsPanel.removeButton.ACSD"));
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        for (Object o : this.installedLocalesList.getSelectedValues()) {
            this.removedDictionaries.add((Locale)o);
        }
        this.updateLocales();
        this.fireChanged();
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        HashSet<String> currentLocales = new HashSet<String>();
        ListModel locales = this.installedLocalesList.getModel();
        for (int c = 0; c < locales.getSize(); ++c) {
            currentLocales.add(locales.getElementAt(c).toString());
        }
        JButton okButton = new JButton(NbBundle.getMessage(SpellcheckerOptionsPanel.class, (String)"BTN_Add"));
        DictionaryInstallerPanel panel = new DictionaryInstallerPanel(okButton, currentLocales);
        DialogDescriptor dd = new DialogDescriptor((Object)panel, NbBundle.getMessage(SpellcheckerOptionsPanel.class, (String)"LBL_AddDictionary"), true, new Object[]{okButton, DialogDescriptor.CANCEL_OPTION}, (Object)okButton, 0, null, null);
        dd.setClosingOptions(null);
        panel.setNotifications(dd.createNotificationLineSupport());
        Dialog d = DialogDisplayer.getDefault().createDialog(dd);
        d.setVisible(true);
        if (dd.getValue() == okButton) {
            DictionaryInstallerPanel.DictionaryDescription desc = panel.createDescription();
            this.addedDictionaries.add(desc);
            this.removedDictionaries.remove(desc.getLocale());
            this.updateLocales();
        }
        this.fireChanged();
    }

    private void defaultLocaleItemStateChanged(ItemEvent evt) {
        this.fireChanged();
    }

    private ListModel getInstalledDictionariesModel() {
        DefaultListModel<Locale> dlm = new DefaultListModel<Locale>();
        for (Locale l : DictionaryProviderImpl.getInstalledDictionariesLocales()) {
            dlm.addElement(l);
        }
        return dlm;
    }

    private ComboBoxModel getLocaleModel() {
        DefaultComboBoxModel<Locale> dlm = new DefaultComboBoxModel<Locale>();
        ArrayList<Locale> locales = new ArrayList<Locale>(Arrays.asList(Locale.getAvailableLocales()));
        locales.sort(new LocaleComparator());
        for (Locale l : locales) {
            dlm.addElement(l);
        }
        return dlm;
    }

    private static List<String> loadCategories() {
        ArrayList<String> result = new ArrayList<String>();
        FileObject root = FileUtil.getConfigFile((String)"Spellcheckers");
        if (root != null) {
            FileObject[] children;
            for (FileObject fileObject : children = root.getChildren()) {
                String name = null;
                try {
                    name = fileObject.getFileSystem().getDecorator().annotateName(fileObject.getName(), Collections.singleton(fileObject));
                }
                catch (FileStateInvalidException ex) {
                    name = fileObject.getName();
                }
                Boolean b = (Boolean)fileObject.getAttribute("Hidden");
                if (b != null && b.booleanValue()) {
                    result.add("-" + name);
                    continue;
                }
                result.add("+" + name);
            }
        }
        result.sort(CategoryComparator);
        return result;
    }

    public static String getErrorsForLocale(String locale) {
        if (locale.length() == 0) {
            return "ERR_LocaleIsEmpty";
        }
        String[] components = locale.split("_");
        if (components.length > 3) {
            return "ERR_InvalidLocale";
        }
        if (!Arrays.asList(Locale.getISOLanguages()).contains(components[0])) {
            return "ERR_UnknownLanguage";
        }
        if (components.length > 1) {
            if (!Arrays.asList(Locale.getISOCountries()).contains(components[1])) {
                return "ERR_UnknownCountry";
            }
            if (!Arrays.asList(Locale.getAvailableLocales()).contains(new Locale(components[0], components[1]))) {
                return "ERR_UnsupportedLocale";
            }
        }
        return null;
    }

    private void enableDisableButtons() {
        this.removeButton.setEnabled(this.installedLocalesList.getSelectedIndex() != -1);
    }

    private static class LocaleComparator
    implements Comparator<Locale> {
        private LocaleComparator() {
        }

        @Override
        public int compare(Locale o1, Locale o2) {
            return o1.toString().compareTo(o2.toString());
        }
    }
}

