/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.impl.ui.wizard;

import java.awt.Dialog;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.j2ee.deployment.impl.Server;
import org.netbeans.modules.j2ee.deployment.impl.ServerRegistry;
import org.netbeans.modules.j2ee.deployment.impl.ui.wizard.ServerChooserPanel;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.j2ee.deployment.plugins.spi.OptionalDeploymentManagerFactory;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.util.NbBundle;

public class AddServerInstanceWizard
extends WizardDescriptor {
    public static final String PROP_DISPLAY_NAME = "ServInstWizard_displayName";
    public static final String PROP_SERVER = "ServInstWizard_server";
    private static final String PROP_AUTO_WIZARD_STYLE = "WizardPanel_autoWizardStyle";
    private static final String PROP_CONTENT_DISPLAYED = "WizardPanel_contentDisplayed";
    private static final String PROP_CONTENT_NUMBERED = "WizardPanel_contentNumbered";
    private static final String PROP_CONTENT_DATA = "WizardPanel_contentData";
    private static final String PROP_CONTENT_SELECTED_INDEX = "WizardPanel_contentSelectedIndex";
    private static final String PROP_ERROR_MESSAGE = "WizardPanel_errorMessage";
    private AddServerInstanceWizardIterator iterator;
    private ServerChooserPanel chooser;
    private static final Logger LOGGER = Logger.getLogger("org.netbeans.modules.j2ee.deployment");

    private AddServerInstanceWizard(Map<String, String> props) {
        this(new AddServerInstanceWizardIterator());
        this.putProperty(PROP_AUTO_WIZARD_STYLE, Boolean.TRUE);
        this.putProperty(PROP_CONTENT_DISPLAYED, Boolean.TRUE);
        this.putProperty(PROP_CONTENT_NUMBERED, Boolean.TRUE);
        for (Map.Entry<String, String> entry : props.entrySet()) {
            this.putProperty(entry.getKey(), entry.getValue());
        }
        this.setTitle(NbBundle.getMessage(AddServerInstanceWizard.class, (String)"LBL_ASIW_Title"));
        this.setTitleFormat(new MessageFormat(NbBundle.getMessage(AddServerInstanceWizard.class, (String)"LBL_ASIW_TitleFormat")));
        this.initialize();
    }

    private AddServerInstanceWizard(AddServerInstanceWizardIterator iterator) {
        super((WizardDescriptor.Iterator)iterator);
        this.iterator = iterator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String showAddServerInstanceWizard(Map<String, String> props) {
        Set instantiatedObjects;
        Collection<Server> allServers = ServerRegistry.getInstance().getServers();
        Iterator<Server> it = allServers.iterator();
        while (it.hasNext()) {
            Server server = it.next();
            OptionalDeploymentManagerFactory factory = server.getOptionalFactory();
            if (factory != null && factory.getAddInstanceIterator() != null) continue;
            it.remove();
        }
        if (allServers.isEmpty()) {
            String close = NbBundle.getMessage(AddServerInstanceWizard.class, (String)"LBL_NoServerPlugins_Close");
            DialogDescriptor descriptor = new DialogDescriptor((Object)NbBundle.getMessage(AddServerInstanceWizard.class, (String)"LBL_NoServerPlugins_Text"), NbBundle.getMessage(AddServerInstanceWizard.class, (String)"LBL_NoServerPlugins_Title"), true, new Object[]{close}, (Object)close, 0, null, null);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor);
            return null;
        }
        AddServerInstanceWizard wizard = new AddServerInstanceWizard(props);
        Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)wizard);
        try {
            dialog.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddServerInstanceWizard.class, (String)"ACSD_Add_Server_Instance"));
            dialog.setVisible(true);
        }
        finally {
            dialog.dispose();
        }
        if (wizard.getValue() == WizardDescriptor.FINISH_OPTION && (instantiatedObjects = wizard.getInstantiatedObjects()) != null && instantiatedObjects.size() > 0) {
            Object result = instantiatedObjects.iterator().next();
            if (result instanceof InstanceProperties) {
                return ((InstanceProperties)result).getProperty("url");
            }
            LOGGER.warning(wizard.iterator.getSelectedServer() + "'s add server instance wizard iterator should return a Set containing new server instance InstanceProperties object as a result of the WizardDescriptor.InstantiatingIterator.instantiate() method.");
            return null;
        }
        return null;
    }

    public void setErrorMessage(String message) {
        this.putProperty(PROP_ERROR_MESSAGE, message);
    }

    protected void updateState() {
        super.updateState();
        String[] contentData = this.getContentData();
        if (contentData != null) {
            this.putProperty(PROP_CONTENT_DATA, contentData);
            this.putProperty(PROP_CONTENT_SELECTED_INDEX, this.getContentSelectedIndex());
        }
    }

    private ServerChooserPanel getChooser() {
        if (this.chooser == null) {
            this.chooser = new ServerChooserPanel();
        }
        return this.chooser;
    }

    private String[] getContentData() {
        JComponent first = (JComponent)this.getChooser().getComponent();
        String[] firstContentData = (String[])first.getClientProperty(PROP_CONTENT_DATA);
        if (this.iterator.current().equals((Object)this.getChooser())) {
            return firstContentData;
        }
        JComponent component = (JComponent)this.iterator.current().getComponent();
        String[] componentContentData = (String[])component.getClientProperty(PROP_CONTENT_DATA);
        if (componentContentData == null) {
            return firstContentData;
        }
        String[] contentData = new String[componentContentData.length + 1];
        contentData[0] = firstContentData[0];
        System.arraycopy(componentContentData, 0, contentData, 1, componentContentData.length);
        return contentData;
    }

    private int getContentSelectedIndex() {
        if (this.iterator.current().equals((Object)this.getChooser())) {
            return 0;
        }
        JComponent component = (JComponent)this.iterator.current().getComponent();
        Integer componentIndex = (Integer)component.getClientProperty(PROP_CONTENT_SELECTED_INDEX);
        if (componentIndex != null) {
            return componentIndex + 1;
        }
        return 1;
    }

    private static class AddServerInstanceWizardIterator
    implements WizardDescriptor.AsynchronousInstantiatingIterator {
        private AddServerInstanceWizard wd;
        public boolean showingChooser = true;
        private WizardDescriptor.InstantiatingIterator iterator;
        private HashMap iterators = new HashMap();

        public void addChangeListener(ChangeListener l) {
        }

        public WizardDescriptor.Panel current() {
            if (this.showingChooser) {
                return this.wd.getChooser();
            }
            if (this.iterator != null) {
                return this.iterator.current();
            }
            return null;
        }

        public boolean hasNext() {
            if (this.showingChooser) {
                return true;
            }
            if (this.iterator != null) {
                return this.iterator.hasNext();
            }
            return false;
        }

        public boolean hasPrevious() {
            return !this.showingChooser;
        }

        public String name() {
            return null;
        }

        public void nextPanel() {
            if (this.iterator == null) {
                this.iterator = this.getServerIterator();
            } else if (!this.showingChooser) {
                this.iterator.nextPanel();
            }
            this.showingChooser = false;
        }

        public void previousPanel() {
            if (this.iterator.hasPrevious()) {
                this.iterator.previousPanel();
            } else {
                this.showingChooser = true;
                this.iterator = null;
            }
        }

        public void removeChangeListener(ChangeListener l) {
        }

        public void uninitialize(WizardDescriptor wizard) {
        }

        public void initialize(WizardDescriptor wizard) {
            this.wd = (AddServerInstanceWizard)wizard;
            JComponent chooser = (JComponent)this.wd.getChooser().getComponent();
            chooser.putClientProperty(AddServerInstanceWizard.PROP_CONTENT_DATA, new String[]{NbBundle.getMessage(AddServerInstanceWizard.class, (String)"LBL_ASIW_ChooseServer"), NbBundle.getMessage(AddServerInstanceWizard.class, (String)"LBL_ASIW_Ellipsis")});
        }

        public Set instantiate() throws IOException {
            if (this.iterator != null) {
                return this.iterator.instantiate();
            }
            return null;
        }

        private WizardDescriptor.InstantiatingIterator getServerIterator() {
            Server server = this.getSelectedServer();
            if (server == null) {
                return null;
            }
            WizardDescriptor.InstantiatingIterator iterator = (WizardDescriptor.InstantiatingIterator)this.iterators.get(server);
            if (iterator != null) {
                return iterator;
            }
            OptionalDeploymentManagerFactory factory = server.getOptionalFactory();
            if (factory != null) {
                iterator = factory.getAddInstanceIterator();
                iterator.initialize((WizardDescriptor)this.wd);
                this.iterators.put(server, iterator);
                return iterator;
            }
            return null;
        }

        public Server getSelectedServer() {
            return (Server)this.wd.getProperty(AddServerInstanceWizard.PROP_SERVER);
        }
    }
}

