/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.completion;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.swing.ImageIcon;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.editor.completion.CompletionSupportSpiPackageAccessor;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.CompletionUtilities;
import org.openide.util.ImageUtilities;

public class SimpleCompletionItem
implements CompletionItem {
    private final String insertText;
    private final int startOffset;
    private final int endOffset;
    private final String iconResource;
    private final String leftHtmlText;
    private final String rightHtmlText;
    private final int sortPriority;
    private final CharSequence sortText;
    private final Supplier<CompletionTask> documentationTask;
    private final Supplier<CompletionTask> tooltipTask;
    private final Consumer<CompletionUtilities.OnSelectContext> onSelectCallback;
    private ImageIcon icon;

    public SimpleCompletionItem(String insertText, int startOffset, int endOffset, String iconResource, String leftHtmlText, String rightHtmlText, int sortPriority, CharSequence sortText, Supplier<CompletionTask> documentationTask, Supplier<CompletionTask> tooltipTask, Consumer<CompletionUtilities.OnSelectContext> onSelectCallback) {
        this.insertText = insertText;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        this.iconResource = iconResource;
        this.leftHtmlText = leftHtmlText;
        this.rightHtmlText = rightHtmlText;
        this.sortPriority = sortPriority;
        this.sortText = sortText;
        this.documentationTask = documentationTask;
        this.tooltipTask = tooltipTask;
        this.onSelectCallback = onSelectCallback;
    }

    @Override
    public void defaultAction(JTextComponent component) {
        if (component != null) {
            Completion.get().hideDocumentation();
            Completion.get().hideCompletion();
            this.process(component, false);
        }
    }

    @Override
    public void processKeyEvent(KeyEvent evt) {
        if (evt.getID() == 401 && evt.getKeyCode() == 10 && (evt.getModifiers() & 2) > 0) {
            JTextComponent component = (JTextComponent)evt.getSource();
            Completion.get().hideDocumentation();
            Completion.get().hideCompletion();
            this.process(component, true);
            evt.consume();
        }
    }

    @Override
    public int getPreferredWidth(Graphics g, Font defaultFont) {
        return CompletionUtilities.getPreferredWidth(this.leftHtmlText != null ? this.leftHtmlText : this.insertText, this.rightHtmlText, g, defaultFont);
    }

    @Override
    public void render(Graphics g, Font defaultFont, Color defaultColor, Color backgroundColor, int width, int height, boolean selected) {
        CompletionUtilities.renderHtml(this.getIcon(), this.leftHtmlText != null ? this.leftHtmlText : this.insertText, this.rightHtmlText, g, defaultFont, defaultColor, width, height, selected);
    }

    @Override
    public CompletionTask createDocumentationTask() {
        if (this.documentationTask != null) {
            return this.documentationTask.get();
        }
        return null;
    }

    @Override
    public CompletionTask createToolTipTask() {
        if (this.tooltipTask != null) {
            this.tooltipTask.get();
        }
        return null;
    }

    @Override
    public boolean instantSubstitution(JTextComponent component) {
        return false;
    }

    @Override
    public int getSortPriority() {
        return this.sortPriority;
    }

    @Override
    public CharSequence getSortText() {
        return this.sortText != null ? this.sortText : this.insertText;
    }

    @Override
    public CharSequence getInsertPrefix() {
        return this.insertText;
    }

    private void process(final JTextComponent component, final boolean overwrite) {
        if (this.onSelectCallback != null) {
            CompletionUtilities.OnSelectContext ctx = CompletionSupportSpiPackageAccessor.get().createOnSelectContext(component, overwrite);
            this.onSelectCallback.accept(ctx);
        } else {
            final BaseDocument doc = (BaseDocument)component.getDocument();
            doc.runAtomic(new Runnable(){
                final /* synthetic */ SimpleCompletionItem this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    try {
                        if (this.this$0.startOffset < 0) {
                            if (overwrite && this.this$0.endOffset > component.getCaretPosition()) {
                                doc.remove(component.getCaretPosition(), this.this$0.endOffset - component.getCaretPosition());
                            }
                            doc.insertString(component.getCaretPosition(), this.this$0.insertText, null);
                        } else {
                            doc.remove(this.this$0.startOffset, (overwrite && this.this$0.endOffset > component.getCaretPosition() ? this.this$0.endOffset : component.getCaretPosition()) - this.this$0.startOffset);
                            doc.insertString(this.this$0.startOffset, this.this$0.insertText, null);
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            });
        }
    }

    private ImageIcon getIcon() {
        if (this.icon == null && this.iconResource != null) {
            this.icon = ImageUtilities.loadImageIcon((String)this.iconResource, (boolean)false);
        }
        return this.icon;
    }
}

