/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.payara.common.actions;

import java.awt.event.ActionEvent;
import org.netbeans.modules.payara.common.PayaraState;
import org.netbeans.modules.payara.common.actions.AbstractOutputAction;
import org.netbeans.modules.payara.spi.PayaraModule;
import org.netbeans.modules.payara.tooling.data.PayaraServer;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public class StartServerAction
extends NodeAction {
    protected void performAction(Node[] activatedNodes) {
        for (Node node : activatedNodes) {
            PayaraModule commonSupport = (PayaraModule)node.getLookup().lookup(PayaraModule.class);
            if (commonSupport == null) continue;
            StartServerAction.performActionImpl(commonSupport);
        }
    }

    private static void performActionImpl(PayaraModule commonSupport) {
        commonSupport.setEnvironmentProperty("jvmMode", PayaraModule.NORMAL_MODE, true);
        commonSupport.startServer(null, PayaraModule.ServerState.RUNNING);
    }

    protected boolean enable(Node[] activatedNodes) {
        boolean result = false;
        if (activatedNodes != null && activatedNodes.length > 0) {
            Node node;
            PayaraModule commonSupport;
            Node[] nodeArray = activatedNodes;
            int n = nodeArray.length;
            for (int i = 0; i < n && (result = (commonSupport = (PayaraModule)(node = nodeArray[i]).getLookup().lookup(PayaraModule.class)) != null ? StartServerAction.enableImpl(commonSupport) : false); ++i) {
            }
        }
        return result;
    }

    private static boolean enableImpl(PayaraModule commonSupport) {
        PayaraServer server = commonSupport.getInstance();
        return PayaraState.canStart(server) && !server.isRemote();
    }

    protected boolean asynchronous() {
        return false;
    }

    public String getName() {
        return NbBundle.getMessage(StartServerAction.class, (String)"CTL_StartServerAction");
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public static class OutputAction
    extends AbstractOutputAction {
        private static final String ICON = "org/netbeans/modules/payara/common/resources/start.png";

        public OutputAction(PayaraModule commonSupport) {
            super(commonSupport, NbBundle.getMessage(StartServerAction.class, (String)"LBL_StartOutput"), NbBundle.getMessage(StartServerAction.class, (String)"LBL_StartOutputDesc"), ICON);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            StartServerAction.performActionImpl(this.commonSupport);
        }

        @Override
        public boolean isEnabled() {
            return StartServerAction.enableImpl(this.commonSupport);
        }
    }
}

