/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.upgrade.systemoptions;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.upgrade.systemoptions.DefaultResult;
import org.netbeans.upgrade.systemoptions.PropertiesStorage;
import org.netbeans.upgrade.systemoptions.SystemOptionsParser;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class Importer {
    private static final String DEFINITION_OF_FILES = "systemoptionsimport";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doImport() throws IOException {
        Set<FileObject> files = Importer.getImportFiles(Importer.loadImportFilesDefinition());
        for (DefaultResult result : Importer.parse(files)) {
            Importer.saveResult(result);
        }
        for (FileObject fo : files) {
            FileLock fLock = fo.lock();
            try {
                fo.rename(fLock, fo.getName(), "imported");
            }
            finally {
                fLock.releaseLock();
            }
        }
    }

    private static void saveResult(DefaultResult result) throws IOException {
        String absolutePath = "/" + result.getModuleName();
        PropertiesStorage ps = PropertiesStorage.instance(absolutePath);
        Properties props = ps.load();
        for (String name : result.getPropertyNames()) {
            String val = result.getProperty(name);
            if (val == null) continue;
            props.setProperty(name, val);
        }
        if (!props.isEmpty()) {
            ps.save(props);
        }
    }

    private static Set<DefaultResult> parse(Set<FileObject> files) {
        HashSet<DefaultResult> retval = new HashSet<DefaultResult>();
        for (FileObject f : files) {
            try {
                retval.add(SystemOptionsParser.parse(f, false));
            }
            catch (Exception ex) {
                boolean assertOn = false;
                if (!$assertionsDisabled) {
                    assertOn = true;
                    if (!true) {
                        throw new AssertionError();
                    }
                }
                if (!assertOn) continue;
                Logger.getLogger("org.netbeans.upgrade.systemoptions.parse").log(Level.INFO, "importing: " + f.getPath(), ex);
            }
        }
        return retval;
    }

    static Properties loadImportFilesDefinition() throws IOException {
        Properties props = new Properties();
        try (InputStream is = Importer.class.getResourceAsStream(DEFINITION_OF_FILES);){
            props.load(is);
        }
        return props;
    }

    private static Set<FileObject> getImportFiles(Properties props) {
        HashSet<FileObject> fileobjects = new HashSet<FileObject>();
        for (Object path : props.keySet()) {
            FileObject f = FileUtil.getConfigFile((String)((String)path));
            if (f == null) continue;
            fileobjects.add(f);
        }
        return fileobjects;
    }

    private Importer() {
    }
}

