/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.lsp;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.text.Document;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.lsp.SignatureInformationAccessor;
import org.netbeans.spi.lsp.SignatureInformationCollector;

public final class SignatureInformation {
    private final String label;
    private final List<ParameterInformation> params;
    private final boolean isActive;
    private final String documentation;

    private SignatureInformation(String label, List<ParameterInformation> params, boolean isActive, String documentation) {
        this.label = label;
        this.params = params;
        this.isActive = isActive;
        this.documentation = documentation;
    }

    @NonNull
    public String getLabel() {
        return this.label;
    }

    @NonNull
    public List<ParameterInformation> getParameters() {
        return Collections.unmodifiableList(this.params);
    }

    public boolean isActive() {
        return this.isActive;
    }

    @CheckForNull
    public String getDocumentation() {
        return this.documentation;
    }

    public static void collect(@NonNull Document doc, int offset, @NullAllowed Context context, @NonNull Consumer<SignatureInformation> consumer) {
        MimePath mimePath = MimePath.parse((String)DocumentUtilities.getMimeType((Document)doc));
        for (SignatureInformationCollector collector : MimeLookup.getLookup((MimePath)mimePath).lookupAll(SignatureInformationCollector.class)) {
            collector.collectSignatureInformation(doc, offset, context, consumer);
        }
    }

    static {
        SignatureInformationAccessor.setDefault(new SignatureInformationAccessor(){

            @Override
            public SignatureInformation createSignatureInformation(String label, List<ParameterInformation> params, boolean isActive, String documentation) {
                return new SignatureInformation(label, params, isActive, documentation);
            }

            @Override
            public ParameterInformation createParameterInformation(String label, boolean isActive, String documentation) {
                return new ParameterInformation(label, isActive, documentation);
            }
        });
    }

    public static final class Context {
        private final TriggerKind triggerKind;
        private final Character triggerCharacter;

        public Context(@NonNull TriggerKind triggerKind, @NullAllowed Character triggerCharacter) {
            this.triggerKind = triggerKind;
            this.triggerCharacter = triggerCharacter;
        }

        @NonNull
        public TriggerKind getTriggerKind() {
            return this.triggerKind;
        }

        @CheckForNull
        public Character getTriggerCharacter() {
            return this.triggerCharacter;
        }
    }

    public static enum TriggerKind {
        Invoked,
        TriggerCharacter,
        ContentChange;

    }

    public static final class ParameterInformation {
        private final String label;
        private final boolean isActive;
        private final String documentation;

        private ParameterInformation(String label, boolean isActive, String documentation) {
            this.label = label;
            this.isActive = isActive;
            this.documentation = documentation;
        }

        @NonNull
        public String getLabel() {
            return this.label;
        }

        public boolean isActive() {
            return this.isActive;
        }

        @CheckForNull
        public String getDocumentation() {
            return this.documentation;
        }
    }
}

