/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.InvalidException;
import org.netbeans.Module;
import org.netbeans.NetigsoModule;
import org.netbeans.Util;
import org.openide.modules.Dependency;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

class ModuleData {
    private static final Module.PackageExport[] ZERO_PACKAGE_ARRAY = new Module.PackageExport[0];
    private static final String[] ZERO_STRING_ARRAY = new String[0];
    private final String codeName;
    private final String codeNameBase;
    private final int codeNameRelease;
    private final String implVersion;
    private final String buildVersion;
    private final Set<String> friendNames;
    private final SpecificationVersion specVers;
    private final Module.PackageExport[] publicPackages;
    private final String[] provides;
    private final Dependency[] dependencies;
    private final Set<String> coveredPackages;
    private final String agentClass;
    private final String fragmentHostCodeName;

    ModuleData(Manifest mf, Module forModule) throws InvalidException {
        Attributes attr = mf.getMainAttributes();
        this.codeName = attr.getValue("OpenIDE-Module");
        if (this.codeName == null) {
            InvalidException e = new InvalidException("Not a module: no OpenIDE-Module tag in manifest of " + String.valueOf(this), mf);
            Exceptions.attachLocalizedMessage((Throwable)e, (String)NbBundle.getMessage(Module.class, (String)"EXC_not_a_module", (Object)this.toString()));
            throw e;
        }
        forModule.assignData(this);
        try {
            boolean verifyCNBs;
            if (this.codeName.indexOf(44) != -1) {
                throw new InvalidException("Illegal code name syntax parsing OpenIDE-Module: " + this.codeName);
            }
            Object[] cnParse = Util.parseCodeName(this.codeName);
            this.codeNameBase = (String)cnParse[0];
            Set<Dependency> deps = forModule.getManager().loadDependencies(this.codeNameBase);
            boolean bl = verifyCNBs = deps == null;
            if (verifyCNBs) {
                Dependency.create((int)1, (String)this.codeName);
            }
            int n = this.codeNameRelease = cnParse[1] != null ? (Integer)cnParse[1] : -1;
            if (cnParse[2] != null) {
                throw new NumberFormatException(this.codeName);
            }
            String specVersS = attr.getValue("OpenIDE-Module-Specification-Version");
            if (specVersS != null) {
                try {
                    this.specVers = new SpecificationVersion(specVersS);
                }
                catch (NumberFormatException nfe) {
                    throw (InvalidException)new InvalidException("While parsing OpenIDE-Module-Specification-Version: " + nfe.toString()).initCause(nfe);
                }
            } else {
                this.specVers = null;
            }
            String iv = attr.getValue("OpenIDE-Module-Implementation-Version");
            this.implVersion = iv == null ? "" : iv;
            String bld = attr.getValue("OpenIDE-Module-Build-Version");
            this.buildVersion = bld == null ? this.implVersion : bld;
            this.provides = this.computeProvides(forModule, attr, verifyCNBs, false);
            String exportsS = attr.getValue("OpenIDE-Module-Public-Packages");
            if (exportsS != null) {
                if (exportsS.trim().equals("-")) {
                    this.publicPackages = ZERO_PACKAGE_ARRAY;
                } else {
                    StringTokenizer tok = new StringTokenizer(exportsS, ", ");
                    ArrayList<Module.PackageExport> exports = new ArrayList<Module.PackageExport>(Math.max(tok.countTokens(), 1));
                    while (tok.hasMoreTokens()) {
                        String pkg;
                        String piece = tok.nextToken();
                        if (piece.endsWith(".*")) {
                            pkg = piece.substring(0, piece.length() - 2);
                            if (verifyCNBs) {
                                Dependency.create((int)1, (String)pkg);
                            }
                            if (pkg.lastIndexOf(47) != -1) {
                                throw new IllegalArgumentException("Illegal OpenIDE-Module-Public-Packages: " + exportsS);
                            }
                            exports.add(new Module.PackageExport(pkg.replace('.', '/') + "/", false));
                            continue;
                        }
                        if (piece.endsWith(".**")) {
                            pkg = piece.substring(0, piece.length() - 3);
                            if (verifyCNBs) {
                                Dependency.create((int)1, (String)pkg);
                            }
                            if (pkg.lastIndexOf(47) != -1) {
                                throw new IllegalArgumentException("Illegal OpenIDE-Module-Public-Packages: " + exportsS);
                            }
                            exports.add(new Module.PackageExport(pkg.replace('.', '/') + "/", true));
                            continue;
                        }
                        throw new IllegalArgumentException("Illegal OpenIDE-Module-Public-Packages: " + exportsS);
                    }
                    if (exports.isEmpty()) {
                        throw new IllegalArgumentException("Illegal OpenIDE-Module-Public-Packages: " + exportsS);
                    }
                    this.publicPackages = exports.toArray(new Module.PackageExport[0]);
                }
            } else {
                Util.err.log(Level.WARNING, "module {0} does not declare OpenIDE-Module-Public-Packages in its manifest, so all packages are considered public by default: http://bits.netbeans.org/dev/javadoc/org-openide-modules/org/openide/modules/doc-files/api.html#how-vers", this.codeNameBase);
                this.publicPackages = null;
            }
            HashSet<String> set = null;
            String friends = attr.getValue("OpenIDE-Module-Friends");
            if (friends != null) {
                StringTokenizer tok = new StringTokenizer(friends, ", ");
                set = new HashSet<String>();
                while (tok.hasMoreTokens()) {
                    String piece = tok.nextToken();
                    if (piece.indexOf(47) != -1) {
                        throw new IllegalArgumentException("May specify only module code name bases in OpenIDE-Module-Friends, not major release versions: " + piece);
                    }
                    if (verifyCNBs) {
                        Dependency.create((int)1, (String)piece);
                    }
                    set.add(piece);
                }
                if (set.isEmpty()) {
                    throw new IllegalArgumentException("Empty OpenIDE-Module-Friends: " + friends);
                }
                if (this.publicPackages == null || this.publicPackages.length == 0) {
                    throw new IllegalArgumentException("No use specifying OpenIDE-Module-Friends without any public packages: " + friends);
                }
            }
            this.friendNames = set;
            this.dependencies = this.initDeps(forModule, deps, attr);
            String classLoader = attr.getValue("OpenIDE-Module-Fragment-Host");
            if (classLoader != null) {
                Object[] clParse = Util.parseCodeName(classLoader);
                String frag = (String)clParse[0];
                if (frag != null && (frag = frag.trim()).isEmpty()) {
                    frag = null;
                }
                this.fragmentHostCodeName = frag;
                if (verifyCNBs && frag != null) {
                    Dependency.create((int)1, (String)this.fragmentHostCodeName);
                }
            } else {
                this.fragmentHostCodeName = null;
            }
        }
        catch (IllegalArgumentException iae) {
            throw (InvalidException)new InvalidException("While parsing " + this.codeName + " a dependency attribute: " + iae.toString()).initCause(iae);
        }
        this.coveredPackages = new HashSet<String>();
        this.agentClass = attr.getValue("Agent-Class");
    }

    ModuleData(Manifest mf, NetigsoModule m) throws InvalidException {
        String symbName = ModuleData.getMainAttribute(mf, "Bundle-SymbolicName");
        if (symbName == null) {
            throw new InvalidException("Not an OSGi bundle: " + String.valueOf((Object)m));
        }
        m.assignData(this);
        this.codeName = symbName.replace('-', '_');
        int slash = this.codeName.lastIndexOf(47);
        this.codeNameRelease = slash != -1 ? Integer.parseInt(symbName.substring(slash + 1)) : -1;
        String v = ModuleData.getMainAttribute(mf, "Bundle-Version");
        if (v == null) {
            Logger.getLogger(ModuleData.class.getName()).log(Level.WARNING, "No Bundle-Version for {0}", (Object)m);
            v = "0.0";
            this.specVers = new SpecificationVersion("0.0");
        } else {
            this.specVers = ModuleData.computeVersion(v);
        }
        this.codeNameBase = this.codeName;
        String iv = ModuleData.getMainAttribute(mf, "OpenIDE-Module-Implementation-Version");
        this.implVersion = iv == null ? v : iv;
        String bld = ModuleData.getMainAttribute(mf, "OpenIDE-Module-Build-Version");
        this.buildVersion = bld == null ? this.implVersion : bld;
        this.friendNames = Collections.emptySet();
        this.publicPackages = null;
        this.provides = this.computeProvides(m, mf.getMainAttributes(), false, true);
        this.dependencies = this.computeImported(mf.getMainAttributes());
        this.coveredPackages = new HashSet<String>();
        this.agentClass = ModuleData.getMainAttribute(mf, "Agent-Class");
        this.fragmentHostCodeName = null;
    }

    ModuleData(ObjectInput dis) throws IOException {
        try {
            this.codeName = dis.readUTF();
            this.codeNameBase = dis.readUTF();
            this.codeNameRelease = dis.readInt();
            this.coveredPackages = this.readStrings(dis, new HashSet(), true);
            this.dependencies = (Dependency[])dis.readObject();
            this.implVersion = dis.readUTF();
            this.buildVersion = dis.readUTF();
            this.provides = this.readStrings(dis);
            this.friendNames = this.readStrings(dis, new HashSet(), false);
            this.specVers = new SpecificationVersion(dis.readUTF());
            this.publicPackages = Module.PackageExport.read(dis);
            this.agentClass = dis.readUTF();
            String s = dis.readUTF();
            if (s != null) {
                s = s.trim();
            }
            this.fragmentHostCodeName = s == null || s.isEmpty() ? null : s;
        }
        catch (ClassNotFoundException cnfe) {
            throw new IOException(cnfe);
        }
    }

    void write(ObjectOutput dos) throws IOException {
        dos.writeUTF(this.codeName);
        dos.writeUTF(this.codeNameBase);
        dos.writeInt(this.codeNameRelease);
        this.writeStrings((DataOutput)dos, this.coveredPackages);
        dos.writeObject(this.dependencies);
        dos.writeUTF(this.implVersion);
        dos.writeUTF(this.buildVersion);
        this.writeStrings(dos, this.provides);
        this.writeStrings((DataOutput)dos, this.friendNames);
        dos.writeUTF(this.specVers != null ? this.specVers.toString() : "0");
        Module.PackageExport.write(dos, this.publicPackages);
        dos.writeUTF(this.agentClass == null ? "" : this.agentClass);
        dos.writeUTF(this.fragmentHostCodeName == null ? "" : this.fragmentHostCodeName);
    }

    private Dependency[] computeImported(Attributes attr) {
        String recomm;
        String pkgs = attr.getValue("Import-Package");
        ArrayList arr = null;
        if (pkgs != null) {
            arr = new ArrayList();
            StringTokenizer tok = ModuleData.createTokenizer(pkgs);
            while (tok.hasMoreElements()) {
                String dep = ModuleData.beforeSemicolon(tok);
                arr.addAll(Dependency.create((int)7, (String)dep));
            }
        }
        if ((recomm = attr.getValue("Require-Bundle")) != null) {
            if (arr == null) {
                arr = new ArrayList();
            }
            StringTokenizer tok = ModuleData.createTokenizer(recomm);
            while (tok.hasMoreElements()) {
                String dep = ModuleData.beforeSemicolon(tok);
                arr.addAll(Dependency.create((int)7, (String)("cnb." + dep)));
            }
        }
        return arr == null ? null : arr.toArray(new Dependency[0]);
    }

    private static StringTokenizer createTokenizer(String osgiDep) {
        int second;
        int first;
        while ((first = ((String)osgiDep).indexOf(34)) != -1 && (second = ((String)osgiDep).indexOf(34, first + 1)) != -1) {
            osgiDep = ((String)osgiDep).substring(0, first - 1) + ((String)osgiDep).substring(second + 1);
        }
        return new StringTokenizer((String)osgiDep, ",");
    }

    private static String beforeSemicolon(StringTokenizer tok) {
        String dep = tok.nextToken().trim();
        int semicolon = dep.indexOf(59);
        if (semicolon >= 0) {
            dep = dep.substring(0, semicolon);
        }
        return dep.replace('-', '_');
    }

    private String[] computeExported(boolean useOSGi, Collection<String> arr, Attributes attr) {
        if (!useOSGi) {
            return arr.toArray(ZERO_STRING_ARRAY);
        }
        String pkgs = attr.getValue("Export-Package");
        if (pkgs == null) {
            return arr.toArray(ZERO_STRING_ARRAY);
        }
        StringTokenizer tok = ModuleData.createTokenizer(pkgs);
        while (tok.hasMoreElements()) {
            arr.add(ModuleData.beforeSemicolon(tok));
        }
        return arr.toArray(ZERO_STRING_ARRAY);
    }

    private String[] computeProvides(Module forModule, Attributes attr, boolean verifyCNBs, boolean useOSGi) throws InvalidException, IllegalArgumentException {
        String[] additionalProvides;
        LinkedHashSet<String> arr = new LinkedHashSet<String>();
        String providesS = attr.getValue("OpenIDE-Module-Provides");
        if (providesS != null) {
            StringTokenizer tok = new StringTokenizer(providesS, ", ");
            int expCount = tok.countTokens();
            while (tok.hasMoreTokens()) {
                String provide = tok.nextToken();
                if (provide.indexOf(44) != -1) {
                    throw new InvalidException("Illegal code name syntax parsing OpenIDE-Module-Provides: " + provide);
                }
                if (verifyCNBs) {
                    Dependency.create((int)1, (String)provide);
                }
                if (provide.lastIndexOf(47) != -1) {
                    throw new IllegalArgumentException("Illegal OpenIDE-Module-Provides: " + provide);
                }
                arr.add(provide);
            }
            if (arr.size() != expCount) {
                throw new IllegalArgumentException("Duplicate entries in OpenIDE-Module-Provides: " + providesS);
            }
        }
        if ((additionalProvides = forModule.getManager().refineProvides(forModule)) != null) {
            arr.addAll(Arrays.asList(additionalProvides));
        }
        arr.add("cnb." + this.getCodeNameBase());
        return this.computeExported(useOSGi, arr, attr);
    }

    private Dependency[] initDeps(Module forModule, Set<?> knownDeps, Attributes attr) throws IllegalStateException, IllegalArgumentException {
        if (knownDeps != null) {
            return knownDeps.toArray(new Dependency[0]);
        }
        HashSet<Dependency> deps = new HashSet<Dependency>(20);
        Set openideDeps = Dependency.create((int)4, (String)attr.getValue("OpenIDE-Module-IDE-Dependencies"));
        if (!openideDeps.isEmpty()) {
            Dependency d = (Dependency)openideDeps.iterator().next();
            String name = d.getName();
            if (!name.startsWith("IDE/")) {
                throw new IllegalStateException("Weird IDE dep: " + name);
            }
            deps.addAll(Dependency.create((int)1, (String)("org.openide/" + name.substring(4) + " > " + d.getVersion())));
            if (deps.size() != 1) {
                throw new IllegalStateException("Should be singleton: " + String.valueOf(deps));
            }
            Util.err.log(Level.WARNING, "the module {0} uses OpenIDE-Module-IDE-Dependencies which is deprecated. See http://openide.netbeans.org/proposals/arch/modularize.html", this.codeNameBase);
        }
        deps.addAll(Dependency.create((int)3, (String)attr.getValue("OpenIDE-Module-Java-Dependencies")));
        deps.addAll(Dependency.create((int)1, (String)attr.getValue("OpenIDE-Module-Module-Dependencies")));
        String pkgdeps = attr.getValue("OpenIDE-Module-Package-Dependencies");
        if (pkgdeps != null) {
            deps.addAll(Dependency.create((int)2, (String)pkgdeps));
        }
        deps.addAll(Dependency.create((int)5, (String)attr.getValue("OpenIDE-Module-Requires")));
        deps.addAll(Dependency.create((int)6, (String)attr.getValue("OpenIDE-Module-Needs")));
        deps.addAll(Dependency.create((int)7, (String)attr.getValue("OpenIDE-Module-Recommends")));
        forModule.refineDependencies(deps);
        return deps.toArray(new Dependency[0]);
    }

    final String getFragmentHostCodeName() {
        return this.fragmentHostCodeName;
    }

    final String getCodeName() {
        return this.codeName;
    }

    final String getCodeNameBase() {
        return this.codeNameBase;
    }

    final int getCodeNameRelease() {
        return this.codeNameRelease;
    }

    final String[] getProvides() {
        return this.provides;
    }

    final SpecificationVersion getSpecificationVersion() {
        return this.specVers;
    }

    final Module.PackageExport[] getPublicPackages() {
        return this.publicPackages;
    }

    final Set<String> getFriendNames() {
        return this.friendNames;
    }

    final Dependency[] getDependencies() {
        return this.dependencies;
    }

    final String getBuildVersion() {
        return this.buildVersion.isEmpty() ? null : this.buildVersion;
    }

    final String getImplementationVersion() {
        return this.implVersion.isEmpty() ? null : this.implVersion;
    }

    void registerCoveredPackages(Set<String> known) {
        assert (this.coveredPackages.isEmpty());
        this.coveredPackages.addAll(known);
    }

    Set<String> getCoveredPackages() {
        return this.coveredPackages.isEmpty() ? null : this.coveredPackages;
    }

    private <T extends Collection<String>> T readStrings(DataInput dis, T set, boolean returnEmpty) throws IOException {
        int cnt = dis.readInt();
        if (!returnEmpty && cnt == 0) {
            return null;
        }
        while (cnt-- > 0) {
            set.add((String)dis.readUTF());
        }
        return set;
    }

    private String[] readStrings(ObjectInput dis) throws IOException {
        ArrayList arr = new ArrayList();
        this.readStrings(dis, arr, false);
        return arr.toArray(new String[0]);
    }

    private void writeStrings(DataOutput dos, Collection<String> set) throws IOException {
        if (set == null) {
            dos.writeInt(0);
            return;
        }
        dos.writeInt(set.size());
        for (String s : set) {
            dos.writeUTF(s);
        }
    }

    private void writeStrings(ObjectOutput dos, String[] provides) throws IOException {
        this.writeStrings((DataOutput)dos, Arrays.asList(provides));
    }

    private static String getMainAttribute(Manifest manifest, String attr) {
        String s = manifest.getMainAttributes().getValue(attr);
        if (s == null) {
            return null;
        }
        int semicolon = s.indexOf(59);
        if (semicolon == -1) {
            return s;
        }
        return s.substring(0, semicolon);
    }

    private static SpecificationVersion computeVersion(String v) {
        int pos = -1;
        for (int i = 0; i < 3; ++i) {
            if ((pos = v.indexOf(46, pos + 1)) != -1) continue;
            return new SpecificationVersion(v);
        }
        return new SpecificationVersion(v.substring(0, pos));
    }

    final String getAgentClass() {
        return this.agentClass == null || this.agentClass.isEmpty() ? null : this.agentClass;
    }
}

