/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.editor;

import java.util.regex.Pattern;
import org.netbeans.lib.editor.util.CharSequenceUtilities;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.css.editor.module.CssModuleSupport;
import org.netbeans.modules.css.editor.module.spi.Browser;
import org.netbeans.modules.css.lib.api.Node;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.web.common.api.LexerUtils;
import org.openide.filesystems.FileObject;

public final class Css3Utils {
    public static char FILE_SEPARATOR = (char)47;
    public static final Pattern URI_PATTERN = Pattern.compile("url\\(\\s*(.*)\\s*\\)");

    public static OffsetRange getOffsetRange(Node node) {
        int from = node.from();
        int to = node.to();
        if (from < 0 || to < 0) {
            return OffsetRange.NONE;
        }
        if (from > to) {
            return OffsetRange.NONE;
        }
        return new OffsetRange(from, to);
    }

    public static OffsetRange getDocumentOffsetRange(Node node, Snapshot snapshot) {
        int from = node.from();
        int to = node.to();
        if (from < 0 || to < 0) {
            return OffsetRange.NONE;
        }
        if (from > to) {
            return OffsetRange.NONE;
        }
        int origFrom = snapshot.getOriginalOffset(from);
        int origTo = snapshot.getOriginalOffset(to);
        if (origFrom < 0 || origTo < 0) {
            return OffsetRange.NONE;
        }
        if (origFrom > origTo) {
            return OffsetRange.NONE;
        }
        return new OffsetRange(origFrom, origTo);
    }

    public static boolean isValidOffsetRange(OffsetRange range) {
        return range.getStart() != -1 && range.getEnd() != -1;
    }

    public static OffsetRange getValidOrNONEOffsetRange(OffsetRange range) {
        return Css3Utils.isValidOffsetRange(range) ? range : OffsetRange.NONE;
    }

    public static boolean containsGeneratedCode(CharSequence text) {
        return CharSequenceUtilities.indexOf((CharSequence)text, (CharSequence)"@@@") != -1;
    }

    public static boolean isVendorSpecificProperty(CharSequence propertyName) {
        return CharSequenceUtilities.startsWith((CharSequence)propertyName, (CharSequence)"_") || CharSequenceUtilities.startsWith((CharSequence)propertyName, (CharSequence)"-");
    }

    public static boolean isVendorSpecificPropertyValue(FileObject file, CharSequence value) {
        if (value == null) {
            throw new NullPointerException();
        }
        if (value.length() == 0) {
            return false;
        }
        for (Browser b : CssModuleSupport.getBrowsers(file)) {
            if (!LexerUtils.startsWith((CharSequence)value, (CharSequence)b.getVendorSpecificPropertyPrefix(), (boolean)true, (boolean)false)) continue;
            return true;
        }
        return false;
    }
}

