/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.text.indent;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.editor.document.AtomicLockDocument;
import org.netbeans.api.editor.document.LineDocument;
import org.netbeans.api.editor.document.LineDocumentUtils;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.xml.lexer.XMLTokenId;
import org.netbeans.editor.Utilities;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.editor.indent.api.IndentUtils;
import org.netbeans.modules.editor.indent.spi.Context;
import org.netbeans.modules.xml.text.folding.TokenElement;
import org.openide.util.CharSequences;
import org.openide.util.Exceptions;

public class XMLLexerFormatter {
    private static final Logger logger = Logger.getLogger(XMLLexerFormatter.class.getName());
    private static final String SPACE_PRESERVE = "\"preserve\"";
    private static final String SPACE_DEFAULT = "\"default\"";
    private static final String XML_SPACE_ATTRIBUTE = "xml:space";
    private static final int SPACE_PRESERVE_LEN = "\"preserve\"".length();
    private static final int SPACE_DEFAULT_LEN = "\"default\"".length();
    private static final int XML_SPACE_ATTRIBUTE_LEN = "xml:space".length();
    private final LanguagePath languagePath;
    private int spacesPerTab = 4;
    private Stack<TokenIndent> stack = new Stack();
    private boolean settingSpaceValue = false;
    private boolean preserveWhitespace = false;
    private int indentLevel;
    private int firstAttributeIndent;
    private boolean wasNewline;
    private boolean tokenInSelectionRange;
    private TokenSequence<XMLTokenId> tokenSequence;
    private LineDocument basedoc;
    private int tagIndent;
    private List<TokenIndent> tags = new ArrayList<TokenIndent>();
    private int currentTokensSize;
    private Token<XMLTokenId> token;
    private int startOffset;
    private int endOffset;
    private boolean contentPresent;
    private boolean onlyTags;
    private int lineCount;
    private int[] lineSizes = new int[10];
    private int counter = 1;

    public XMLLexerFormatter(LanguagePath languagePath) {
        this.languagePath = languagePath;
    }

    protected LanguagePath supportedLanguagePath() {
        return this.languagePath;
    }

    public void reformat(Context context, int startOffset, int endOffset) throws BadLocationException {
        Document doc = context.document();
        ((AtomicLockDocument)LineDocumentUtils.asRequired((Document)doc, AtomicLockDocument.class)).runAtomic(() -> this.doReformat((LineDocument)doc, startOffset, endOffset));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LineDocument doReformat(LineDocument doc, int startOffset, int endOffset) {
        this.spacesPerTab = IndentUtils.indentLevelSize((Document)doc);
        try {
            List<TokenIndent> tags = this.getTags(doc, startOffset, endOffset);
            for (int i = tags.size() - 1; i >= 0; --i) {
                TokenIndent ti = tags.get(i);
                if (ti.isPreserveIndent()) continue;
                this.changePrettyText(doc, ti);
            }
        }
        catch (BadLocationException badLocationException) {
        }
        catch (IOException iOException) {
        }
        return doc;
    }

    private void changePrettyText(LineDocument doc, TokenIndent tag) throws BadLocationException {
        int so = tag.getStartOffset();
        int spaces = tag.getIndentLevel();
        boolean noNewline = tag.isNoNewline();
        String newIndentText = IndentUtils.createIndentString((Document)doc, (int)spaces);
        int previousEndOffset = LineDocumentUtils.getPreviousNonWhitespace((LineDocument)doc, (int)so) + 1;
        CharSequence temp = DocumentUtilities.getText((Document)doc, (int)previousEndOffset, (int)(so - previousEndOffset));
        if (noNewline || so == 0 || CharSequences.indexOf((CharSequence)temp, (CharSequence)"\n") != -1) {
            int rowStart;
            String currentIndent;
            int i = LineDocumentUtils.getLineFirstNonWhitespace((LineDocument)doc, (int)so);
            if (i == -1) {
                i = LineDocumentUtils.getLineEnd((LineDocument)doc, (int)so);
            }
            if (!(currentIndent = doc.getText(rowStart = LineDocumentUtils.getLineStart((LineDocument)doc, (int)so), i - rowStart)).equals(newIndentText)) {
                if (so < i) {
                    so = i;
                }
                doc.insertString(so, newIndentText, null);
                doc.remove(rowStart, i - rowStart);
            }
        } else {
            doc.insertString(so, "\n" + newIndentText, null);
        }
    }

    private void outsideAttributes() {
        this.firstAttributeIndent = -1;
        this.settingSpaceValue = false;
    }

    private void startTag(CharSequence image) throws BadLocationException {
        CharSequence tagName = image.subSequence(1, image.length());
        int begin = this.currentTokensSize;
        int end = begin + image.length();
        this.updateIndent(true, -1, this.preserveWhitespace);
        TokenIndent indent = new TokenIndent(tagName, this.preserveWhitespace, begin, this.indentLevel);
        this.tagIndent = this.indentLevel;
        this.stack.push(indent);
        if (this.tokenInSelectionRange && (this.wasNewline || this.onlyTags)) {
            this.tags.add(indent);
        }
        this.onlyTags = true;
    }

    private void tagClose(CharSequence image) {
        if (this.wasNewline && this.tokenInSelectionRange) {
            this.tags.add(new TokenIndent(false, this.tokenSequence.offset(), this.tagIndent));
        }
        this.contentPresent = false;
    }

    private int updateIndent(boolean increase, int targetLevel, boolean preserveAfter) {
        if (preserveAfter) {
            return this.indentLevel;
        }
        int save = this.indentLevel;
        if (this.tokenInSelectionRange) {
            if (targetLevel != -1) {
                this.indentLevel = save = targetLevel;
            }
            this.indentLevel = increase ? (this.indentLevel += this.spacesPerTab) : Math.max(-this.spacesPerTab, this.indentLevel - this.spacesPerTab);
            return save;
        }
        try {
            this.indentLevel = Utilities.getVisualColumn((LineDocument)this.basedoc, (int)LineDocumentUtils.getNextNonWhitespace((LineDocument)this.basedoc, (int)LineDocumentUtils.getLineStart((LineDocument)this.basedoc, (int)this.tokenSequence.offset())));
            if (!increase) {
                this.indentLevel = Math.max(-this.spacesPerTab, this.indentLevel - this.spacesPerTab);
            }
            return save;
        }
        catch (BadLocationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return this.indentLevel;
        }
    }

    private static boolean startsWith(CharSequence text, CharSequence s) {
        int l = s.length();
        if (text.length() < l) {
            return false;
        }
        return XMLLexerFormatter.startsWith0(text, l, s);
    }

    private static boolean startsWith0(CharSequence text, int l, CharSequence s) {
        for (int i = 0; i < l; ++i) {
            if (text.charAt(i) == s.charAt(i)) continue;
            return false;
        }
        return true;
    }

    private static boolean equals(CharSequence s1, CharSequence s2) {
        return s1.length() == s2.length() && XMLLexerFormatter.startsWith0(s1, s1.length(), s2);
    }

    private void endTag(CharSequence image, boolean selfClosed) throws BadLocationException {
        int tagLevel;
        int begin = this.currentTokensSize;
        int end = begin + image.length();
        boolean preserveThis = this.preserveWhitespace;
        boolean preservingWhitespaceOnClose = this.preserveWhitespace;
        CharSequence tagName = image.subSequence(2, image.length());
        int newIndentLevel = -1;
        TokenIndent myIndent = null;
        for (int i = this.stack.size() - 1; newIndentLevel < 0 && i >= 0; --i) {
            TokenIndent el = (TokenIndent)this.stack.get(i);
            if (!selfClosed && !XMLLexerFormatter.equals(tagName, el.getName())) continue;
            myIndent = el;
            newIndentLevel = el.getIndentLevel();
            preservingWhitespaceOnClose = el.isPreserveIndent();
            this.stack.subList(i, this.stack.size()).clear();
        }
        this.tagIndent = tagLevel = this.updateIndent(false, newIndentLevel, preservingWhitespaceOnClose);
        if (this.tokenInSelectionRange && !preserveThis) {
            boolean indent = this.wasNewline;
            if (!indent && !selfClosed && this.onlyTags) {
                int openStart;
                indent = true;
                int start = LineDocumentUtils.getLineStart((LineDocument)this.basedoc, (int)this.tokenSequence.offset());
                if (myIndent != null && start <= (openStart = myIndent.getStartOffset()) && !this.tags.isEmpty()) {
                    int last = this.tags.get(this.tags.size() - 1).serial;
                    boolean bl = indent = myIndent.serial < last;
                }
            }
            if (indent) {
                this.tags.add(new TokenIndent(preserveThis, begin, tagLevel));
            }
        }
        this.preserveWhitespace = preservingWhitespaceOnClose;
        this.contentPresent = true;
        this.onlyTags = true;
    }

    private void attributeName() throws BadLocationException {
        CharSequence tt = this.token.text();
        boolean bl = this.settingSpaceValue = tt.length() == XML_SPACE_ATTRIBUTE_LEN && XMLLexerFormatter.startsWith0(tt, XML_SPACE_ATTRIBUTE_LEN, XML_SPACE_ATTRIBUTE);
        if (this.firstAttributeIndent == -1) {
            this.firstAttributeIndent = this.tagIndent;
            if (this.wasNewline) {
                this.firstAttributeIndent += this.spacesPerTab;
            } else {
                TokenIndent tagIndent = this.stack.peek();
                int current = Utilities.getVisualColumn((LineDocument)this.basedoc, (int)this.tokenSequence.offset());
                if (tagIndent == null) {
                    this.firstAttributeIndent = current;
                } else {
                    int proposed = this.firstAttributeIndent + (tagIndent.tagName.length() + 1 + 1);
                    this.firstAttributeIndent = Math.max(current, proposed);
                }
            }
        }
        if (this.wasNewline) {
            TokenElement.TokenType tokenType = TokenElement.TokenType.TOKEN_ATTR_NAME;
            int attrIndent = this.firstAttributeIndent;
            if (this.tokenInSelectionRange) {
                this.tags.add(new TokenIndent(false, this.tokenSequence.offset(), attrIndent));
            }
        }
    }

    private void attributeValue() {
        if (this.settingSpaceValue) {
            CharSequence s = this.token.text();
            if (s.length() == SPACE_PRESERVE_LEN && XMLLexerFormatter.startsWith0(s, SPACE_PRESERVE_LEN, SPACE_PRESERVE)) {
                this.preserveWhitespace = true;
            } else if (s.length() == SPACE_DEFAULT_LEN && XMLLexerFormatter.startsWith0(s, SPACE_DEFAULT_LEN, SPACE_DEFAULT)) {
                this.preserveWhitespace = false;
            }
            this.settingSpaceValue = false;
        }
    }

    private void text(CharSequence image, int indentLineStart) throws BadLocationException {
        boolean intersectsWithRange;
        int lastNewline = XMLLexerFormatter.lastIndexOf(image, '\n');
        int currentOffset = this.tokenSequence.offset();
        int tokenStart = this.tokenSequence.offset();
        int tokenEnd = tokenStart + image.length();
        boolean bl = intersectsWithRange = tokenStart <= this.startOffset && tokenEnd > this.startOffset || tokenEnd >= this.endOffset && tokenStart < this.endOffset || tokenStart >= this.startOffset && tokenEnd <= this.endOffset;
        if (lastNewline == -1 || this.preserveWhitespace || !intersectsWithRange) {
            int nonWhitePos = LineDocumentUtils.getNextNonWhitespace((LineDocument)this.basedoc, (int)(currentOffset + Math.max(0, lastNewline)), (int)(currentOffset + image.length()));
            this.contentPresent |= nonWhitePos > -1;
            this.wasNewline &= nonWhitePos == -1;
            this.onlyTags &= nonWhitePos == -1;
            return;
        }
        this.splitLines(image);
        int nonWhiteStart = -1;
        for (int lno = indentLineStart; lno < this.lineCount; ++lno) {
            int lineEnd = (currentOffset += lno == 0 ? 0 : this.lineSizes[lno - 1] + 1) + this.lineSizes[lno];
            if ((nonWhiteStart = LineDocumentUtils.getNextNonWhitespace((LineDocument)this.basedoc, (int)currentOffset, (int)lineEnd)) < this.startOffset || nonWhiteStart > this.endOffset) continue;
            this.tags.add(new TokenIndent(new TokenElement(TokenElement.TokenType.TOKEN_CHARACTER_DATA, ((XMLTokenId)this.token.id()).name(), nonWhiteStart, lineEnd, this.indentLevel + this.spacesPerTab), false, nonWhiteStart, this.indentLevel + this.spacesPerTab));
        }
        this.wasNewline = nonWhiteStart == -1;
        this.contentPresent = !this.wasNewline;
        this.onlyTags &= !this.contentPresent;
    }

    private static int lastIndexOf(CharSequence s, char c) {
        for (int i = s.length() - 1; i >= 0; --i) {
            if (s.charAt(i) != c) continue;
            return i;
        }
        return -1;
    }

    private void splitLines(CharSequence s) {
        this.lineCount = 0;
        int len = s.length();
        int l = 0;
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (c == '\n') {
                this.addLine(l);
                l = 0;
                continue;
            }
            ++l;
        }
        this.addLine(l);
    }

    private void addLine(int len) {
        if (this.lineSizes.length <= this.lineCount) {
            int[] lines = new int[this.lineSizes.length * 2];
            System.arraycopy(this.lineSizes, 0, lines, 0, this.lineSizes.length);
            this.lineSizes = lines;
        }
        this.lineSizes[this.lineCount++] = len;
    }

    private List<TokenIndent> getTags(LineDocument basedoc, int startOffset, int endOffset) throws BadLocationException, IOException {
        this.basedoc = basedoc;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        this.indentLevel = -this.spacesPerTab;
        List[] result = new List[1];
        Exception[] ble = new Exception[1];
        basedoc.render(() -> {
            try {
                result[0] = this.getTagsLocked(startOffset, endOffset);
            }
            catch (IOException | BadLocationException ex) {
                ble[0] = ex;
            }
        });
        if (ble[0] != null) {
            if (ble[0] instanceof BadLocationException) {
                throw (BadLocationException)ble[0];
            }
            if (ble[0] instanceof IOException) {
                throw (IOException)ble[0];
            }
            throw new IOException(ble[0]);
        }
        return result[0];
    }

    private List<TokenIndent> getTagsLocked(int startOffset, int endOffset) throws BadLocationException, IOException {
        TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)this.basedoc);
        this.tokenSequence = tokenHierarchy.tokenSequence();
        this.token = this.tokenSequence.token();
        if (this.token != null && this.token.id() == XMLTokenId.TEXT && this.tokenSequence.moveNext()) {
            this.token = this.tokenSequence.token();
        }
        this.currentTokensSize = 0;
        this.firstAttributeIndent = -1;
        this.wasNewline = false;
        while (this.tokenSequence.moveNext()) {
            int indentLineStart = 1;
            this.token = this.tokenSequence.token();
            XMLTokenId tokenId = (XMLTokenId)this.token.id();
            CharSequence image = this.token.text();
            if (this.tokenSequence.offset() > endOffset) break;
            this.tokenInSelectionRange = this.tokenSequence.offset() >= startOffset || this.tokenSequence.offset() + this.token.length() > endOffset;
            switch (tokenId) {
                case TAG: {
                    int len = image.length();
                    this.firstAttributeIndent = -1;
                    if (image.charAt(len - 1) == '>') {
                        if (len == 2) {
                            this.endTag(image, true);
                            break;
                        }
                        this.tagClose(image);
                        break;
                    }
                    if (XMLLexerFormatter.startsWith(image, "</")) {
                        this.endTag(image, false);
                    } else {
                        this.startTag(image);
                    }
                    this.outsideAttributes();
                    break;
                }
                case PI_START: {
                    this.updateIndent(true, -1, this.preserveWhitespace);
                    if (!this.tokenInSelectionRange || this.preserveWhitespace) break;
                    TokenElement tag = new TokenElement(TokenElement.TokenType.TOKEN_PI_START_TAG, tokenId.name(), this.tokenSequence.offset(), this.tokenSequence.offset() + this.token.length(), this.indentLevel);
                    TokenIndent ti = new TokenIndent(this.preserveWhitespace, this.tokenSequence.offset(), this.indentLevel);
                    ti.markNoNewline();
                    this.tags.add(ti);
                    break;
                }
                case PI_END: {
                    int l = this.updateIndent(false, -1, this.preserveWhitespace);
                    if (!this.wasNewline || !this.tokenInSelectionRange) break;
                    this.tags.add(new TokenIndent(false, this.tokenSequence.offset(), l));
                    break;
                }
                case WS: {
                    int lastNewline = XMLLexerFormatter.lastIndexOf(image, '\n');
                    if (lastNewline == -1) break;
                    this.wasNewline = true;
                    break;
                }
                case PI_CONTENT: {
                    indentLineStart = 0;
                }
                case TEXT: {
                    this.text(image, indentLineStart);
                    break;
                }
                case BLOCK_COMMENT: {
                    int currentOffset = this.tokenSequence.offset();
                    this.splitLines(image);
                    int lineStart = LineDocumentUtils.getLineStart((LineDocument)this.basedoc, (int)currentOffset);
                    if (lineStart < currentOffset && LineDocumentUtils.getPreviousNonWhitespace((LineDocument)this.basedoc, (int)currentOffset, (int)lineStart) > -1) break;
                    int lastLineStart = LineDocumentUtils.getLineStart((LineDocument)this.basedoc, (int)(currentOffset + this.token.length() - 1));
                    int lastIndent = IndentUtils.lineIndent((Document)this.basedoc, (int)lastLineStart);
                    int baseIndent = this.indentLevel + this.spacesPerTab;
                    int indentShift = baseIndent - lastIndent;
                    for (int lno = 0; lno < this.lineCount; ++lno) {
                        int lineEnd = LineDocumentUtils.getLineEnd((LineDocument)this.basedoc, (int)currentOffset);
                        int desiredIndent = lno == 0 || lno == this.lineCount - 1 ? baseIndent : IndentUtils.lineIndent((Document)this.basedoc, (int)currentOffset) + indentShift;
                        if ((currentOffset >= startOffset || currentOffset + this.lineSizes[lno] > endOffset) && currentOffset < endOffset) {
                            this.tags.add(new TokenIndent(false, currentOffset, Math.max(0, desiredIndent)));
                        }
                        currentOffset += this.lineSizes[lno] + 1;
                    }
                    break;
                }
                case CDATA_SECTION: {
                    this.contentPresent = true;
                    this.onlyTags = false;
                    this.wasNewline = false;
                }
                case CHARACTER: 
                case OPERATOR: 
                case PI_TARGET: 
                case DECLARATION: {
                    break;
                }
                case ARGUMENT: {
                    this.attributeName();
                    break;
                }
                case VALUE: {
                    this.attributeValue();
                    break;
                }
                default: {
                    throw new IOException("Invalid token found in document: Please use the text editor to resolve the issues...");
                }
            }
            this.currentTokensSize += image.length();
            if (tokenId == XMLTokenId.WS || tokenId == XMLTokenId.TEXT || tokenId == XMLTokenId.PI_CONTENT) continue;
            this.wasNewline = false;
        }
        return this.tags;
    }

    void reformat(Context context) throws BadLocationException {
        this.reformat(context, context.startOffset(), context.endOffset());
    }

    private class TokenIndent {
        private TokenElement token;
        private boolean preserveIndent;
        private int serial;
        private boolean noNewline;
        private int indentLevel;
        private int startOffset;
        private CharSequence tagName;

        public TokenIndent(TokenElement token, boolean preserveIndent, int startOffset, int indentLevel) {
            this(preserveIndent, startOffset, indentLevel);
        }

        public TokenIndent(boolean preserveIndent, int startOffset, int indentLevel) {
            this.serial = ++XMLLexerFormatter.this.counter;
            this.preserveIndent = preserveIndent;
            this.startOffset = startOffset;
            this.indentLevel = Math.max(0, indentLevel);
        }

        public TokenIndent(CharSequence tagName, boolean preserveIndent, int startOffset, int indentLevel) {
            this(preserveIndent, startOffset, indentLevel);
            this.tagName = tagName;
        }

        public int getIndentLevel() {
            return this.indentLevel;
        }

        public void markNoNewline() {
            this.noNewline = true;
        }

        public boolean isNoNewline() {
            return this.noNewline;
        }

        public TokenElement getToken() {
            return this.token;
        }

        public boolean isPreserveIndent() {
            return this.preserveIndent;
        }

        public int getStartOffset() {
            return this.startOffset;
        }

        public void setPreserveIndent(boolean preserveIndent) {
            this.preserveIndent = preserveIndent;
        }

        public String toString() {
            return "TokenIndent: name=" + this.token.getName() + " preserveIndent=" + this.preserveIndent;
        }

        public CharSequence getName() {
            return this.tagName;
        }
    }
}

