/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.text.navigator.base;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.explorer.view.TreeView;
import org.openide.loaders.DataObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public abstract class AbstractXMLNavigatorContent
extends JPanel
implements ExplorerManager.Provider,
PropertyChangeListener {
    protected ExplorerManager explorerManager = new ExplorerManager();
    protected TreeView treeView;
    private final JPanel emptyPanel;
    private JLabel msgLabel;
    private Icon waitIcon;
    public static String ERROR_NO_DATA_AVAILABLE = "LBL_NotAvailable";
    public static String ERROR_TOO_LARGE_DOCUMENT = "LBL_TooLarge";
    public static String ERROR_CANNOT_NAVIGATE = "LBL_CannotNavigate";

    public AbstractXMLNavigatorContent() {
        this.explorerManager.addPropertyChangeListener((PropertyChangeListener)this);
        this.treeView = new BeanTreeView();
        this.setBackground(UIManager.getColor("Tree.textBackground"));
        this.emptyPanel = new JPanel();
        this.emptyPanel.setBackground(UIManager.getColor("Tree.textBackground"));
        this.emptyPanel.setLayout(new BorderLayout());
        this.msgLabel = new JLabel();
        this.emptyPanel.add((Component)this.msgLabel, "Center");
    }

    public abstract void navigate(DataObject var1);

    public void release() {
        this.removeAll();
        this.repaint();
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
    }

    public ExplorerManager getExplorerManager() {
        return this.explorerManager;
    }

    public void showWaitNode() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AbstractXMLNavigatorContent.this.treeView.setRootVisible(true);
                AbstractXMLNavigatorContent.this.explorerManager.setRootContext((Node)new WaitNode());
            }
        });
    }

    protected boolean isLoading() {
        return false;
    }

    public void showError(final String message) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){
                final /* synthetic */ AbstractXMLNavigatorContent this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    this.this$0.showError(message);
                }
            });
            return;
        }
        this.removeAll();
        this.msgLabel.setIcon(null);
        this.msgLabel.setForeground(Color.GRAY);
        this.msgLabel.setText(NbBundle.getMessage(AbstractXMLNavigatorContent.class, (String)message));
        this.msgLabel.setHorizontalAlignment(0);
        this.add((Component)this.emptyPanel, "Center");
        this.revalidate();
        this.repaint();
    }

    public void showWaitPanel() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (!AbstractXMLNavigatorContent.this.isLoading()) {
                        return;
                    }
                    AbstractXMLNavigatorContent.this.showWaitPanel();
                }
            });
        }
        this.removeAll();
        if (this.waitIcon == null) {
            this.waitIcon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/xml/text/navigator/resources/wait.gif", (boolean)false);
        }
        this.msgLabel.setIcon(this.waitIcon);
        this.msgLabel.setHorizontalAlignment(2);
        this.msgLabel.setForeground(Color.BLACK);
        this.msgLabel.setText(NbBundle.getMessage(AbstractXMLNavigatorContent.class, (String)"LBL_Wait"));
        this.add((Component)this.emptyPanel, "North");
        this.revalidate();
        this.repaint();
    }

    private static class WaitNode
    extends AbstractNode {
        private Image waitIcon = ImageUtilities.loadImage((String)"org/netbeans/modules/xml/text/navigator/resources/wait.gif");

        WaitNode() {
            super(Children.LEAF);
        }

        public Image getIcon(int type) {
            return this.waitIcon;
        }

        public Image getOpenedIcon(int type) {
            return this.getIcon(type);
        }

        public String getDisplayName() {
            return NbBundle.getMessage(AbstractXMLNavigatorContent.class, (String)"LBL_Wait");
        }
    }
}

