/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.atoum.ui.customizer;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.php.api.executable.InvalidPhpExecutableException;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.api.util.UiUtils;
import org.netbeans.modules.php.api.validation.ValidationResult;
import org.netbeans.modules.php.atoum.commands.Atoum;
import org.netbeans.modules.php.atoum.preferences.AtoumPreferences;
import org.netbeans.modules.php.atoum.preferences.AtoumPreferencesValidator;
import org.netbeans.modules.php.atoum.ui.customizer.Bundle;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Pair;
import org.openide.util.RequestProcessor;

public class CustomizerAtoum
extends JPanel
implements HelpCtx.Provider {
    private static final RequestProcessor RP = new RequestProcessor(CustomizerAtoum.class);
    private final ProjectCustomizer.Category category;
    private final PhpModule phpModule;
    private JButton bootstrapBrowseButton;
    private JCheckBox bootstrapCheckBox;
    private JLabel bootstrapLabel;
    private JTextField bootstrapTextField;
    private JButton configurationBrowseButton;
    private JCheckBox configurationCheckBox;
    private JLabel configurationLabel;
    private JTextField configurationTextField;
    private JLabel configurationWarningLabel;
    private JButton createButton;
    private JLabel createLabel;
    private JButton scriptBrowseButton;
    private JCheckBox scriptCheckBox;
    private JLabel scriptLabel;
    private JTextField scriptTextField;

    CustomizerAtoum(ProjectCustomizer.Category category, PhpModule phpModule) {
        assert (category != null);
        assert (phpModule != null);
        this.category = category;
        this.phpModule = phpModule;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.initFile(AtoumPreferences.isBootstrapEnabled(this.phpModule), AtoumPreferences.getBootstrapPath(this.phpModule), this.bootstrapCheckBox, this.bootstrapTextField);
        this.initFile(AtoumPreferences.isConfigurationEnabled(this.phpModule), AtoumPreferences.getConfigurationPath(this.phpModule), this.configurationCheckBox, this.configurationTextField);
        this.initFile(AtoumPreferences.isAtoumEnabled(this.phpModule), AtoumPreferences.getAtoumPath(this.phpModule), this.scriptCheckBox, this.scriptTextField);
        this.enableFile(this.bootstrapCheckBox.isSelected(), this.bootstrapLabel, this.bootstrapTextField, this.bootstrapBrowseButton);
        this.enableFile(this.configurationCheckBox.isSelected(), this.configurationLabel, this.configurationTextField, this.configurationBrowseButton, this.configurationWarningLabel);
        this.enableFile(this.scriptCheckBox.isSelected(), this.scriptLabel, this.scriptTextField, this.scriptBrowseButton);
        this.addListeners();
        this.validateData();
        this.category.setStoreListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CustomizerAtoum.this.storeData();
            }
        });
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.netbeans.modules.php.atoum.ui.customizer.CustomizerAtoum");
    }

    void enableFile(boolean enabled, JComponent ... components) {
        for (JComponent component : components) {
            component.setEnabled(enabled);
        }
    }

    void validateData() {
        ValidationResult result = new AtoumPreferencesValidator().validateBootstrap(this.bootstrapCheckBox.isSelected(), this.bootstrapTextField.getText()).validateConfiguration(this.configurationCheckBox.isSelected(), this.configurationTextField.getText()).validateAtoum(this.scriptCheckBox.isSelected(), this.scriptTextField.getText()).getResult();
        Iterator iterator = result.getErrors().iterator();
        if (iterator.hasNext()) {
            ValidationResult.Message message = (ValidationResult.Message)iterator.next();
            this.category.setErrorMessage(message.getMessage());
            this.category.setValid(false);
            return;
        }
        iterator = result.getWarnings().iterator();
        if (iterator.hasNext()) {
            ValidationResult.Message message = (ValidationResult.Message)iterator.next();
            this.category.setErrorMessage(message.getMessage());
            this.category.setValid(true);
            return;
        }
        this.category.setErrorMessage(null);
        this.category.setValid(true);
    }

    void storeData() {
        AtoumPreferences.setBootstrapEnabled(this.phpModule, this.bootstrapCheckBox.isSelected());
        AtoumPreferences.setBootstrapPath(this.phpModule, this.bootstrapTextField.getText());
        AtoumPreferences.setConfigurationEnabled(this.phpModule, this.configurationCheckBox.isSelected());
        AtoumPreferences.setConfigurationPath(this.phpModule, this.configurationTextField.getText());
        AtoumPreferences.setAtoumEnabled(this.phpModule, this.scriptCheckBox.isSelected());
        AtoumPreferences.setAtoumPath(this.phpModule, this.scriptTextField.getText());
    }

    private void initFile(boolean enabled, String file, JCheckBox checkBox, JTextField textField) {
        checkBox.setSelected(enabled);
        textField.setText(file);
    }

    private void addListeners() {
        DefaultDocumentListener defaultDocumentListener = new DefaultDocumentListener();
        this.bootstrapCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                CustomizerAtoum.this.enableFile(e.getStateChange() == 1, CustomizerAtoum.this.bootstrapLabel, CustomizerAtoum.this.bootstrapTextField, CustomizerAtoum.this.bootstrapBrowseButton);
                CustomizerAtoum.this.validateData();
            }
        });
        this.bootstrapTextField.getDocument().addDocumentListener(defaultDocumentListener);
        this.configurationCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                CustomizerAtoum.this.enableFile(e.getStateChange() == 1, CustomizerAtoum.this.configurationLabel, CustomizerAtoum.this.configurationTextField, CustomizerAtoum.this.configurationBrowseButton, CustomizerAtoum.this.configurationWarningLabel);
                CustomizerAtoum.this.validateData();
            }
        });
        this.configurationTextField.getDocument().addDocumentListener(defaultDocumentListener);
        this.scriptCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                CustomizerAtoum.this.enableFile(e.getStateChange() == 1, CustomizerAtoum.this.scriptLabel, CustomizerAtoum.this.scriptTextField, CustomizerAtoum.this.scriptBrowseButton);
                CustomizerAtoum.this.validateData();
            }
        });
        this.scriptTextField.getDocument().addDocumentListener(defaultDocumentListener);
    }

    private File getDefaultDirectory() {
        File defaultDirectory;
        FileObject testDirectory = this.phpModule.getTestDirectory(null);
        if (testDirectory != null) {
            defaultDirectory = FileUtil.toFile((FileObject)testDirectory);
        } else {
            FileObject sourcesDirectory = this.phpModule.getSourceDirectory();
            assert (sourcesDirectory != null);
            defaultDirectory = FileUtil.toFile((FileObject)sourcesDirectory);
        }
        assert (defaultDirectory != null);
        return defaultDirectory;
    }

    private boolean checkTestDirectory() {
        if (this.phpModule.getTestDirectory(null) == null) {
            this.informUser(Bundle.CustomizerAtoum_error_noTestDir());
            return false;
        }
        return true;
    }

    boolean checkFile(File file, String errorMessage) {
        assert (file != null);
        if (file.exists()) {
            this.informUser(errorMessage);
            return false;
        }
        return true;
    }

    private void informUser(String message) {
        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)message, 1));
    }

    private void initComponents() {
        this.bootstrapCheckBox = new JCheckBox();
        this.bootstrapLabel = new JLabel();
        this.bootstrapTextField = new JTextField();
        this.bootstrapBrowseButton = new JButton();
        this.configurationCheckBox = new JCheckBox();
        this.configurationLabel = new JLabel();
        this.configurationTextField = new JTextField();
        this.configurationBrowseButton = new JButton();
        this.configurationWarningLabel = new JLabel();
        this.scriptCheckBox = new JCheckBox();
        this.scriptLabel = new JLabel();
        this.scriptTextField = new JTextField();
        this.scriptBrowseButton = new JButton();
        this.createLabel = new JLabel();
        this.createButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.bootstrapCheckBox, (String)NbBundle.getMessage(CustomizerAtoum.class, (String)"CustomizerAtoum.bootstrapCheckBox.text"));
        this.bootstrapLabel.setLabelFor(this.bootstrapTextField);
        Mnemonics.setLocalizedText((JLabel)this.bootstrapLabel, (String)NbBundle.getMessage(CustomizerAtoum.class, (String)"CustomizerAtoum.bootstrapLabel.text"));
        this.bootstrapTextField.setColumns(20);
        Mnemonics.setLocalizedText((AbstractButton)this.bootstrapBrowseButton, (String)NbBundle.getMessage(CustomizerAtoum.class, (String)"CustomizerAtoum.bootstrapBrowseButton.text"));
        this.bootstrapBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerAtoum.this.bootstrapBrowseButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.configurationCheckBox, (String)NbBundle.getMessage(CustomizerAtoum.class, (String)"CustomizerAtoum.configurationCheckBox.text"));
        this.configurationLabel.setLabelFor(this.configurationTextField);
        Mnemonics.setLocalizedText((JLabel)this.configurationLabel, (String)NbBundle.getMessage(CustomizerAtoum.class, (String)"CustomizerAtoum.configurationLabel.text"));
        this.configurationTextField.setColumns(20);
        Mnemonics.setLocalizedText((AbstractButton)this.configurationBrowseButton, (String)NbBundle.getMessage(CustomizerAtoum.class, (String)"CustomizerAtoum.configurationBrowseButton.text"));
        this.configurationBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerAtoum.this.configurationBrowseButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.configurationWarningLabel, (String)NbBundle.getMessage(CustomizerAtoum.class, (String)"CustomizerAtoum.configurationWarningLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.scriptCheckBox, (String)NbBundle.getMessage(CustomizerAtoum.class, (String)"CustomizerAtoum.scriptCheckBox.text"));
        this.scriptLabel.setLabelFor(this.scriptTextField);
        Mnemonics.setLocalizedText((JLabel)this.scriptLabel, (String)NbBundle.getMessage(CustomizerAtoum.class, (String)"CustomizerAtoum.scriptLabel.text"));
        this.scriptTextField.setColumns(20);
        Mnemonics.setLocalizedText((AbstractButton)this.scriptBrowseButton, (String)NbBundle.getMessage(CustomizerAtoum.class, (String)"CustomizerAtoum.scriptBrowseButton.text"));
        this.scriptBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerAtoum.this.scriptBrowseButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.createLabel, (String)NbBundle.getMessage(CustomizerAtoum.class, (String)"CustomizerAtoum.createLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.createButton, (String)NbBundle.getMessage(CustomizerAtoum.class, (String)"CustomizerAtoum.createButton.text"));
        this.createButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerAtoum.this.createButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.createLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.createButton)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.bootstrapCheckBox).addComponent(this.configurationCheckBox).addComponent(this.scriptCheckBox)).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGap(21, 21, 21).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.configurationWarningLabel).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.bootstrapLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bootstrapTextField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bootstrapBrowseButton)).addGroup(layout.createSequentialGroup().addComponent(this.configurationLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.configurationTextField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.configurationBrowseButton)).addGroup(layout.createSequentialGroup().addComponent(this.scriptLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.scriptTextField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.scriptBrowseButton)))));
        layout.linkSize(0, this.bootstrapBrowseButton, this.configurationBrowseButton, this.createButton, this.scriptBrowseButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.bootstrapCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.bootstrapLabel).addComponent(this.bootstrapTextField, -2, -1, -2).addComponent(this.bootstrapBrowseButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.configurationCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.configurationLabel).addComponent(this.configurationTextField, -2, -1, -2).addComponent(this.configurationBrowseButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.configurationWarningLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.scriptCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.scriptLabel).addComponent(this.scriptTextField, -2, -1, -2).addComponent(this.scriptBrowseButton)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.createLabel).addComponent(this.createButton))));
    }

    private void bootstrapBrowseButtonActionPerformed(ActionEvent evt) {
        File file = new FileChooserBuilder(CustomizerAtoum.class).setTitle(Bundle.CustomizerAtoum_chooser_bootstrap()).setFilesOnly(true).setDefaultWorkingDirectory(this.getDefaultDirectory()).forceUseOfDefaultWorkingDirectory(true).showOpenDialog();
        if (file != null) {
            this.bootstrapTextField.setText(file.getAbsolutePath());
        }
    }

    private void configurationBrowseButtonActionPerformed(ActionEvent evt) {
        File file = new FileChooserBuilder(CustomizerAtoum.class).setTitle(Bundle.CustomizerAtoum_chooser_configuration()).setFilesOnly(true).setDefaultWorkingDirectory(this.getDefaultDirectory()).forceUseOfDefaultWorkingDirectory(true).showOpenDialog();
        if (file != null) {
            this.configurationTextField.setText(file.getAbsolutePath());
        }
    }

    private void createButtonActionPerformed(ActionEvent evt) {
        if (!this.checkTestDirectory()) {
            return;
        }
        RP.post(new Runnable(){

            @Override
            public void run() {
                Atoum atoum;
                final File bootstrap = Atoum.getDefaultBootstrap(CustomizerAtoum.this.phpModule);
                assert (bootstrap != null);
                if (!CustomizerAtoum.this.checkFile(bootstrap, Bundle.CustomizerAtoum_error_bootstrap_exists(bootstrap.getAbsolutePath()))) {
                    return;
                }
                final File configuration = Atoum.getDefaultConfiguration(CustomizerAtoum.this.phpModule);
                assert (configuration != null);
                if (!CustomizerAtoum.this.checkFile(configuration, Bundle.CustomizerAtoum_error_configuration_exists(configuration.getAbsolutePath()))) {
                    return;
                }
                try {
                    atoum = Atoum.getDefault();
                }
                catch (InvalidPhpExecutableException ex) {
                    UiUtils.invalidScriptProvided((String)ex.getLocalizedMessage(), (String)"FrameworksAndTools/atoum");
                    return;
                }
                assert (atoum != null);
                final Pair<File, File> files = atoum.init(CustomizerAtoum.this.phpModule);
                if (files == null) {
                    return;
                }
                EventQueue.invokeLater(new Runnable(){
                    final /* synthetic */ 9 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    @Override
                    public void run() {
                        assert (bootstrap.equals(files.first())) : bootstrap + " should equal " + files.first();
                        assert (bootstrap.isFile()) : bootstrap;
                        this.this$1.CustomizerAtoum.this.bootstrapCheckBox.setSelected(true);
                        this.this$1.CustomizerAtoum.this.bootstrapTextField.setText(bootstrap.getAbsolutePath());
                        assert (configuration.equals(files.second())) : configuration + " should equal " + files.second();
                        assert (configuration.isFile()) : configuration;
                        this.this$1.CustomizerAtoum.this.configurationCheckBox.setSelected(true);
                        this.this$1.CustomizerAtoum.this.configurationTextField.setText(configuration.getAbsolutePath());
                    }
                });
            }
        });
    }

    private void scriptBrowseButtonActionPerformed(ActionEvent evt) {
        File file = new FileChooserBuilder(CustomizerAtoum.class).setTitle(Bundle.CustomizerAtoum_chooser_atoum()).setFilesOnly(true).setDefaultWorkingDirectory(this.getDefaultDirectory()).forceUseOfDefaultWorkingDirectory(true).showOpenDialog();
        if (file != null) {
            this.scriptTextField.setText(file.getAbsolutePath());
        }
    }

    private final class DefaultDocumentListener
    implements DocumentListener {
        private DefaultDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        private void processUpdate() {
            CustomizerAtoum.this.validateData();
        }
    }
}

