/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.api;

import java.beans.PropertyChangeSupport;
import java.util.Map;
import javax.servlet.jsp.tagext.TagLibraryInfo;

public final class JspColoringData
extends PropertyChangeSupport {
    public static final String PROP_COLORING_CHANGE = "coloringChange";
    public static final String PROP_PARSING_SUCCESSFUL = "parsingSuccessful";
    public static final String PROP_PARSING_IN_PROGRESS = "parsingInProgress";
    private Map<String, TagLibraryInfo> taglibs;
    private Map<String, String> prefixMapper;
    private boolean elIgnored = false;
    private boolean xmlSyntax = false;
    private boolean initialized = false;

    public JspColoringData(Object sourceBean) {
        super(sourceBean);
    }

    public Map getPrefixMapper() {
        return this.prefixMapper;
    }

    public String toString() {
        return "JSPColoringData, taglibMap:\n" + (this.prefixMapper == null ? "null" : JspColoringData.mapToString(this.prefixMapper, "  "));
    }

    private static String mapToString(Map m, String indent) {
        StringBuffer sb = new StringBuffer();
        for (Object key : m.keySet()) {
            sb.append(indent).append(key).append(" -> ").append(m.get(key)).append("\n");
        }
        return sb.toString();
    }

    public boolean isTagLibRegistered(String prefix) {
        if (this.taglibs == null || this.prefixMapper == null) {
            return false;
        }
        return this.prefixMapper.containsKey(prefix);
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public boolean isELIgnored() {
        return this.elIgnored;
    }

    public boolean isXMLSyntax() {
        return this.xmlSyntax;
    }

    public void parsingStarted() {
        this.firePropertyChange(PROP_PARSING_IN_PROGRESS, null, (Object)true);
    }

    public void applyParsedData(Map<String, TagLibraryInfo> newTaglibs, Map<String, String> newPrefixMapper, boolean newELIgnored, boolean newXMLSyntax, boolean parseSuccessful) {
        this.initialized = true;
        boolean coloringSame = JspColoringData.equalsColoringInformation(this.taglibs, this.prefixMapper, newTaglibs, newPrefixMapper);
        this.firePropertyChange(PROP_PARSING_SUCCESSFUL, null, (Object)parseSuccessful);
        if (parseSuccessful) {
            coloringSame = coloringSame && this.elIgnored == newELIgnored;
            this.elIgnored = newELIgnored;
        }
        if (this.taglibs == null && this.prefixMapper == null) {
            boolean bl = coloringSame = newELIgnored == this.elIgnored && newXMLSyntax == this.xmlSyntax && newTaglibs.isEmpty() && newPrefixMapper.isEmpty();
        }
        if (newXMLSyntax != this.xmlSyntax) {
            this.xmlSyntax = newXMLSyntax;
            coloringSame = false;
        }
        if (parseSuccessful || this.taglibs == null || this.prefixMapper == null) {
            this.taglibs = newTaglibs;
            this.prefixMapper = newPrefixMapper;
        } else {
            for (String prefix : newPrefixMapper.keySet()) {
                TagLibraryInfo newTaglib;
                String uri = newPrefixMapper.get(prefix);
                String uriOld = this.prefixMapper.get(prefix);
                if (uriOld != null && uri.equals(uriOld) || (newTaglib = newTaglibs.get(uri)) == null) continue;
                this.prefixMapper.put(prefix, uri);
                this.taglibs.put(uri, newTaglib);
            }
        }
        if (!coloringSame) {
            this.firePropertyChange(PROP_COLORING_CHANGE, null, null);
        }
    }

    private static boolean equalsColoringInformation(Map<String, TagLibraryInfo> taglibs1, Map<String, String> prefixMapper1, Map<String, TagLibraryInfo> taglibs2, Map<String, String> prefixMapper2) {
        if (taglibs1 == null != (taglibs2 == null)) {
            return false;
        }
        if (prefixMapper1 == null != (prefixMapper2 == null)) {
            return false;
        }
        if (prefixMapper1.size() != prefixMapper2.size()) {
            return false;
        }
        for (String prefix : prefixMapper1.keySet()) {
            String key1 = prefixMapper1.get(prefix);
            String key2 = prefixMapper2.get(prefix);
            if (key1 == null || key2 == null) {
                return false;
            }
            TagLibraryInfo tli1 = taglibs1.get(key1);
            TagLibraryInfo tli2 = taglibs2.get(key2);
            if (tli1 == null || tli2 == null) {
                return false;
            }
            if (JspColoringData.equalsColoringInformation(tli1, tli2)) continue;
            return false;
        }
        return true;
    }

    private static boolean equalsColoringInformation(TagLibraryInfo tli1, TagLibraryInfo tli2) {
        return true;
    }
}

