/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.jsploader;

import java.io.File;
import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.deployment.devmodules.api.JSPServletFinder;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.core.jsploader.JspCompileUtil;
import org.netbeans.modules.web.core.jsploader.JspDataObject;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;

public class CompileData {
    private JspDataObject jspPage;
    private FileObject docRoot;
    private String servletEncoding;
    private File servletJavaRoot;
    private String servletResourceName;

    public CompileData(JspDataObject jspPage) {
        this.jspPage = jspPage;
        WebModule wm = WebModule.getWebModule((FileObject)jspPage.getPrimaryFile());
        if (wm != null) {
            this.docRoot = wm.getDocumentBase();
            if (this.docRoot == null) {
                Project project = FileOwnerQuery.getOwner((FileObject)jspPage.getPrimaryFile());
                this.docRoot = project.getProjectDirectory();
            }
            String jspResourcePath = JspCompileUtil.findRelativeContextPath(this.docRoot, jspPage.getPrimaryFile());
            JSPServletFinder finder = JSPServletFinder.findJSPServletFinder((FileObject)this.docRoot);
            this.servletJavaRoot = finder.getServletTempDirectory();
            this.servletResourceName = finder.getServletResourcePath(jspResourcePath);
            this.servletEncoding = finder.getServletEncoding(jspResourcePath);
        }
    }

    public FileObject getServletJavaRoot() {
        if (this.servletJavaRoot != null && this.servletJavaRoot.exists()) {
            return FileUtil.toFileObject((File)this.servletJavaRoot);
        }
        return null;
    }

    public String getServletResourceName() {
        return this.servletResourceName;
    }

    private File getServletFile() {
        if (this.servletJavaRoot == null) {
            return null;
        }
        URI rootURI = this.servletJavaRoot.toURI();
        URI servletURI = rootURI.resolve(this.servletResourceName);
        return new File(servletURI);
    }

    public FileObject getServletFileObject() {
        FileObject root = this.getServletJavaRoot();
        if (root == null) {
            return null;
        }
        File servlet = this.getServletFile();
        if (servlet == null || !servlet.exists()) {
            return null;
        }
        FileObject fo = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)servlet));
        if (fo != null) {
            return fo;
        }
        try {
            root.getFileSystem().refresh(false);
            return root.getFileObject(this.getServletResourceName());
        }
        catch (FileStateInvalidException e) {
            Logger.getLogger("global").log(Level.INFO, null, e);
            return null;
        }
    }

    public String getServletEncoding() {
        return this.servletEncoding;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("--COMPILE DATA--");
        sb.append("\n");
        sb.append("JSP page        : " + FileUtil.getFileDisplayName((FileObject)this.jspPage.getPrimaryFile()));
        sb.append("\n");
        sb.append("servletJavaRoot : " + this.servletJavaRoot + ", exists= " + (this.servletJavaRoot == null ? "false" : "" + this.servletJavaRoot.exists()));
        sb.append("\n");
        sb.append("servletResource : " + this.servletResourceName + ", fileobject exists= " + (this.getServletFileObject() != null));
        sb.append("\n");
        File sf = this.getServletFile();
        if (sf != null) {
            sb.append("servletFile : " + sf.getAbsolutePath() + ", exists= " + this.getServletFile().exists());
        } else {
            sb.append("servletFile : null");
        }
        sb.append("\n");
        sb.append("--end COMPILE DATA--");
        return sb.toString();
    }
}

