/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.wizards.targetpanel.providers;

import java.awt.event.ItemEvent;
import javax.swing.JPanel;
import org.netbeans.modules.target.iterator.api.TargetChooserPanel;
import org.netbeans.modules.target.iterator.api.TargetChooserPanelGUI;
import org.netbeans.modules.web.wizards.FileType;
import org.netbeans.modules.web.wizards.targetpanel.providers.JSFTargetPanelProvider;
import org.netbeans.modules.web.wizards.targetpanel.providers.JspTargetPanelProvider;
import org.netbeans.modules.web.wizards.targetpanel.providers.XmlOptionPanelManager;
import org.openide.util.NbBundle;

class JspUIManager
extends XmlOptionPanelManager {
    JspUIManager() {
    }

    @Override
    public void initComponents(JPanel mainPanel, TargetChooserPanel<FileType> panel, TargetChooserPanelGUI<FileType> uiPanel) {
        super.initComponents(mainPanel, panel, uiPanel);
        uiPanel.setNameLabel(NbBundle.getMessage(JspTargetPanelProvider.class, (String)"LBL_JspName"));
        this.getJspSyntaxButton().setText(NbBundle.getMessage(JspTargetPanelProvider.class, (String)"OPT_JspSyntax"));
        this.getJspSyntaxButton().getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JspTargetPanelProvider.class, (String)"DESC_JSP"));
        this.getXmlSyntaxButton().setText(NbBundle.getMessage(JspTargetPanelProvider.class, (String)"OPT_XmlSyntax"));
        this.getXmlSyntaxButton().getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JspTargetPanelProvider.class, (String)"DESC_JSP_XML"));
        this.getSegmentBox().setText(NbBundle.getMessage(JspTargetPanelProvider.class, (String)"OPT_JspSegment"));
        this.getSegmentBox().getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JspTargetPanelProvider.class, (String)"A11Y_DESC_JSP_segment"));
        this.getDescription().setText(NbBundle.getMessage(JspTargetPanelProvider.class, (String)"DESC_JSP"));
    }

    @Override
    protected int initSyntaxButton(int grid, TargetChooserPanel<FileType> panel, TargetChooserPanelGUI<FileType> uiPanel) {
        int result = super.initSyntaxButton(grid, panel, uiPanel);
        this.getJspSyntaxButton().setMnemonic(NbBundle.getMessage(JspTargetPanelProvider.class, (String)"A11Y_JspStandard_mnem").charAt(0));
        return result;
    }

    public String getAccessibleDescription() {
        return "jsp";
    }

    public String getErrorMessage(TargetChooserPanel<FileType> panel) {
        if (this.isSegment() && !panel.getComponent().getNormalizedFolder().startsWith("WEB-INF/jspf")) {
            return NbBundle.getMessage(JSFTargetPanelProvider.class, (String)"NOTE_segment");
        }
        return null;
    }

    public boolean isPanelValid() {
        return true;
    }

    @Override
    protected void checkBoxChanged(ItemEvent evt, TargetChooserPanel<FileType> panel, TargetChooserPanelGUI<FileType> uiPanel) {
        if (this.isSegment()) {
            if (this.isXml()) {
                this.getDescription().setText(NbBundle.getMessage(JspTargetPanelProvider.class, (String)"DESC_segment_XML"));
            } else {
                this.getDescription().setText(NbBundle.getMessage(JspTargetPanelProvider.class, (String)"DESC_segment"));
            }
            String createdFile = uiPanel.getFile();
            if (createdFile.endsWith("jspx")) {
                uiPanel.setFile(createdFile.substring(0, createdFile.length() - 1) + "f");
            } else if (createdFile.endsWith("jsp")) {
                uiPanel.setFile(createdFile + "f");
            }
        } else {
            String createdFile = uiPanel.getFile();
            if (this.isXml()) {
                this.getDescription().setText(NbBundle.getMessage(JspTargetPanelProvider.class, (String)"DESC_JSP_XML"));
                if (createdFile.endsWith("jspf")) {
                    uiPanel.setFile(createdFile.substring(0, createdFile.length() - 1) + "x");
                } else if (createdFile.endsWith("jsp")) {
                    uiPanel.setFile(createdFile + "x");
                } else {
                    uiPanel.setFile(createdFile.substring(0, createdFile.lastIndexOf(".") + 1) + "jspx");
                }
            } else {
                this.getSegmentBox().setEnabled(true);
                this.getDescription().setText(NbBundle.getMessage(JspTargetPanelProvider.class, (String)"DESC_JSP"));
                if (createdFile.endsWith("jspf") || createdFile.endsWith("jspx")) {
                    uiPanel.setFile(createdFile.substring(0, createdFile.length() - 1));
                } else {
                    uiPanel.setFile(createdFile.substring(0, createdFile.lastIndexOf(".") + 1) + "jsp");
                }
            }
        }
        panel.fireChange();
    }
}

