/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.snapshots;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.index.IndexModule;
import org.opensearch.index.IndexSettings;
import org.opensearch.snapshots.SnapshotId;
import org.opensearch.snapshots.SnapshotInUseDeletionException;

public class SnapshotUtils {
    public static void validateSnapshotsBackingAnyIndex(Map<String, IndexMetadata> metadata, List<SnapshotId> snapshotIds, String repoName) {
        HashMap uuidToSnapshotId = new HashMap();
        HashSet<String> snapshotsToBeNotDeleted = new HashSet<String>();
        snapshotIds.forEach(snapshotId -> uuidToSnapshotId.put(snapshotId.getUUID(), snapshotId));
        for (IndexMetadata indexMetadata : metadata.values()) {
            String snapshotId2;
            String storeType = indexMetadata.getSettings().get(IndexModule.INDEX_STORE_TYPE_SETTING.getKey());
            if (!IndexModule.Type.REMOTE_SNAPSHOT.match(storeType) || uuidToSnapshotId.get(snapshotId2 = indexMetadata.getSettings().get(IndexSettings.SEARCHABLE_SNAPSHOT_ID_UUID.getKey())) == null) continue;
            snapshotsToBeNotDeleted.add(((SnapshotId)uuidToSnapshotId.get(snapshotId2)).getName());
        }
        if (!snapshotsToBeNotDeleted.isEmpty()) {
            throw new SnapshotInUseDeletionException(repoName, ((Object)snapshotsToBeNotDeleted).toString(), "These remote snapshots are backing some indices and hence can't be deleted! No snapshots were deleted.");
        }
    }
}

