/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.commons.alerting.action;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.rest.RestRequest;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001BA\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\u0004\b\f\u0010\rB\u0011\b\u0016\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\f\u0010\u0010J\n\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0016R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001a\u0010\u000b\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0012\"\u0004\b\u001b\u0010\u001c\u00a8\u0006#"}, d2={"Lorg/opensearch/commons/alerting/action/IndexCommentRequest;", "Lorg/opensearch/action/ActionRequest;", "entityId", "", "entityType", "commentId", "seqNo", "", "primaryTerm", "method", "Lorg/opensearch/rest/RestRequest$Method;", "content", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;JJLorg/opensearch/rest/RestRequest$Method;Ljava/lang/String;)V", "sin", "Lorg/opensearch/core/common/io/stream/StreamInput;", "(Lorg/opensearch/core/common/io/stream/StreamInput;)V", "getEntityId", "()Ljava/lang/String;", "getEntityType", "getCommentId", "getSeqNo", "()J", "getPrimaryTerm", "getMethod", "()Lorg/opensearch/rest/RestRequest$Method;", "getContent", "setContent", "(Ljava/lang/String;)V", "validate", "Lorg/opensearch/action/ActionRequestValidationException;", "writeTo", "", "out", "Lorg/opensearch/core/common/io/stream/StreamOutput;", "common-utils"})
public final class IndexCommentRequest
extends ActionRequest {
    @NotNull
    private final String entityId;
    @NotNull
    private final String entityType;
    @NotNull
    private final String commentId;
    private final long seqNo;
    private final long primaryTerm;
    @NotNull
    private final RestRequest.Method method;
    @NotNull
    private String content;

    @NotNull
    public final String getEntityId() {
        return this.entityId;
    }

    @NotNull
    public final String getEntityType() {
        return this.entityType;
    }

    @NotNull
    public final String getCommentId() {
        return this.commentId;
    }

    public final long getSeqNo() {
        return this.seqNo;
    }

    public final long getPrimaryTerm() {
        return this.primaryTerm;
    }

    @NotNull
    public final RestRequest.Method getMethod() {
        return this.method;
    }

    @NotNull
    public final String getContent() {
        return this.content;
    }

    public final void setContent(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.content = string;
    }

    public IndexCommentRequest(@NotNull String entityId, @NotNull String entityType, @NotNull String commentId, long seqNo, long primaryTerm, @NotNull RestRequest.Method method, @NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)entityId, (String)"entityId");
        Intrinsics.checkNotNullParameter((Object)entityType, (String)"entityType");
        Intrinsics.checkNotNullParameter((Object)commentId, (String)"commentId");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        this.entityId = entityId;
        this.entityType = entityType;
        this.commentId = commentId;
        this.seqNo = seqNo;
        this.primaryTerm = primaryTerm;
        this.method = method;
        this.content = content;
    }

    public IndexCommentRequest(@NotNull StreamInput sin) throws IOException {
        Intrinsics.checkNotNullParameter((Object)sin, (String)"sin");
        String string = sin.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"readString(...)");
        String string2 = sin.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"readString(...)");
        String string3 = sin.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"readString(...)");
        long l = sin.readLong();
        long l2 = sin.readLong();
        Enum enum_ = sin.readEnum(RestRequest.Method.class);
        Intrinsics.checkNotNullExpressionValue((Object)enum_, (String)"readEnum(...)");
        RestRequest.Method method = (RestRequest.Method)enum_;
        String string4 = sin.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"readString(...)");
        this(string, string2, string3, l, l2, method, string4);
    }

    @Nullable
    public ActionRequestValidationException validate() {
        if (this.method == RestRequest.Method.POST && StringsKt.isBlank((CharSequence)this.entityId) || this.method == RestRequest.Method.PUT && StringsKt.isBlank((CharSequence)this.commentId)) {
            ActionRequestValidationException exception = new ActionRequestValidationException();
            exception.addValidationError("id must not be blank");
            return exception;
        }
        return null;
    }

    public void writeTo(@NotNull StreamOutput out) throws IOException {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out.writeString(this.entityId);
        out.writeString(this.entityType);
        out.writeString(this.commentId);
        out.writeLong(this.seqNo);
        out.writeLong(this.primaryTerm);
        out.writeEnum((Enum)this.method);
        out.writeString(this.content);
    }
}

