/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.transport.handler;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ExceptionsHelper;
import org.opensearch.ResourceAlreadyExistsException;
import org.opensearch.action.admin.indices.create.CreateIndexResponse;
import org.opensearch.cluster.block.ClusterBlockException;
import org.opensearch.cluster.block.ClusterBlockLevel;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.core.action.ActionListener;
import org.opensearch.timeseries.common.exception.TimeSeriesException;
import org.opensearch.timeseries.indices.IndexManagement;
import org.opensearch.timeseries.model.IndexableResult;
import org.opensearch.timeseries.ratelimit.ResultWriteRequest;
import org.opensearch.timeseries.transport.ResultBulkRequest;
import org.opensearch.transport.client.Client;

public abstract class IndexMemoryPressureAwareResultHandler<ResultType extends IndexableResult, ResultWriteRequestType extends ResultWriteRequest<ResultType>, BatchRequestType extends ResultBulkRequest<ResultType, ResultWriteRequestType>, BatchResponseType, IndexType extends Enum<IndexType>, IndexManagementType extends IndexManagement<IndexType>> {
    private static final Logger LOG = LogManager.getLogger(IndexMemoryPressureAwareResultHandler.class);
    protected final Client client;
    protected final IndexManagementType timeSeriesIndices;
    protected final ClusterService clusterService;

    public IndexMemoryPressureAwareResultHandler(Client client, IndexManagementType timeSeriesIndices, ClusterService clusterService) {
        this.client = client;
        this.timeSeriesIndices = timeSeriesIndices;
        this.clusterService = clusterService;
    }

    public void flush(BatchRequestType currentBulkRequest, ActionListener<BatchResponseType> listener) {
        ClusterBlockException blockException = this.clusterService.state().blocks().globalBlockedException(ClusterBlockLevel.WRITE);
        if (blockException != null) {
            listener.onFailure((Exception)new TimeSeriesException("Cannot save results due to write block."));
            return;
        }
        HashSet<String> customResultIndexOrAlias = new HashSet<String>();
        for (ResultWriteRequest result : ((ResultBulkRequest)((Object)currentBulkRequest)).getResults()) {
            if (result.getResultIndex() == null) continue;
            customResultIndexOrAlias.add(result.getResultIndex());
        }
        ArrayList<String> customResultIndexOrAliasList = new ArrayList<String>(customResultIndexOrAlias);
        if (!((IndexManagement)this.timeSeriesIndices).doesDefaultResultIndexExist()) {
            ((IndexManagement)this.timeSeriesIndices).initDefaultResultIndexDirectly((ActionListener<CreateIndexResponse>)ActionListener.wrap(initResponse -> {
                if (initResponse.isAcknowledged()) {
                    this.initCustomIndices(currentBulkRequest, customResultIndexOrAliasList, listener);
                } else {
                    LOG.warn("Creating result index with mappings call not acknowledged.");
                    listener.onFailure((Exception)new TimeSeriesException("", "Creating result index with mappings call not acknowledged."));
                }
            }, exception -> {
                if (ExceptionsHelper.unwrapCause((Throwable)exception) instanceof ResourceAlreadyExistsException) {
                    this.initCustomIndices(currentBulkRequest, customResultIndexOrAliasList, listener);
                } else {
                    LOG.warn("Unexpected error creating result index", (Throwable)exception);
                    listener.onFailure(exception);
                }
            }));
        } else {
            this.initCustomIndices(currentBulkRequest, customResultIndexOrAliasList, listener);
        }
    }

    private void initCustomIndices(BatchRequestType currentBulkRequest, List<String> customResultIndexOrAlias, ActionListener<BatchResponseType> listener) {
        this.initCustomIndicesIteration(0, currentBulkRequest, customResultIndexOrAlias, listener);
    }

    private void initCustomIndicesIteration(int i, BatchRequestType currentBulkRequest, List<String> customResultIndexOrAlias, ActionListener<BatchResponseType> listener) {
        if (i >= customResultIndexOrAlias.size()) {
            this.bulk(currentBulkRequest, listener);
            return;
        }
        String indexOrAliasName = customResultIndexOrAlias.get(i);
        if (!((IndexManagement)this.timeSeriesIndices).doesIndexExist(indexOrAliasName) && !((IndexManagement)this.timeSeriesIndices).doesAliasExist(indexOrAliasName)) {
            ((IndexManagement)this.timeSeriesIndices).initCustomResultIndexDirectly(indexOrAliasName, (ActionListener<CreateIndexResponse>)ActionListener.wrap(initResponse -> {
                if (initResponse.isAcknowledged()) {
                    this.initCustomIndicesIteration(i + 1, currentBulkRequest, customResultIndexOrAlias, listener);
                } else {
                    LOG.warn("Creating result index {} with mappings call not acknowledged.", (Object)indexOrAliasName);
                    this.initCustomIndicesIteration(i + 1, currentBulkRequest, customResultIndexOrAlias, listener);
                }
            }, exception -> {
                if (ExceptionsHelper.unwrapCause((Throwable)exception) instanceof ResourceAlreadyExistsException) {
                    this.initCustomIndicesIteration(i + 1, currentBulkRequest, customResultIndexOrAlias, listener);
                } else {
                    LOG.warn("Unexpected error creating result index", (Throwable)exception);
                    this.initCustomIndicesIteration(i + 1, currentBulkRequest, customResultIndexOrAlias, listener);
                }
            }));
        } else {
            this.bulk(currentBulkRequest, listener);
        }
    }

    protected abstract void bulk(BatchRequestType var1, ActionListener<BatchResponseType> var2);
}

