/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.commons.authuser.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Base64;
import org.opensearch.OpenSearchException;
import org.opensearch.commons.authuser.util.SafeSerializationUtils;
import org.opensearch.core.common.Strings;

public class Base64Helper {
    public static String serializeObject(Serializable object) {
        assert (object != null);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try (ObjectOutputStream out = SafeObjectOutputStream.create(bos);){
            out.writeObject(object);
        }
        catch (Exception e) {
            throw new OpenSearchException("Instance {} of class {} is not serializable", (Throwable)e, new Object[]{object, object.getClass()});
        }
        byte[] bytes = bos.toByteArray();
        return Base64.getEncoder().encodeToString(bytes);
    }

    public static Serializable deserializeObject(String string) {
        Serializable serializable;
        assert (!Strings.isNullOrEmpty((String)string));
        byte[] bytes = Base64.getDecoder().decode(string);
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        SafeObjectInputStream in = new SafeObjectInputStream(bis);
        try {
            serializable = (Serializable)in.readObject();
        }
        catch (Throwable throwable) {
            try {
                try {
                    in.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new OpenSearchException((Throwable)e);
            }
        }
        in.close();
        return serializable;
    }

    private static final class SafeObjectOutputStream
    extends ObjectOutputStream {
        static ObjectOutputStream create(ByteArrayOutputStream out) throws IOException {
            return new SafeObjectOutputStream(out);
        }

        private SafeObjectOutputStream(OutputStream out) throws IOException {
            super(out);
            this.enableReplaceObject(true);
        }

        @Override
        protected Object replaceObject(Object obj) throws IOException {
            Class<?> clazz = obj.getClass();
            if (SafeSerializationUtils.isSafeClass(clazz)) {
                return obj;
            }
            throw new IOException("Unauthorized serialization attempt " + clazz.getName());
        }
    }

    private static final class SafeObjectInputStream
    extends ObjectInputStream {
        public SafeObjectInputStream(InputStream in) throws IOException {
            super(in);
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            Class<?> clazz = super.resolveClass(desc);
            if (SafeSerializationUtils.isSafeClass(clazz)) {
                return clazz;
            }
            throw new InvalidClassException("Unauthorized deserialization attempt ", clazz.getName());
        }
    }
}

