function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) { ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) { o = n[r], -1 === t.indexOf(o) && {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) { if ({}.hasOwnProperty.call(r, n)) { if (-1 !== e.indexOf(n)) continue; t[n] = r[n]; } } return t; }
/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import React from 'react';
import PropTypes from "prop-types";
import classNames from 'classnames';
import { OuiPanel } from '../../panel/panel';
var verticalPositionToClassNameMap = {
  center: 'ouiPageContent--verticalCenter'
};
var horizontalPositionToClassNameMap = {
  center: 'ouiPageContent--horizontalCenter'
};
export var OuiPageContent = function OuiPageContent(_ref) {
  var verticalPosition = _ref.verticalPosition,
    horizontalPosition = _ref.horizontalPosition,
    panelPaddingSize = _ref.panelPaddingSize,
    _ref$paddingSize = _ref.paddingSize,
    paddingSize = _ref$paddingSize === void 0 ? 'l' : _ref$paddingSize,
    borderRadius = _ref.borderRadius,
    children = _ref.children,
    className = _ref.className,
    _ref$role = _ref.role,
    _role = _ref$role === void 0 ? 'main' : _ref$role,
    rest = _objectWithoutProperties(_ref, ["verticalPosition", "horizontalPosition", "panelPaddingSize", "paddingSize", "borderRadius", "children", "className", "role"]);
  var role = _role === null ? undefined : _role;
  var borderRadiusClass = borderRadius === 'none' ? 'ouiPageContent--borderRadiusNone' : '';
  var classes = classNames('ouiPageContent', borderRadiusClass, verticalPosition ? verticalPositionToClassNameMap[verticalPosition] : null, horizontalPosition ? horizontalPositionToClassNameMap[horizontalPosition] : null, className);
  return /*#__PURE__*/React.createElement(OuiPanel, _extends({
    className: classes,
    paddingSize: panelPaddingSize !== null && panelPaddingSize !== void 0 ? panelPaddingSize : paddingSize,
    borderRadius: borderRadius,
    role: role
  }, rest), children);
};

/* OUI -> EUI Aliases: Build-Time */
OuiPageContent.propTypes = {
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string,
  /**
     * Adds a medium shadow to the panel;
     * Only works when `color="plain"`
     */
  /**
     * Adds a medium shadow to the panel;
     * Only works when `color="plain"`
     */
  hasShadow: PropTypes.bool,
  /**
     * Adds a slight 1px border on all edges.
     * Only works when `color="plain | transparent"`
     * Default is `undefined` and will default to that theme's panel style
     */
  /**
     * Adds a slight 1px border on all edges.
     * Only works when `color="plain | transparent"`
     * Default is `undefined` and will default to that theme's panel style
     */
  hasBorder: PropTypes.bool,
  /**
     * Padding for all four sides
     */
  /**
     * Padding for all four sides
     */
  paddingSize: PropTypes.any,
  /**
     * Corner border radius
     */
  /**
     * Corner border radius
     */
  borderRadius: PropTypes.any,
  /**
     * When true the panel will grow in height to match `OuiFlexItem`
     */
  /**
     * When true the panel will grow in height to match `OuiFlexItem`
     */
  grow: PropTypes.bool,
  panelRef: PropTypes.any,
  /**
     * Background color of the panel;
     * Usually a lightened form of the brand colors
     */
  /**
     * Background color of the panel;
     * Usually a lightened form of the brand colors
     */
  color: PropTypes.any,
  element: PropTypes.oneOf(["div"]),
  /**
       * **DEPRECATED: use `paddingSize` instead.**
       */
  panelPaddingSize: PropTypes.any,
  verticalPosition: PropTypes.oneOf(["center"]),
  horizontalPosition: PropTypes.oneOf(["center"]),
  /**
       * There should only be one OuiPageContent per page and should contain the main contents.
       * If this is untrue, set role = `null`, or change it to match your needed aria role
       */
  role: PropTypes.oneOfType([PropTypes.any.isRequired, PropTypes.oneOf([null])])
};
/* OUI -> EUI Aliases: Build-Time */export { EuiPageContent } from '../../../eui_components/page/page_content/page_content';