/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.memory.action.conversation;

import java.util.List;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.core.action.ActionListener;
import org.opensearch.ml.common.conversation.Interaction;
import org.opensearch.ml.memory.ConversationalMemoryHandler;
import org.opensearch.ml.memory.action.conversation.GetTracesRequest;
import org.opensearch.ml.memory.action.conversation.GetTracesResponse;
import org.opensearch.ml.memory.index.OpenSearchConversationalMemoryHandler;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.Client;

public class GetTracesTransportAction
extends HandledTransportAction<GetTracesRequest, GetTracesResponse> {
    @Generated
    private static final Logger log = LogManager.getLogger(GetTracesTransportAction.class);
    private Client client;
    private ConversationalMemoryHandler cmHandler;

    @Inject
    public GetTracesTransportAction(TransportService transportService, ActionFilters actionFilters, OpenSearchConversationalMemoryHandler cmHandler, Client client) {
        super("cluster:admin/opensearch/ml/memory/trace/get", transportService, actionFilters, GetTracesRequest::new);
        this.client = client;
        this.cmHandler = cmHandler;
    }

    public void doExecute(Task task, GetTracesRequest request, ActionListener<GetTracesResponse> actionListener) {
        int maxResults = request.getMaxResults();
        int from = request.getFrom();
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().newStoredContext(true);){
            ActionListener internalListener = ActionListener.runBefore(actionListener, () -> context.restore());
            ActionListener al = ActionListener.wrap(tracesList -> internalListener.onResponse((Object)new GetTracesResponse((List<Interaction>)tracesList, from + maxResults, tracesList.size() == maxResults)), e -> internalListener.onFailure(e));
            this.cmHandler.getTraces(request.getInteractionId(), from, maxResults, (ActionListener<List<Interaction>>)al);
        }
        catch (Exception e2) {
            log.error("Failed to get traces for message " + request.getInteractionId(), (Throwable)e2);
            actionListener.onFailure(e2);
        }
    }
}

