/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.labs.mlrg.olcut.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.Locale;

public class CDateParser {
    static long _32_bit_seconds = 2147483647000L;
    LinkedList<DateFormat> dateFormats = new LinkedList();
    static String[] USFormatStrings = new String[]{"E, d MMM y h:m:s.S a z", "yyyy-MM-dd'T'H:m:s'Z'", "E, d MMM y h:m:s a z", "E, d MMM y h:m:s a", "E, d MMM y H:m:s z", "E, d MMM y H:m:s", "E, d MMM y z", "E, d MMM y", "E, MMM d y h:m:s a z", "E, MMM d y h:m:s a", "E, MMM d y H:m:s z", "E, MMM d y H:m:s", "E, MMM d y z", "E, MMM d y", "M/d/y h:m:s a z", "M/d/y h:m:s a", "M/d/y H:m:s z", "M/d/y H:m:s", "M/d/y z", "M/d/y", "M-d-y h:m:s a z", "M-d-y h:m:s a", "M-d-y H:m:s z", "M-d-y H:m:s", "M-d-y z", "M-d-y", "M.d.y h:m:s a z", "M.d.y h:m:s a", "M.d.y H:m:s z", "M.d.y H:m:s", "M.d.y z", "M.d.y", "MMM d y h:m:s a z", "MMM d y h:m:s a", "MMM d y H:m:s z", "MMM d y H:m:s", "MMM d y z", "MMM d y", "d MMM y h:m:s a z", "d MMM y h:m:s a", "d MMM y H:m:s z", "d MMM y H:m:s", "d MMM y z", "d MMM y", "E MMM d h:m:s a z y", "E MMM d H:m:s z y", "EEE, MMM d, ''yy", "h:mm a", "H:mm", "hh 'o''clock' a, zzzz", "yyyyy.MMMMM.dd GGG hh:mm aaa", "yyyyy.MMMMM.dd GGG HH:mm", "E,MMM d y z", "E,MMM d y", "E,d MMM y h:m:s a z", "E,d MMM yyyy h:m:s a z", "E,d MMM y h:m:s a", "E,d MMM yyyy h:m:s a", "E,d MMM y H:m:s z", "E,d MMM yyyy H:m:s z", "E,d MMM y H:m:s", "E,d MMM yyyy H:m:s", "E,d MMM y z", "E,d MMM yyyy z", "E,d MMM y", "E,d MMM yyyy", "E, d-MMM-y h:m:s a z", "E, d-MMM-y h:m:s a", "E, d-MMM-y H:m:s z", "E, d-MMM-y H:m:s", "E, d-MMM-y z", "E, d-MMM-y", "E MMM d h:m:s y a z", "E MMM d h:m:s y a", "E MMM d H:m:s y z", "E MMM d H:m:s y", "E MMM d y z", "E MMM d y", "dd-MMM-yyyy HH:mm:ss.SS", "d-MMM-y h:m:s a z", "d-MMM-y h:m:s a", "d-MMM-y H:m:s z", "d-MMM-y H:m:s", "d-MMM-y z", "d-MMM-y", "y-M-d", "M d y", "y M d", "MMM y"};

    public CDateParser() {
        for (String usFormatString : USFormatStrings) {
            this.dateFormats.add(new SimpleDateFormat(usFormatString, Locale.US));
        }
        this.dateFormats.add(DateFormat.getDateTimeInstance(0, 0));
        this.dateFormats.add(DateFormat.getDateInstance(0));
        this.dateFormats.add(DateFormat.getTimeInstance(0));
        this.dateFormats.add(DateFormat.getDateTimeInstance(1, 1));
        this.dateFormats.add(DateFormat.getDateInstance(1));
        this.dateFormats.add(DateFormat.getTimeInstance(1));
        this.dateFormats.add(DateFormat.getDateTimeInstance(2, 2));
        this.dateFormats.add(DateFormat.getDateInstance(2));
        this.dateFormats.add(DateFormat.getTimeInstance(2));
        this.dateFormats.add(DateFormat.getDateTimeInstance(3, 3));
        this.dateFormats.add(DateFormat.getDateInstance(3));
        this.dateFormats.add(DateFormat.getTimeInstance(3));
    }

    public Date parse(String date) throws ParseException {
        Date d = null;
        for (DateFormat dateFormat : this.dateFormats) {
            try {
                d = dateFormat.parse(date);
                return d;
            }
            catch (Exception exception) {
            }
        }
        if (d == null) {
            try {
                if (date.equals("0") || date.equalsIgnoreCase("now") || date.equalsIgnoreCase("today") || date.equalsIgnoreCase("immediately") || date.equalsIgnoreCase("expired")) {
                    return new Date();
                }
                if (date.equalsIgnoreCase("never")) {
                    return new Date(Long.MAX_VALUE);
                }
                if (date.startsWith("+")) {
                    date = date.substring(1);
                }
                long i = Long.parseLong(date);
                return new Date(new Date().getTime() + i * 24L * 60L * 60L * 1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw new ParseException("Date failed to parse", 0);
    }

    public static void main(String[] args) throws IOException {
        BufferedReader r = new BufferedReader(new InputStreamReader(System.in, StandardCharsets.UTF_8));
        String d = null;
        CDateParser dp = new CDateParser();
        while ((d = r.readLine()) != null) {
            try {
                Date date = dp.parse(d);
                System.out.format("Parsed: %s%n", date);
            }
            catch (ParseException ex) {
                System.out.format("%s failed to parse%n", d);
            }
        }
    }
}

