/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.internal.wrappers;

import org.bouncycastle.crypto.internal.BlockCipher;
import org.bouncycastle.crypto.internal.CipherParameters;
import org.bouncycastle.crypto.internal.Wrapper;
import org.bouncycastle.crypto.internal.params.KeyParameter;
import org.bouncycastle.crypto.internal.params.ParametersWithIV;

abstract class SP80038FWrapper
implements Wrapper {
    protected static final byte[] ivKW = new byte[]{-90, -90, -90, -90, -90, -90, -90, -90};
    protected static final byte[] ivKWP = new byte[]{-90, 89, 89, -90};
    protected final boolean wrapCipherMode;
    protected final BlockCipher engine;
    protected final int delta;
    protected final byte[] iv;
    protected KeyParameter param;
    protected boolean forWrapping;

    protected SP80038FWrapper(BlockCipher blockCipher, byte[] byArray, boolean bl) {
        this.engine = blockCipher;
        this.wrapCipherMode = !bl;
        this.delta = blockCipher.getBlockSize() / 2;
        this.iv = new byte[byArray.length > this.delta ? this.delta : byArray.length];
        System.arraycopy(byArray, 0, this.iv, 0, this.iv.length);
    }

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) {
        this.forWrapping = bl;
        if (cipherParameters instanceof KeyParameter) {
            this.param = (KeyParameter)cipherParameters;
        } else if (cipherParameters instanceof ParametersWithIV) {
            byte[] byArray = ((ParametersWithIV)cipherParameters).getIV();
            if (byArray.length != this.iv.length) {
                throw new IllegalArgumentException("IV not equal to " + ivKWP.length);
            }
            this.param = (KeyParameter)((ParametersWithIV)cipherParameters).getParameters();
            System.arraycopy(byArray, 0, this.iv, 0, this.iv.length);
        }
    }

    protected byte[] W(int n, byte[] byArray) {
        byte[] byArray2 = new byte[this.engine.getBlockSize()];
        this.engine.init(this.wrapCipherMode, this.param);
        for (int i = 0; i != 6; ++i) {
            for (int j = 1; j <= n; ++j) {
                System.arraycopy(byArray, 0, byArray2, 0, this.delta);
                System.arraycopy(byArray, this.delta * j, byArray2, this.delta, this.delta);
                this.engine.processBlock(byArray2, 0, byArray2, 0);
                int n2 = n * i + j;
                int n3 = 1;
                while (n2 != 0) {
                    byte by = (byte)n2;
                    int n4 = this.delta - n3;
                    byArray2[n4] = (byte)(byArray2[n4] ^ by);
                    n2 >>>= 8;
                    ++n3;
                }
                System.arraycopy(byArray2, 0, byArray, 0, this.delta);
                System.arraycopy(byArray2, this.delta, byArray, this.delta * j, this.delta);
            }
        }
        return byArray;
    }

    protected void invW(int n, byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[this.engine.getBlockSize()];
        this.engine.init(!this.wrapCipherMode, this.param);
        --n;
        for (int i = 5; i >= 0; --i) {
            for (int j = n; j >= 1; --j) {
                System.arraycopy(byArray2, 0, byArray3, 0, this.delta);
                System.arraycopy(byArray, this.delta * (j - 1), byArray3, this.delta, this.delta);
                int n2 = n * i + j;
                int n3 = 1;
                while (n2 != 0) {
                    byte by = (byte)n2;
                    int n4 = this.delta - n3;
                    byArray3[n4] = (byte)(byArray3[n4] ^ by);
                    n2 >>>= 8;
                    ++n3;
                }
                this.engine.processBlock(byArray3, 0, byArray3, 0);
                System.arraycopy(byArray3, 0, byArray2, 0, this.delta);
                System.arraycopy(byArray3, this.delta, byArray, this.delta * (j - 1), this.delta);
            }
        }
    }
}

