/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.referral;

import org.ldaptive.Connection;
import org.ldaptive.LdapURL;
import org.ldaptive.ModifyOperation;
import org.ldaptive.ModifyRequest;
import org.ldaptive.Operation;
import org.ldaptive.referral.AbstractReferralHandler;
import org.ldaptive.referral.ReferralConnectionFactory;

public class ModifyReferralHandler
extends AbstractReferralHandler<ModifyRequest, Void> {
    public ModifyReferralHandler() {
        this(10, 0, DEFAULT_CONNECTION_FACTORY);
    }

    public ModifyReferralHandler(ReferralConnectionFactory factory) {
        this(10, 0, factory);
    }

    public ModifyReferralHandler(int limit) {
        this(limit, 0, DEFAULT_CONNECTION_FACTORY);
    }

    public ModifyReferralHandler(int limit, ReferralConnectionFactory factory) {
        this(limit, 0, factory);
    }

    private ModifyReferralHandler(int limit, int depth, ReferralConnectionFactory factory) {
        super(limit, depth, factory);
    }

    @Override
    protected ModifyRequest createReferralRequest(ModifyRequest request, LdapURL url) {
        ModifyRequest referralRequest = new ModifyRequest();
        referralRequest.setControls(request.getControls());
        referralRequest.setIntermediateResponseHandlers(request.getIntermediateResponseHandlers());
        referralRequest.setReferralHandler(new ModifyReferralHandler(this.getReferralLimit(), this.getReferralDepth() + 1, this.getReferralConnectionFactory()));
        if (!url.getEntry().isDefaultBaseDn()) {
            referralRequest.setDn(url.getEntry().getBaseDn());
        } else {
            referralRequest.setDn(request.getDn());
        }
        referralRequest.setAttributeModifications(request.getAttributeModifications());
        return referralRequest;
    }

    @Override
    protected Operation<ModifyRequest, Void> createReferralOperation(Connection conn) {
        return new ModifyOperation(conn);
    }
}

